<?php

require_once SCRIPT_ROOT_PATH.'/class/object/class.object.php';
require_once SCRIPT_ROOT_PATH.'/class/object/class.link2tag.php';

/**
 * Tag object class
 * 
 * @author Jerome Loisel
 * @copyright Jerome Loisel
 * @package kernel
 **/
class Tag extends MyObject
{
	/**
	 * Tag constructor
	 * 
	 * @param array of vars to assign to Tag attributes
	 * 
	 * @return void
	 */
	function Tag($vars = null)
	{
		$table = "tag";
		$this->MyObject($table, $vars);
		
		$attributes = array(
		'id' => array('data_type' => XOBJ_DTYPE_INT, 'value' => null, 'maxlength' => '11'), 
		'uid' => array('data_type' => XOBJ_DTYPE_INT, 'value' => 0, 'maxlength' => '11'), 
		'tag' => array('data_type' => XOBJ_DTYPE_TXTBOX, 'value' => null, 'maxlength' => '255'), 
		'approved' => array('data_type' => XOBJ_DTYPE_INT, 'value' => null, 'maxlength' => '1') ); 
		
		$this->setAttributes($attributes);
	}
}


/**
 * Tag Manager class
 * 
 * @author Jerome Loisel
 * @copyright Jerome Loisel
 * @package kernel
 **/
class TagManager extends MyObjectManager
{
	/**
	 * Tag Manager constructor
	 * 
	 * do not instanciate this object directly
	 * use : get_manager("Tag"); instead
	 * 
	 * @return void
	 */
	function TagManager()
	{
		$specs = array(
		'table' => "tag", 
		'keyName' => 'id', 
		'className' => 'Tag' );
		
		$this->MyObjectManager($specs);
	}
	
	/*
	*	Insert a tag into database including link2tag
	*	@param	int		link id
	*	@param	string	tag
	*	@return	always TRUE
	*/
	function insertLinkTag($lid,$myTag)
	{
		$um =& get_manager('user');
		$l2tm =& get_manager('link2tag');
		$myTag = strip_tags($myTag);
		
		$criteria = new Criteria('tag',$myTag,'=');
		$criteria->setLimit(1);
		
		$tag_count =& $this->getCount($criteria);
		
		if($tag_count == 0)
		{
			// tag not existing in database
			$newTag = $this->create(true);
			
			$vars = array(	'uid' => $um->myUID(), 
							'tag' => $myTag, 
							'approved' => 1		);
			
			$newTag->setVars($vars);
			$this->insert($newTag);
		}
		
		$tags =& $this->getObjects($criteria,array('id'));
		
		if(count($tags) == 1)
		{
			foreach ($tags as $tag)
			{
				$link2tag = $l2tm->create(true);

				$l2t_vars = array(	'lid' => $lid, 
									'tid' => $tag->getVar('id') );
				
				$link2tag->setVars($l2t_vars);

				$l2tm->insert($link2tag);
			}
		}
		return true;
	}
	
	/*
	*	Returns all the tags associated to the specified link
	*	@param	int	link id
	*	@return	array	{@link Object}
	*/
	function getLinkTags($lid, $to_select=array())
	{
		$tags = array();
		$l2tm =& get_manager('link2tag');
		
		$criteria = new Criteria('lid',$lid,'=');
		
		$link2tags =& $l2tm->getObjects($criteria);
		
		if(count($link2tags) > 0)
		{
			$criterias = new CriteriaCompo(null,'OR');
			
			foreach($link2tags as $link2tag)
			{
				$tid = $link2tag->getVar('tid');
				$criterias->add(new Criteria('id',$tid,'='),'OR');
			}
			$criterias->setLimit(count($link2tags));
			
			$tags =& $this->getObjects($criterias,$to_select);
		}
		
		return $tags;
	}
	
	/*
	*	retrieves links associated to the specified tag from database
	*	@param	int	tag id
	*	@param	array	columns to select
	*/
	function getAssociatedLinks($tid,$to_select=array())
	{
		$tid = intval($tid);
		$links = array();
		$lm =& get_manager('link');
		$l2tm =& get_manager('link2tag');
		
		$link2tags =& $l2tm->getObjects(new Criteria('tid',$tid,'='),array('lid'));
		
		if(count($link2tags) > 0)
		{
			$criterias = new CriteriaCompo(null,'OR');
			
			foreach($link2tags as $link2tag)
			{
				$lid = $link2tag->getVar('lid');
				$criterias->add(new Criteria('id',$lid,'='),'OR');
			}
			$criterias->setLimit(count($link2tags));
			$criterias->setSort('vote');
			$criterias->setOrder('DESC');
			
			$links =& $lm->getObjects($criterias,$to_select);
		}
		return $links;
	}
	
	/*
	*	Deletes link associated tags
	*	@param	int	link id
	*	@return	boolean
	*/
	function deleteLinkTags($lid)
	{
		$l2tm =& get_manager('link2tag');
		$tags = $this->getLinkTags($lid,array('id'));
		
		if(count($tags) > 0)
		{
			foreach($tags as $tag)
			{
				$deleteTag = false;
				$tid = $tag->getVar('id');
				
				// Deleting tag if the link is the last associated
				if($l2tm->getCount(new Criteria('tid',$tid,'=')) == 1)
				{
					$this->deleteAll(new Criteria('id',$tid,'='));
				}
				
				// Deleting all link2tag associations
				$l2tm->deleteAll(new Criteria('lid',$lid,'='));
			}
		}
		return true;
	}
}

?>