<?php

require_once SCRIPT_ROOT_PATH.'/class/object/class.object.php';

/**
 * User object class
 * 
 * @author Jerome Loisel
 * @copyright Jerome Loisel
 * @package kernel
 **/
class User extends MyObject
{
	/*
	 *	User constructor
	 *	@function	User
	 *	@param	array of vars to assign to Validation attributes
	 *	@return	void
	 */
	function User($vars = null)
	{
		$table = "user";
		$this->MyObject($table, $vars);
		
		$attributes = array(
		'id' => array('data_type' => XOBJ_DTYPE_INT, 'value' => null, 'maxlength' => '9'), 
		'login' => array('data_type' => XOBJ_DTYPE_TXTBOX, 'value' => '', 'maxlength' => '33'),  
		'pass' => array('data_type' => XOBJ_DTYPE_TXTBOX, 'value' => null, 'maxlength' => '33'), 
		'email' => array('data_type' => XOBJ_DTYPE_EMAIL, 'value' => null, 'maxlength' => '100'), 
		'active' => array('data_type' => XOBJ_DTYPE_INT, 'value' => 1, 'maxlength' => '1'), 
		'isadmin' => array('data_type' => XOBJ_DTYPE_INT, 'value' => 0, 'maxlength' => '1'), 
		'points' => array('data_type' => XOBJ_DTYPE_INT, 'value' => 0, 'maxlength' => '11') );
		
		$this->setAttributes($attributes);
	}
	
	function setPassword($password)
	{
		$this->setVar('pass',md5($password));
	}
	
	function updateCookie($key,$value)
	{
		$expire = 1800;
		setcookie($key,$value,time()+$expire,"/");
	}
}


/**
 * User Manager class
 * 
 * @author Jerome Loisel
 * @copyright Jerome Loisel
 * @package kernel
 **/
class UserManager extends MyObjectManager
{
	/**
	 * User Manager constructor
	 * 
	 * do not instanciate this object directly
	 * use : get_manager("User"); instead
	 * 
	 * @return void
	 */
	function UserManager()
	{
		$specs = array(
		'table' => "user", 
		'keyName' => 'id', 
		'className' => 'User' );
		
		$this->MyObjectManager($specs);
	}
	
	/*
	* Increments user points
	* @func	incrementPoints
	* @param	object criteria
	* @param	int points
	* @return	boolean
	*/
	function incrementPoints($criteria,$points = 0)
	{
		if (isset($criteria) && is_subclass_of($criteria, 'criteriaelement'))
		{
			$sql = "UPDATE `".$this->table."` SET `points`=points+".$points." ".$criteria->renderWhere();
			$limit = $criteria->getLimit() == 0 ? 1 : $criteria->getLimit();
			$sql .= " LIMIT ".$limit;
			return $this->con->execute($sql);
		}
		return false;
	}
	
	/*
	* User's ID
	* @return	int uid
	*
	*/
	function myUID()
	{
		$login = isset($_COOKIE['login']) ? $_COOKIE['login'] : '';
		$pass = isset($_COOKIE['pass']) ? $_COOKIE['pass'] : '';
		if(!empty($login) && !empty($pass) )
		{
			$criteria = new CriteriaCompo(new Criteria('login',$login,'='),'AND');
			$criteria->add(new Criteria('pass',$pass,'='),'AND');
			$criteria->setLimit(1);
			
			$user =& $this->getObjects($criteria,array('id'));
			
			if(count($user) == 1)
			{
				return $user[0]->getVar('id');
			}
			else
			{
				return 0;
			}
		}
		else
		{
			return 0;
		}
	}
}

?>