<?php

include_once "class.object.php";

/*
*	Validation object class
* 
*	@author	Jerome Loisel
*	@copyright	Jerome Loisel
*	@package	Kernel
*/
class Validation extends MyObject
{
	/**
	 * Validation constructor
	 * 
	 * @param array of vars to assign to Validation attributes
	 * 
	 * @return void
	 */
	function Validation($vars = null)
	{
		$table = "validation";
		$this->MyObject($table, $vars);
		
		$attributes = array(
		'id_site' => array('data_type' => XOBJ_DTYPE_INT, 'value' => null, 'maxlength' => '10'), 
		'secret' => array('data_type' => XOBJ_DTYPE_TXTBOX, 'value' => null, 'maxlength' => '32'),  
		'url' => array('data_type' => XOBJ_DTYPE_TXTBOX, 'value' => null, 'maxlength' => '70'), 
		'email' => array('data_type' => XOBJ_DTYPE_EMAIL, 'value' => null, 'maxlength' => '40') ); 
		
		$this->setAttributes($attributes);
	}
}


/*
*	Validation Manager class
* 
*	@author	Jerome Loisel
*	@copyright	Jerome Loisel
*	@package	Kernel
*/
class ValidationManager extends MyObjectManager
{
	/**
	 * Validation Manager constructor
	 * 
	 * do not instanciate this object directly
	 * use : get_manager("validation"); instead
	 * 
	 * @return void
	 */
	function ValidationManager()
	{
		$specs = array(
		'table' => "validation", 
		'keyName' => 'id_site', 
		'className' => 'Validation' );
		
		$this->MyObjectManager($specs);
	}
}

?>