<?php
include(dirname(__FILE__)."/init.php");

include(dirname(__FILE__)."/include/antispam.php");

/*
* this file Counts user clics on the links in the directory
*
* @param $_GET['id'] : id of the link to increment hits
*
* Clics are counted either by checking cookie OR by checking cookie AND ip
* In the case you use IP checking system, cookies are set to reduce SQL query count.
*
*/

if(isset($_GET['id']) && $_GET['id'] != '')
{
	$id = intval($_GET['id']);
	$lm = get_manager("link");
	
	if($CONFIG['use_iplogging'] && !isset($_COOKIE['clic'.$id]))
	{
		setcookie('clic'.$id,'1', time()+86400);

		$ipm =& get_manager("iplog");
		$ip = $_SERVER["REMOTE_ADDR"];
		$today = date('Y-m-d');

		$criteria_compo = new CriteriaCompo(new Criteria('ip',$ip,'='),'AND');
		$criteria_compo->add(new Criteria('linkid',$id,'='),'AND');
		$criteria_compo->setLimit(1);
		
		$iplogs =& $ipm->getObjects($criteria_compo, array('clic','date'));
		
		if(count($iplogs) > 0)
		{
			// Log found with this ip and link id
			foreach($iplogs as $iplog)
			{
				if($iplog->getVar('clic') == 0)
				{
					// Log found and no clic monitored
					// Updating link hits and IP log
					$ipm->update($criteria_compo,array('clic' => 1, 'date' => $today));
					
					$criteria = new Criteria('id',$id,'=');
					$criteria->setLimit(1);
					$lm->incrementHits($criteria);
					
					$link =& $lm->get($id,array('uid'));
					$um =& get_manager('user');
					$um->incrementPoints(new Criteria('id',$link->getVar('uid'),'='),$CONFIG['points_per_clic']);
				}
			}
		}
		else
		{
			// No log with this ip and link id
			// Insert new Log
			$iplog =& $ipm->create(true);
			$attributes = array('ip' => $ip, 
								'linkid' => $id, 
								'clic' => 1, 
								'vote' => 0, 
								'date' => date("Y-m-d"));
			$iplog->setVars($attributes);

			$ipm->insert($iplog);
			
			$criteria = new Criteria('id',$id,'=');
			$lm->incrementHits($criteria);
			
			$link =& $lm->get($id,array('uid'));
			$um =& get_manager('user');
			$um->incrementPoints(new Criteria('id',$link->getVar('uid'),'='),$CONFIG['points_per_clic']);
		}
		
		// Garbage collector executes itself 10% of time
		$rand = rand(0,10);
		if($rand == 0)
		{
			$criteria = new Criteria('date',$today,'<');
			$ipm->deleteAll($criteria);
		}
		
		
	}
	else if(!isset($_COOKIE['clic'.$id]))
	{
		setcookie('clic'.$id,'1', time()+86400);
		$criteria = new Criteria('id',$id,'=');
		$lm->incrementHits($criteria);
		
		$link =& $lm->get($id,array('uid'));
		$um =& get_manager('user');
		$um->incrementPoints(new Criteria('id',$link->getVar('uid'),'='),$CONFIG['points_per_clic']);
	}
	include(dirname(__FILE__).'/disconnect.php');
}
?>
<!-- You are a bad guy if you try to link this page directly from your website... -->
<script language="javascript" type="text/javascript">
if (top != self) {
top.location.href = <?php echo $CONFIG['site_url'] ?>;
}
</script>