<?php

/*
*	Displays a specific RSS feed of a link in your directory
*	Link feeds can be added through the admin panel, by editing the website you want to add a feed
*/

/***********************************/
/* Initialization */
require_once (dirname(__FILE__).'/init.php');
require_once (SCRIPT_ROOT_PATH.'/class/magpie/rss_fetch.php');
/***********************************/


$racine = isset($_GET['dir']) ? $_GET['dir'] : 0;
$start = isset($_GET['start']) ? $_GET['start'] : 1;

// Some information about the directory
displaySummary($racine);
// top keywords
//topKeywords();
// top visited websites
//topVisitedWebsites();
// Categories
displayCats($start, $racine);
// boost site
displayBoostSite();

$id = isset($_GET['feedid']) ? $_GET['feedid'] : 0;
$linkid = isset($_GET['linkid']) ? $_GET['linkid'] : 0;

$smarty->caching = 1;
$smarty->cache_lifetime = $CONFIG['feed_cache_lifetime'];
$template = 'feed.html';
$cache_id = 'feed'.$id;

if($id != 0 && $linkid != 0)
{
	if(!$smarty->is_cached($template,$cache_id))
	{
		$lm =& get_manager('link');
		$criteria = new Criteria('id',$linkid,'=');
		$criteria->setLimit(1);
		$links =& $lm->getObjects($criteria);
		affichage_liens($links, $CONFIG['url_rewriting'],1);

		$fm =& get_manager('feed');
		$myts =& MyTextSanitizer::getInstance();
		$feed =& $fm->get($id,array('name','feed'));

		$meta_title = $links[0]->getVar('name').' > '.$feed->getVar('name');
		$meta_desc = strip_tags($links[0]->getVar('description'));
		$meta_desc = str_replace(array('&#039;','"'),array("'",''),html_entity_decode($meta_desc));

		if(strlen($meta_desc) > 200)
		{
			$meta_desc = substr($meta_desc,0,200).'..';
		}

		$smarty->assign("meta_desc",$meta_desc);

		$meta_keyw = '';
		$keywords = explode(" ",$meta_desc);

		foreach($keywords as $key => $keyword)
		{
			$my_keyword = html_entity_decode($keyword);
			if(strlen($keyword) < 5)
			{
				unset($keywords[$key]);
			}
			else
			{
				$keywords[$key] = $my_keyword;
			}
		}
		$meta_keyw = implode(',',$keywords);
		if(strlen($meta_keyw) > 1000)
		{
			$meta_keyw = substr($meta_keyw,0,1000).'..';
		}

		$smarty->assign("meta_keyw",$meta_keyw);

		$smarty->assign(array("feed_name" => $feed->getVar('name'),
								"feed_url" => $feed->getVar('feed'),
								"meta_title" => $meta_title));

		$infos = fetch_rss($feed->getVar('feed'));
		foreach($infos->items as $val)
		{
			$title = isset($val['title']) ? $val['title'] : "";
			$desc = isset($val['description']) ? $val['description'] : "";
			$pubdate = isset($val['pubdate']) ? $val['pubdate'] : "";
			$link = isset($val['link']) ? $val['link'] : "";

			$smarty->append("items",array('title' => $title, 'pubdate' => $pubdate, 'description' => $desc, 'link' => $link));
		}

		if(is_array($infos)) {
			$url =  isset($infos['image']['url']) ? $infos['image']['url'] : "";
			$title =  isset($infos['image']['title']) ? $infos['image']['title'] : "";
			$link =  isset($infos['image']['link']) ? $infos['image']['link'] : "";
		} else if(is_object($infos)) {
			$url =  isset($infos->image->url) ? $infos->image->url : "";
			$title =  isset($infos->image->title) ? $infos->image->title : "";
			$link =  isset($infos->image->link) ? $infos->image->link : "";
		}

		if(!empty($url) && !empty($title) && !empty($link))
		{
			$smarty->append("images",array('url' => $infos['image']['url']));
		}
	}
}

include(dirname(__FILE__).'/disconnect.php');

$smarty->display($template,$cache_id);
?>