<?php

include(dirname(__FILE__)."/init.php");

$ip = $_SERVER["REMOTE_ADDR"];
$uid = isset($_GET['id']) ? intval($_GET['id']) : 0;

$im =& get_manager('inlog');
$inm =& get_manager('in');
$um =& get_manager('user');

if($uid != 0)
{
	if(!isset($_COOKIE['in'.$uid]))
	{
		$today = date('Y-m-d');
		
		// Setting cookie to reduce cheating and server cpu usage
		setcookie('in'.$uid,'1', time()+86400);
		
		$criteria = new CriteriaCompo(new Criteria('ip',$ip,'='),'AND');
		$criteria->add(new Criteria('uid',$uid,'='),'AND');
		$criteria->add(new Criteria('date',$today,'='),'AND');
		$criteria->setLimit(1);
		
		if($im->getCount($criteria) == 0)
		{
			$criteria = new Criteria('id',$uid,'=');
			$criteria->setLimit(1);
			$user_existing = $um->getCount($criteria);
			
			if($user_existing == 1)
			{
				// Incoming visitor not counted and uid existing
				$inlog = $im->create(true);
				$attributes = array(
								'ip' => $ip, 
								'uid' => $uid, 
								'date' => $today );
				$inlog->setVars($attributes);
				$inlog->setNew();
				
				$im->insert($inlog);
				
				$criteria = new CriteriaCompo(new Criteria('uid',$uid,'='),'AND');
				$criteria->add(new Criteria('date',$today,'='),'AND');
				
				if($inm->getCount($criteria) == 0)
				{
					$in = $inm->create(true);
					$attributes = array(
										'uid' => $uid, 
										'date' => $today, 
										'ins' => 1);
					$in->setVars($attributes);
					$in->setNew();
					
					$inm->insert($in);
				}
				else
				{
					$inm->incrementIns($criteria);
				}
				
				// Updating user's points
				$um->incrementPoints(new Criteria('id',$uid,'='),$CONFIG['points_per_in']);
			}
		}
	}
	
	// Garbage collector executes itself 10% of time
	$rand = rand(0,10);
	if($rand == 0)
	{
		$criteria = new Criteria('date',$today,'<');
		$im->deleteAll($criteria);
	}
}

header('Location: '.$CONFIG['site_url']);
?>