<?php

require_once SCRIPT_ROOT_PATH.'/plugins/allopass/functions.php';

function diff($date1,$date2)
{
	$time1 = strtotime($date1);
	$time2 = strtotime($date2);
	$diff = $time2 - $time1;
	
	return $diff;
}

function calculateTime($time, $separator=':')
{
	$hours = 0;
	$minutes = 0;
	$secondes = 0;
	while($time - 3600 >= 0)
	{
		$hours++;
		$time = $time - 3600;
	}
	while($time - 60 >= 0)
	{
		$minutes++;
		$time = $time - 60;
	}
	$secondes = $time;
	
	$time_array = array('hours' => $hours, 'minutes' => $minutes, 'secondes' => $secondes);
	
	$time_array['hours'] = $time_array['hours'] == 0 ? '00' : $time_array['hours'];
	$time_array['minutes'] = $time_array['minutes'] == 0 ? '00' : $time_array['minutes'];
	$time_array['secondes'] = $time_array['secondes'] == 0 ? '00' : $time_array['secondes'];
	
	$time_array['hours'] = strlen($time_array['hours']) == 1 ? '0'.$time_array['hours'] : $time_array['hours'];
	$time_array['minutes'] = strlen($time_array['minutes']) == 1 ? '0'.$time_array['minutes'] : $time_array['minutes'];
	$time_array['secondes'] = strlen($time_array['secondes']) == 1 ? '0'.$time_array['secondes'] : $time_array['secondes'];
	
	return ($time_array['hours'].$separator.$time_array['minutes'].$separator.$time_array['secondes']);
}

function defaut()
{
	global $CONFIG, $lang;
	$smarty =& TemplateEngine::getInstance();
	$bm =& get_manager('boost');
	$lm =& get_manager('link');
	
	$criteria = new Criteria('id',0,'!=');
	$criteria->setLimit(1);
	
	// Display Boosted website	
	$boosts =& $bm->getObjects($criteria);
	
	if(count($boosts) == 1)
	{
		foreach($boosts as $boost)
		{
			$link_id = $boost->getVar('id');
			$date_submitted = $boost->getVar('date');
			$is_allopass = $boost->getVar('is_allopass');
			// Difference between last boost and now
			$diff = abs(diff($date_submitted,date('Y-m-d H:i:s')));
			
			if($is_allopass == 0) {
				$can_boost_another_site = $diff >= $CONFIG['boost_time'] ? true : false;
				$smarty->assign('can_boost',$can_boost_another_site);
			} else if($is_allopass == 1) {
				$can_boost_another_site = $diff >= $CONFIG['boost_time_allopass'] ? true : false;
				$smarty->assign('can_boost',$can_boost_another_site);
			}
			
			if(!$can_boost_another_site)
			{
				// display message that explains time to wait
				if($is_allopass == 0) {
					$time_to_wait = calculateTime($CONFIG['boost_time']-$diff);
				} else if($is_allopass == 1) {
					$time_to_wait = calculateTime($CONFIG['boost_time_allopass']-$diff);
				}
				
				$message = sprintf($lang['have_to_wait'],$time_to_wait);
				$smarty->assign('have_to_wait',$message);
			}
			
			$time_elapsed = calculateTime($diff);
			$smarty->assign('time_elapsed',$time_elapsed);
			
			unset($append);
		}
	}
	else
	{
		$smarty->assign('can_boost',true);
	}
	
	$smarty->assign('allopass_flags',displayForm(array('index.php?do=boost&allopasserror=1'),true));
}

function updateBoost($isAllopass)
{
	global $CONFIG, $lang;
	$smarty =& TemplateEngine::getInstance();
	$bm =& get_manager('boost');
	$lm =& get_manager('link');
	$link_id = isset($_POST['id']) ? $_POST['id'] : 0;
	
	if($link_id != 0)
	{
		$criteria = new Criteria('id',0,'!=');
		$criteria->setLimit(1);
		
		$boosts =& $bm->getObjects($criteria);
		
		if(count($boosts) == 1)
		{
			foreach($boosts as $boost)
			{
				$date_submitted = $boost->getVar('date');
				// Difference between last boost and now
				$diff = diff($date_submitted,date('Y-m-d H:i:s'));
				
				if($diff >= $CONFIG['boost_time'])
				{
					$criteria = new CriteriaCompo(new Criteria('id',$link_id,'='),'AND');
					$criteria->add(new Criteria('state',4,'='),'AND');
					$criteria->setLimit(1);
					
					if($lm->getCount($criteria) == 1)
					{
						if($isAllopass) {
							$allopassCode =  (string) isset($_POST['CODE']) ? $_POST['CODE'] : '';
							if(empty($allopassCode)) {
								$smarty->assign('warning',$lang['boost_allopass_empty']);
							} else {
								if(checkCode(array($CONFIG['site_url'].'/index.php?do=boost'),false)) {
									$am =& get_manager('allopass');
									
									if($am->hasPremiumAccess('boost')) {
										$am->deletePremiumAccess('boost');
										
										$attributes = array('id' => $link_id, 'date' => date('Y-m-d H:i:s'),'is_allopass' => 1);
										$bm->update(new Criteria('id',0,'!='),$attributes);
							
										$smarty->assign('warning',$lang['boost_accepted']);
									} else {
										$smarty->assign('warning',$lang['wrong_allopass_code']);
									}
								} else {
									$smarty->assign('warning',$lang['wrong_allopass_code']);
								}
							}
						} else {
							$attributes = array('id' => $link_id, 'date' => date('Y-m-d H:i:s'),'is_allopass' => 0);
							$bm->update(new Criteria('id',0,'!='),$attributes);
							
							$smarty->assign('warning',$lang['boost_accepted']);
						}
					}
					else
					{
						$smarty->assign('warning',$lang['site_not_exists']);
					}
				}
				else
				{
					$smarty->assign('warning',$lang['boost_too_early']);
				}
			}
		}
		else
		{
			if($isAllopass) {
				$allopassCode =  (string) isset($_POST['CODE']) ? $_POST['CODE'] : '';
				if(empty($allopassCode)) {
					$smarty->assign('warning',$lang['boost_allopass_empty']);
				} else {
					if(checkCode(null,false)) {
						$am =& get_manager('allopass');
						
						if($am->hasPremiumAccess('boost')) {
							
							$am->deletePremiumAccess('boost');
							
							$criteria = new CriteriaCompo(new Criteria('id',$link_id,'='),'AND');
							$criteria->add(new Criteria('state',4,'='),'AND');
							$criteria->setLimit(1);
							
							if($lm->getCount($criteria) == 1)
							{
								$boost = $bm->create(true);
								$attributes = array('id' => $link_id, 'date' => date('Y-m-d H:i:s',time()),'is_allopass' => 1);
								$boost->setVars($attributes);
								$boost->setNew();
								$bm->insert($boost);
								
								$smarty->assign('warning',$lang['boost_accepted']);
							}
							else
							{
								$smarty->assign('warning',$lang['site_not_exists']);
							}
						} else {
							$smarty->assign('warning',$lang['wrong_allopass_code']);
						}
					} else {
						$smarty->assign('warning',$lang['wrong_allopass_code']);
					}
				}
			} else {
				$criteria = new CriteriaCompo(new Criteria('id',$link_id,'='),'AND');
				$criteria->add(new Criteria('state',4,'='),'AND');
				$criteria->setLimit(1);
				
				if($lm->getCount($criteria) == 1)
				{
					$boost = $bm->create(true);
					$attributes = array('id' => $link_id, 'date' => date('Y-m-d H:i:s'),'is_allopass' => 0);
					$boost->setVars($attributes);
					$boost->setNew();
					$bm->insert($boost);
					
					$smarty->assign('warning',$lang['boost_accepted']);
				}
				else
				{
					$smarty->assign('warning',$lang['site_not_exists']);
				}
			}
		}
	}
}

$action = isset($_POST['action']) ? $_POST['action'] : '';



switch($action)
{
	case 'updateFree':
		include SCRIPT_ROOT_PATH.'/include/antispam.php';
		updateBoost(false);
		break;
		
	case 'updateAllopass':
		include SCRIPT_ROOT_PATH.'/include/antispam.php';
		updateBoost(true);
		break;
		
	default:
		break;
}

defaut();

?>