<?php

function displayTagCloud()
{
	$stm =& get_manager('scoredtag');
	
	$tags =& $stm->getMostPopularTags();
	
	if(count($tags) > 0)
	{
		$tagcloud = new TagCloud();
		foreach($tags as $tag)
		{
			$tagcloud->addElement($tag->getVar('id'), $tag->getVar('tag'),$tag->getVar('score'));
		}
		$tagcloud->generateCloud();
	}
	return array();
}

function displayBoostSite()
{
	$bm =& get_manager('boost');
	$lm =& get_manager('link');
	$smarty =& TemplateEngine::getInstance();
	
	$boosts =& $bm->getBoostedWebsites(array('id','url','name','image'));
	
	if(count($boosts) > 0)
	{
		foreach($boosts as $boost)
		{
			$attributes = $boost->getVars();
			
			$append = array();
			foreach($attributes as $key => $value)
			{
				$append[$key] = $attributes[$key]['value'];
			}
			$smarty->append('boost_sites',$append);
		}
	}
}

/*
*	Displays a summary of the content indexed on the website in a specific category
*	@param int racine : id of the current root category
*	@return void
*/
function displaySummary($racine)
{
	$smarty =& TemplateEngine::getInstance();
	$lm =& get_manager("link");
	$cm =& get_manager("category");

	$smarty->assign("current_cat",$racine);
	$smarty->assign("nb_sites",$lm->getCount(new Criteria('state',4,'='),array('id')));
	$smarty->assign("nb_categories",$cm->getCount(null,array('id')));
}

/*
*	SideBar Top visited websites
*	@function	topVisitedWebsites
*	@return	void
*/
function topVisitedWebsites()
{
	global $CONFIG;
	$smarty =& TemplateEngine::getInstance();
	$lm =& get_manager("link");
	
	$criteria = new Criteria('state',4,'=');
	$criteria->setSort('hits');
	$criteria->setOrder('DESC');
	$criteria->setLimit($CONFIG['links']);

	$sites =& $lm->getObjects($criteria,array('name','url'));

	if(count($sites) > 0)
	{
		foreach($sites as $site)
		{
			$url = $site->getVar('url');
			$name = strlen($site->getVar('name')) > 20 ? substr($site->getVar('name'),0,20).'...' : $site->getVar('name');
			$smarty->append('topsites',array('url' => $url, 'name' => $name));
		}
	}
}

/*
*	Top Tags
*	@function	topKeywords
*	@return	void
*/
function topKeywords()
{
	global $CONFIG;
	$smarty =& TemplateEngine::getInstance();
	$re =& MyRewriteEngine::getInstance();
	$myts =& MyTextSanitizer::getInstance();
	$km =& get_manager("keyword");
	
	$criteria = new Criteria('hasresults',1,'=');
	$criteria->setSort('occurence');
	$criteria->setOrder('DESC');
	$criteria->setLimit($CONFIG['links']);
	
	$keywords =& $km->getObjects($criteria,array('id','word'));
	
	if(count($keywords) > 0)
	{
		foreach($keywords as $keyword)
		{
			$id = $keyword->getVar('id');
			$word = strtolower($CONFIG['encoding']) == 'utf-8' ? $keyword->getVar('word') : $keyword->getVar('word');
			$smarty->append("topkeywords",array('id' => $id, 
												'word' => $word, 
												'url' => $re->buildUrl('keyword',array('id' => $id, 'word' => $word))));
		}
	}
}


/*
*	Last websites added on homepage
*	@function	topVisitedWebsites
*	@return	void
*/
function lastWebsites($root)
{
	global $CONFIG;
	if($root == 0)
	{
		$lm = get_manager("link");

		$criteria = new Criteria('state',4,'=');
		$criteria->setLimit($CONFIG['links']);
		$criteria->setOrder('DESC');
		$criteria->setSort('id');

		$links =& $lm->getObjects($criteria);

		affichage_liens($links);
	}
}


/*
*	Checks the syntax of an email
*	@param string email
*	@return bool : TRUE if success, else FALSE
*/
function test_mail($email)
{
	$pattern = "^([a-z0-9_]|\\-|\\.)+@(([a-z0-9_]|\\-)+\\.)+[a-z]{2,4}$";
	if (eregi ($pattern, $email))
	{
		return true;
	}
	else
	{
		return false;
	}
}


function getSiteFeeds($id)
{
	$fm =& get_manager('feed');
	$re =& MyRewriteEngine::getInstance();
	
	$feeds2 = array();

	$criteria = new CriteriaCompo(new Criteria('linkid',$id,'='),'AND');
	if(isset($_GET['feedid']))
	{
		$criteria->add(New Criteria('id',$_GET['feedid'],'!='),'AND');
	}
	$feeds =& $fm->getObjects($criteria,array('id','name','feed'));
	
	if(count($feeds) > 0)
	{
		foreach($feeds as $feed)
		{
			$feedid = $feed->getVar('id');
			$name = $feed->getVar('name');
			$feeds2[] = array('id' => $feedid, 
							  'name' => $name, 
							  'url' => $re->buildUrl('feed',array('feedid' => $feedid, 'linkid' => $id, 'name' => $name)));
		}
	}
	
	return $feeds2;
}

function getSiteVotes($id)
{
	global $lang, $CONFIG;
	$voted = false;
	
	$ipm =& get_manager('iplog');
	
	if(isset($_COOKIE['vote'.$id]))
	{
		$voted = true;
	}
	else if($CONFIG['use_iplogging'] && !isset($_COOKIE['vote'.$id]))
	{
		$ip = $_SERVER['REMOTE_ADDR'];
		
		$criteria_compo = new CriteriaCompo(new Criteria('ip',$ip,'='),'AND');
		$criteria_compo->add(new Criteria('linkid',$id,'='),'AND');
		$criteria_compo->add(new Criteria('vote',1,'='),'AND');
		$criteria_compo->add(new Criteria('date',date("Y-m-d"),'='),'AND');
		$criteria_compo->setLimit(1);
		
		$iplog_count = $ipm->getCount($criteria_compo);
		if($iplog_count > 0)
		{
			setcookie('vote'.$id,'1', time()+86400);
			$voted = true;
		}
	}
	
	if($voted)
	{
		$vote_link = $lang['voted'];
	}
	else
	{
		$vote_link = '<a href="javascript:vote('.$id.',\''.$CONFIG['site_url'].'\')" id="vote-'.$id.'" style="color: #F7560F;">';
		$vote_link .= $lang['vote']."</a>";
	}
	
	return $vote_link;
}

function getSiteTags($id)
{
	$append = array();
	$re =& MyRewriteEngine::getInstance();
	
	$tm =& get_manager('tag');
		
	$to_select = array('id','tag');

	$tags =& $tm->getLinkTags($id,$to_select);
	
	if(count($tags) > 0)
	{
		$i = 0;
		foreach($tags as $linktag)
		{
			$attributes = $linktag->getVars();

			foreach($attributes as $key => $value)
			{
				$append[$i][$key] = $attributes[$key]['value'];
			}
			$append[$i]['url'] = $re->buildUrl('tag',array('id' => $linktag->getVar('id'), 
														   'tag' => $linktag->getVar('tag')));
			
			$i++;
		}
		return $append;
	}
}

/*
*	Displays links by assigning them to template Engine
*	@param Objects {@object Link}
*	@param Bool url_r : TRUE if url rewrite enabled
*	@param bool fil : TRUE if you want to display link category foreach link
*	@param bool display_feeds : TRUE if you want to display link associated feeds
*/
function affichage_liens($links, $url_r=true, $fil=false, $display_feeds=false, $display_tags=false)
{
	global $tab_pr, $CONFIG, $lang;
	
	$url_r = $CONFIG['url_rewriting'];
	
	$smarty =& TemplateEngine::getInstance();
	$re =& MyRewriteEngine::getInstance();
	
	if(count($links) > 0)
	{
		$feeds = array();
		
		$meta_desc = '';
		$meta_keyw = '';

		foreach($links as $link)
		{
			$meta_desc_temp = '';
			$id = $link->getVar('id');
			$url = $link->getVar('url');
			$name = $link->getVar('name');
			$category = $link->getVar('category');
			$tab_pr[$url] = $link->getVar('pr');
			$title_chemin = isset($category) && $fil ? show_me_the_way_clic($category, $url_r) : "";

			$smarty->assign('display_link_cat',$fil);
			$smarty->append("sites", array(
									'id' => $id, 
									'name' => $name, 
									'description' => $link->getVar('description'), 
									'url' => $link->getVar('url'), 
									'pagerank' => $link->getVar('pr'), 
									'hits' => $link->getVar('hits'), 
									'image' => $link->getVar('image'), 
									'vote' => $link->getVar('vote'), 
									'vote_link' => ($CONFIG['link_votes'] ? getSiteVotes($id) : ''), 
									'way_to_mycat' => $title_chemin, 
									'feeds' => ($display_feeds ? getSiteFeeds($id) : array()), 
									'date' => $link->getVar('date'), 
									'prio' => $link->getVar('prio'), 
									'tags' => ($display_tags ? getSiteTags($id) : array()), 
									'single' => $re->buildUrl('single',array('id' => $id, 'name' => $name))));
			
			$meta_desc_temp = strip_tags($name);
			$meta_desc_temp = str_replace(array('&#039;','"'),array("'",''),$meta_desc_temp);
			$meta_desc .= $meta_desc_temp.' ';
			
			$keywords = explode(" ",$meta_desc_temp);
			if(count($keywords) > 0)
			{
				foreach($keywords as $key => $keyword)
				{
					$my_keyword = '';
					$my_keyword = html_entity_decode($keyword);
					$my_keyword = str_replace(',','',$my_keyword);
					if(strlen($my_keyword) < 5)
					{
						unset($keywords[$key]);
					}
					else
					{
						$keywords[$key] = $my_keyword;
					}
				}
				$meta_keyw[] = implode(',',$keywords);
				unset($keywords);
			}
		}
		
		if(strlen($meta_desc) > 200)
		{
			$meta_desc = substr($meta_desc,0,200);
		}
		$meta_keyw = implode(',',$meta_keyw);
		if(strlen($meta_keyw) > 1000)
		{
			$meta_keyw = substr($meta_keyw,0,1000);
		}
		
		$smarty->assign("meta_keyw",$meta_keyw);
		$smarty->assign("meta_desc",$meta_desc);
	}
}


/*
*	displays full way to the cat with id $id
*	@param int id : id of the category to show full way to
*	@return string : Way to the category
*/
function show_me_the_way($id)
{
	global $lang;
	$cm =& get_manager("category");
	$title_chemin = '';

	while ($id != 0)
	{
		$criteria = new Criteria("id",$id,'=');
		$criteria->setLimit(1);
		$cols = array('name','root');
		$category =& $cm->get($id,$cols);
		$id = $category->getVar('root');
		$title_chemin = ' > '.$category->getVar('name').$title_chemin;
	}
	$title_chemin = $lang['home'].$title_chemin;
	
	return $title_chemin;
}


/*
*	displays full way to the cat with id $id, with url rewrite if enabled
*	@param int root : id of the category to show full way to
*	@param bool url_r : TRUE if url rewrite enabled // deprecated
*	@return string : Way to the category with link to each category in the way 
*/
function show_me_the_way_clic($root, $url_r = true)
{
	global $lang;
	$title_chemin = '';
	$cm =& get_manager("category");
	$re =& MyRewriteEngine::getInstance();

	while ($root!= 0)
	{
		$criteria = new Criteria("id",$root);
		$criteria->setLimit(1);
		$cols = array('id','name','root');
		$category =& $cm->get($root,$cols);
		$root = $category->getVar('root');

		$title_chemin = ' > <a href="'.$re->buildUrl('category',array('name' => $category->getVar('name'), 'id' => $category->getVar('id'))).'">'.$category->getVar('name').'</a>'.$title_chemin;
	}
	
	$title_chemin = "<a href='./' title='".$lang['home']."'>".$lang['home'].'</a>'.$title_chemin;
	
	return $title_chemin;
}


/*
*	Checks if the corresponding URL is responding
*	@param string URL of the site to check
*	@return bool : TRUE if success, else false
*/
function checkurl($url){
	// vrification du protocole HTTP
	if (!eregi("^http://", $url)) {
		return FALSE;
	}
	$details = parse_url($url);
	// vrification du port 80 li au protocole HTTP
	if (!isset($details['port'])) {
		$details['port'] = "80";
	}
	// vrification du chemin
	if (!isset($details['path'])) {
		$details['path'] = "/";
	}
	// vrification de l'adresse du serveur
	if (!ereg("[0-9]+\.[0-9]+\.[0-9]+\.[0-9]+", $details['host'])){
		$details['host'] = gethostbyname($details['host']);
	}
	// ouverture d'une connexion vers le serveur
	if ($sock = @fsockopen( $details['host'], $details['port'], $numero_erreur, $texte_erreur)){
		$requete = "GET ".$details['path']." HTTP/1.1\r\n";
		$requete .= "Host: ".$details['host']."\r\n\r\n";
		// envoie d'une requte HTTP GET
		fputs($sock, $requete);
		// rception de la rponse du serveur
		$str = fgets($sock, 1024);
		
		$i = 0;
		while(!ereg('^HTTP/1.1 ', $str) && $i < 100)
		{
			$str = fgets($sock, 1024);
			$i++;
		}
		// fermeture de la connexion
		fclose($sock);
		list($http, $str, $texte) = explode(" ", $str, 3);
		
		if($i == 100)
		{
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	return FALSE;
}


/*
*	Generates a random password
*	@param void
*	@return string : password generated
*/
function random_pass($length=32)
{
	$chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
	$password = '';
	for ($i = 0; $i < $length; ++$i)
		$password .= substr($chars, (mt_rand() % strlen($chars)), 1);
	return $password;
}

/*
*	Pre-fills the link submission form by retrieving site metatags and checking if
*	a thumbnail for this website exists
*	@param string url : website url to retrieve information
*	@param bool fill : TRUE if you want to detect site thumbnails
*/
function preremplir_formulaire($url,$fill)
{
	if ( $fill )
	{
		global $CONFIG;
		
		$detect_images = array (
			'ascreen'	=> '1', 
			'thumbshots'	=> '2',
			'thumbzor'		=> '3', 
			'websnapr' => '4', 
			'alexa' => '5');
		
		asort($detect_images);
		
		$detected = false;
		foreach ( $detect_images as $methode => $ordre )
		{
			if ( $ordre )
			{
				$url_image = detect_images($methode,$url);
				
				if ( $url_image )
				{
					$detected = true;
					break;
				};
			};
		};
		
		$url_image = $detected ? $url_image : 'http://';
		
		if ( $CONFIG['get_meta_tags'] )
		{
			$fp = @fopen($url, 'r');
			$head = @fread($fp, 1024);
			@fclose($fp);
		}
		else
		{
			$head = null;
		};
		
		if ( $head )
		{
			$tags = @get_meta_tags($url);
			
			$nom_proprio = isset($tags['author']) ? $tags['author'] : '';
			$email_proprio = isset($tags['reply-to']) ? $tags['reply-to'] : ( isset($tags['email']) ? $tags['email'] : '' );
			$titre = preg_match( "/<title>([^<]*)<\/title>/si", $head, $match ) ? $match[1] : '';
			$description = isset($tags['description']) ? $tags['description'] : '';
		}
		else
		{
			$nom_proprio = "";
			$email_proprio = "";
			$titre = "";
			$description = "";
		}
		$return = array( $url, $url_image, $nom_proprio, $email_proprio, $titre, $description );
	}
	else
	{
		$url = 'http://';
		$url_image = 'http://';
		$nom_proprio = null;
		$email_proprio = null;
		$titre = null;
		$description = null;
		
		$return = array( $url, $url_image, $nom_proprio, $email_proprio, $titre, $description );
	}
	
	return $return;
}

/*
*	Private function called by @func preremplir_Formulaire() to detect site thumbnails
*	@param string methode : which method should the function use to find the thumbnail ? (ascreen, thumshots...)
*	@param string url : URL of the website concerned by the detection
*	@return string : URL of the thumbnail found if success, else null
*/
function detect_images($methode,$url)
// Dtecter une image via AscreeN, Thumbshots ou Alexa
{
	$url_image = null;
	
	if ( $methode=='ascreen' )
	{
		$urlt = rtrim($url,"/");
		
		if ( @getimagesize("$urlt/ascreen.jpg") ) {
			$url_image = "$urlt/ascreen.jpg";
		};
	}
	elseif ( $methode=='thumbshots' )
	{
		if ( ($a=@getimagesize("http://open.thumbshots.org/image.pxf?url=$url")) && $a[0]>50 ) {
			$url_image = "http://open.thumbshots.org/image.pxf?url=$url";
		};
	}
	elseif( $methode=='thumbzor' )
	{
		if ( ($a=@getimagesize("http://www.thumbzor.com/tel.php?url=$url")) && $a[0]>50 ) {
			$url_image = "http://www.thumbzor.com/tel.php?url=$url";
		};
	}
	elseif( $methode=='websnapr' )
	{
		if ( ($a=@getimagesize("http://images.websnapr.com/?url=$url&size=S")) && $a[0]>50 ) {
			$url_image = "http://images.websnapr.com/?url=$url&size=S";
		};
	}
	elseif ( $methode=='alexa' )
	{
		$purl = parse_url("http://thumbnails.alexa.com/image_server.cgi?size=small&url=$url");
		
		$fp = @fsockopen($purl['host'], 80, $errno, $errstr, 5);
		@fputs($fp, "GET $purl[path]?$purl[query] HTTP/1.1\r\nHost: $purl[host]\r\n\r\nConnection: Close\r\n\r\n");
		$ok = preg_match("!Location: /images/smalljpeg/!",@fread($fp,210));
		@fclose($fp);
		
		if ( $ok ) {
			$url_image = "http://thumbnails.alexa.com/image_server.cgi?size=small&url=$url";
		};
	};
	
	return $url_image;
}


/*
* 	This function is used to return an Object  Manager
* 	@param string name of the object manager to instanciate
*	@param bool optional : if TRUE, if handler does not exists, no trigger error is raised
*	@return &Object {@link ObjectManager} ; FALSE if failure
*/
function &get_manager($name, $optional = false)
{
	static $handlers;
	$name = strtolower(trim($name));
	
	if (!isset($handlers[$name]))
	{
		
        if ( file_exists( $hnd_file = SCRIPT_ROOT_PATH.'/class/object/class.'.$name.'.php' ) ) 
		{
            require_once $hnd_file;
        }
        $class = ucfirst($name).'Manager';
        if (class_exists($class))
		{
            $handlers[$name] =& new $class();
        }
    }
    if (!isset($handlers[$name]) && !$optional )
	{
        trigger_error('Class <b>'.$class.'</b> does not exist<br />Manager Name: '.$name, E_USER_ERROR);
    }
	
    if ( isset( $handlers[$name] ) )
	{
    	return $handlers[$name];
    }
	else
	{
		return false;
	}
}

/*
*	displays all the categories contained in the root category
*	@param int start : useful for creating pages (SQL query optional value)
*	@param int racine : id of the root category
*	@return void
*/
function displayCats($start, $racine)
{
	global $CONFIG;
	
	$smarty =& TemplateEngine::getInstance();
	$rewrite_engine =& MyRewriteEngine::getInstance();
	
	$cm =& get_manager("category");
	
	$criteria = new Criteria('root',$racine,'=');
	$criteria->setOrder('ASC');
	$criteria->setSort('name');
	$cols = array('id','name');
	$categories =& $cm->getObjects($criteria,$cols);
	
	if (count($categories) > 0)
	{
		// Recuperation des sous-categories
		$criterias = new CriteriaCompo(null,'OR');
		foreach($categories as $category)
		{
			$criterias->add(new Criteria('root',$category->getVar('id'),'='),'OR');
		}
		$subcategories =& $cm->getObjects($criterias,array('id','name','root'));
		
		// Tri des sous-categories
		$subcats = array();
		$subcats_count = array();
		foreach($subcategories as $subcategory)
		{
			$catid = $subcategory->getVar('root');
			if(!isset($subcats_count[$catid]))
			{
				$subcats_count[$catid] = 0;
			}
			
			if($subcats_count[$catid] <= $CONFIG['subdirs'])
			{
				$subcats_count[$catid]++;
				$subcats[$catid][] = array('url' => $rewrite_engine->buildUrl('category', 
																			  array('name' => $subcategory->getVar('name'), 
																					'id' => $subcategory->getVar('id')) ), 
										   'name' => $subcategory->getVar('name') );	
			}
		}
		unset($subcats_count);
		
		foreach($categories as $category)
		{
			// Affichage des sous-catgories	
			$compteur = 0;
			$catid = $category->getVar("id");
			$catname = $category->getVar('name');
			
			$myCategory = array('url' => $rewrite_engine->buildUrl('category', array('name' => $catname, 'id' => $catid)), 
										 'name' => $catname, 
										 'id' => 'c'.$catid, 
										 'subcategories' => (isset($subcats[$catid]) ? $subcats[$catid] : array()));
			$smarty->append("categories", $myCategory);
		}
	}
}

/**
 * Detect UTF-8 characters in strings
 * @param	String to verify
 * @return	Boolean	TRUE if UTF-8 encoded, else FALSE
 */
function isUTF8($string) {
		return preg_match('%(?:
		[\xC2-\xDF][\x80-\xBF]				# non-overlong 2-byte
		|\xE0[\xA0-\xBF][\x80-\xBF]			# excluding overlongs
		|[\xE1-\xEC\xEE\xEF][\x80-\xBF]{2}	# straight 3-byte
		|\xED[\x80-\x9F][\x80-\xBF]			# excluding surrogates
		|\xF0[\x90-\xBF][\x80-\xBF]{2}		# planes 1-3
		|[\xF1-\xF3][\x80-\xBF]{3}			# planes 4-15
		|\xF4[\x80-\x8F][\x80-\xBF]{2}		# plane 16
		)+%xs', $string);
	}

function updatePagerank($link = array())
{
	global $CONFIG;
	/**
	* While caching, Pagerank will only be calculate at page cache refresh
	**/
	if($CONFIG['use_pagerank'] == 1)
	{
        include SCRIPT_ROOT_PATH."/class/class.googlepr.php";
        
        $class = 'GooglePR';
        // alternate pagerank calculation algorithm for those who have issues with original algorithm
        if($CONFIG['alternate_pr_calculation'] == 1)
        {
            $class = 'Alternate'.$class;
        }
        
        $gpr = new $class();
        $gpr->userAgent = $_SERVER["HTTP_USER_AGENT"];
        $gpr->cacheDir = SCRIPT_ROOT_PATH."/public/prcache";
        $gpr->useCache = $CONFIG['use_prcache'];

        $lm =& get_manager("link");
        
        $true_pr = intval($gpr->GetPR($link['url']));
        
        if ($link['pr'] != $true_pr)
        {
            $criteria = new Criteria('id',$link['id'],'=');
            $criteria->setLimit(1);
            $attributes = array('pr' => $true_pr);
            $lm->update($criteria, $attributes);
        }
	}
}
?>