<?php


/*
*	adds a website to database
*	@param string name, url, description, email, url_image
*	@param int category : id of the category where to insert the website
*	@param string path : way to the cat which will contain the website
*/
function AddSite($name, $url, $description, $category, $email, $url_image, $path)
{
	global $CONFIG, $lang;
	
	if(@ini_get('allow_url_fopen') == 1) {
		$isSpam = file_get_contents('http://www.freeglobes.net/antispam/isspam.php?ip='.$_SERVER['REMOTE_ADDR'].'&email='.$email.'&url='.$url);
		if($isSpam == 'yes') {
			exit();
		}
	}
	
	$smarty =& TemplateEngine::getInstance();
	$myts =& MyTextSanitizer::getInstance();
	$lm =& get_manager('link');
	$vm =& get_manager('validation');
	
	if( ($CONFIG['use_antibot'] == 0) || (isset($_SESSION['antibotcode']) && $_SESSION['antibotcode'] == $_POST['antibotcode']))
	{
		// Test des champs
		if ((!empty($name)) and (!empty($description)) and (!empty($email)))
		{
			$name_maxlength = 100;
			if (strlen($name) > $name_maxlength)
			{
				$message = sprintf($lang['warn_sitelength'],$name_maxlength);
				$link_url =  'javascript:history.go(-1)';
				$link_name = $lang['return'];
			}
			else if (strlen($description) > 255)
			{
				$message = $lang['warn_desc'];
				$link_url =  'javascript:history.go(-1)';
				$link_name = $lang['return'];
			}
			else if (!test_mail($email))
			{
				$message = $lang['warn_email'];
				$link_url =  'javascript:history.go(-1)';
				$link_name = $lang['return'];
			}
			else
			{
				if($CONFIG['check_url'])
				{
					$test_url = checkurl($url_posted);
				}
				else
				{
					$test_url = true;
				}
				
				if ($test_url)
				{   
					$true_pr = 0;
					
					// Enlve le dernier slash
					$ext = pathinfo($url);
					if (!isset($ext['extension']))
					{
						$url = substr($url, 0, strlen($url)-1);
					}
							
					$count = $lm->getcount(new Criteria('url',$url."%",'LIKE'));
					
					if ($count > 0)
					{
						$message = $lang['warn_already'];
						$link_url =  'javascript:history.go(-1)';
						$link_name = $lang['return'];
					}
					else
					{
						$description = str_replace('"','',$description);
						$state = 0;
						$secret = random_pass();
						$chemin = show_me_the_way($category);
						$name = stripslashes($name);
						$description = stripslashes($description);
					
						if($CONFIG['mail_confirm'] == 1)
						{
							$state = 0;
							
							$description = str_replace("\'","'",$description);
							
							$mailm = new MailManager();
							$mailm->setTemplate('subject','confirmation_mail_subject.html');
							$mailm->setTemplate('body','confirmation_mail_body.html');
							$mailm->assignArray(array('link_name' => $name, 
												 'link_url' => $url, 
												 'link_description' => $description, 
												 'link_category' => $chemin, 
												 'secret' => $secret));
							$mailm->setFrom($CONFIG['site_mail']);
							$mailm->setTo($email);
							$mailm->sendMail();
							
							$message = $lang['registered'];
							$link_url =  $CONFIG['site_url'];
							$link_name = $lang['home'];
						}
						else
						{
							$state = 1;
							$message = $lang['registered_wo_mail'];
							$link_url =  $CONFIG['site_url'];
							$link_name = $lang['home'];
						}
						
						$link = $lm->create(true);
							$attributes = array('id' => '', 
												'name' => $myts->htmlSpecialChars($name), 
												'url' => $myts->htmlSpecialChars($url), 
												'description' => $myts->htmlSpecialChars($description), 
												'state' => intval($state), 
												'category' => intval($category), 
												'pr' => intval($true_pr), 
												'image' => $url_image, 
												'hits' => 0, 
												'prio' => 0, 
												'email' => $email);
						$link->setVars($attributes);
						$lm->insert($link);
						unset($attributes);
						
						$feed_name = isset($_POST['feed_name']) ? $_POST['feed_name'] : "";
						$feed_url = isset($_POST['feed_url']) ? $_POST['feed_url'] : "";
						if(!empty($feed_name) && !empty($feed_url))
						{
							$fm =& get_manager('feed');
							$attributes = array('name' => $feed_name, 
												'linkid' => $link->getVar('id'), 
												'feed' => $feed_url);
												
							$feed = $fm->create(true);
							$feed->setVars($attributes);
							$fm->insert($feed);
						}
						
						$validation = $vm->create(true);
						$attributes2 = array('id_site' => $link->getVar('id'), 'secret' => $secret, 'url' => $url, 'email' => $email);
						$validation->setVars($attributes2);
						$vm->insert($validation);
						unset($attributes2);
						
						if($CONFIG['inform_admin_about_submission'])
						{
							$mailm = new MailManager();
							$mailm->setTemplate('subject','admin_inform_subject.html');
							$mailm->setTemplate('body','admin_inform_basic_body.html');
							$mailm->assignArray(array('link_name' => $name, 
												 'link_url' => $url, 
												 'link_description' => $description, 
												 'link_category' => $chemin, 
												 'link_pack' => 'BASIC'));
							$mailm->setFrom($email);
							$mailm->setTo($CONFIG['site_mail']);
							$mailm->sendMail();
						}
					}
				}
				else
				{
					$message = $lang['url_notresponding'];
					$link_url =  'javascript:history.go(-1)';
					$link_name = $lang['return'];
				}
			}
		}
		elseif (empty($name) xor empty($description))
		{
			$message = 'Remplissez tous les champs correctement !';
			$link_url =  'javascript:history.go(-1)';
			$link_name = $lang['return'];
		}
		else if(empty($email))
		{
			$message = $lang['nomail'];
			$link_url =  'javascript:history.go(-1)';
			$link_name = $lang['return'];
		}
	}
	else
	{
		$message = $lang['invalid_securitycode'];
		$link_url =  'javascript:history.go(-1)';
		$link_name = $lang['return'];
	}
	
	$smarty->assign("message",$message);
	$smarty->assign("result_link",$link_url);
	$smarty->assign("result_link_text",$link_name);
}

/*
*	Displays the Add site form
*	@param string name, url, description, email, url_image
*	@param int category : id of the category the add form must focus on
*	@param int default : default category chosen in the add form
*/
function getAddSiteform($name, $url, $description, $category, $email, $url_image, $default)
{
	global $CONFIG;
	$smarty =& TemplateEngine::getInstance();
	$re =& MyRewriteEngine::getInstance();
	
	$form_action = $re->buildStandardUrl('main link',array('name' => 'basic'));
	
	$cm =& get_manager("category");
	
	$criteria = new Criteria('usable',1,'=');
	$cols = array('id','name');
	$categories =& $cm->getObjects($criteria,$cols);
	
	foreach($categories as $category)
	{
		$id = $category->getVar('id');
		$cat_name = show_me_the_way($id);
		$smarty->append("form_categories",array('id' => $id, 'name' => $cat_name));
	}

	$thumb_url = "";
	if(!empty($url_image) && ($url_image != '' || $url_image != 'http://'))
	{
		$thumb_url = $url_image;
	}
	else
	{
		$thumb_url = "";
	}

	$smarty->assign(array('site_name' => $name, 
						'submit_form_action' => $form_action, 
						'url' => $url, 
						'description' => $description, 
						'category' => $category, 
						'email' => $email, 
						'default_cat' => $default, 
						'thumb_url' => $thumb_url));
}
?>