<?php

/*
*	displays links referenced in a specific category
*	@param int start : start value in SQL query (useful for paging)
*	@param int racine : root category (current category to display content)
*	@return void
*/
function displayLinks($start, $racine)
{
	global $CONFIG;
	$smarty =& TemplateEngine::getInstance();
	$rewrite_e =& MyRewriteEngine::getInstance();
	
	$begin = $CONFIG['links']*($start-1);

	$lm =& get_manager("link");
	$cm =& get_manager('category');
	
	$category =& $cm->get($racine);
				
	$criteria_compo = new Criteriacompo(new Criteria('state',4,'='),'AND');
	$criteria_compo->add(new Criteria('category',$racine,'='),'AND');
	$criteria_compo->setOrder('DESC');
	$criteria_compo->setSort(array('prio' => 'DESC','vote' => 'DESC'));
	$criteria_compo->setStart($begin);
	$criteria_compo->setLimit($CONFIG['links']);

	
	$links =& $lm->getObjects($criteria_compo);

	if (count($links) > 0)
	{
		affichage_liens($links, $CONFIG['url_rewriting']);

		$criteria_compo = new Criteriacompo(new Criteria('state',4,'='),'AND');
		$criteria_compo->add(new Criteria('category',$racine,'='),'AND');
		
		$total_links_in_cat = $lm->getCount($criteria_compo);
		
		if ($total_links_in_cat > $CONFIG['links'])
		{
			$nb_pages = ceil($total_links_in_cat / $CONFIG['links']);
			$titre_page = show_me_the_way($racine);
			
			for ($i=1; $i<=$nb_pages; $i++)
			{
				$current = $start == $i ? 1 : 0;
				
				if ($i > 1)
				{
					$smarty->append("pages",array('number' => $i, 
												  'url' => $rewrite_e->buildUrl('category page',array('name' => $category->getVar('name'), 
																									  'id' => $racine, 
																									  'page' => $i)), 
												  'current' => $current));
				}
				else
				{
					$smarty->append("pages",array('number' => $i, 
												  'url' => $rewrite_e->buildUrl('category',array('name' => $category->getVar('name'), 
																								 'id' => $racine)), 
												  'current' => $current));
				}
			}
		}
	}
	else if($racine != 0)
	{
		$smarty->assign("nosite",true);
	}
}


/*
*	Displays the way to the root category
*	@param int racine : id of the current root category
*	@return void
*/
function displayWay($racine)
{
	global $CONFIG;
	$smarty =& TemplateEngine::getInstance();
	$way = show_me_the_way_clic($racine, $CONFIG['url_rewriting']);
	$smarty->assign("way_to_cat",$way);
}


/*
*	Checks if there are spamdexing from other websites to this one and sends adequate HTTP headers
*	301 Error : incorrect URL Rewrite
*	404 Error : category not existing
*	@param void
*	@return void
*/
function checkHttpErrors()
{
	global $CONFIG;
	$dir = isset($_GET['dir']) ? $_GET['dir'] : 0;
	$name = isset($_GET['name']) ? $_GET['name'] : "";
	$directory =& MyDirectory::getInstance();
	$re =& MyRewriteEngine::getInstance();
	$cm =& get_manager('category');
	
	$category =& $cm->get($dir,array('id','name'));
	
	if($category)
	{
		$expected_name = $re->code_url($category->getVar('name'));
			
		if($name != $expected_name || empty($name))
		{
			// Search engine spamming or someone bad indexing you
			if($CONFIG['url_rewriting'])
			{
				// Moved permanently
				$location = $re->buildUrl('category', array('site_url' => $CONFIG['site_url'], 
																		'name' => $expected_name, 
																		'id' => $category->getVar('id')));
				$directory->error301($location);
			}
		}
	}
	else
	{
		// No cat existing for this id
		// 404 Error
		$directory->error404();
	}
}
?>