<?php

$id = isset($_GET['id']) ? $_GET['id'] : 0;

$km =& get_manager("keyword");
$re =& MyRewriteEngine::getInstance();

if($id == 0 && !$smarty->is_cached($template,$cache_id))
{
	$myts =& MyTextSanitizer::getInstance();
	
	$criteria = new Criteria('hasresults',1,'=');
	$criteria->setSort('word');
	$criteria->setOrder('ASC');
	
	$cols = array('id','word','occurence');
	
	$keywords =& $km->getObjects($criteria,$cols);
	
	foreach($keywords as $keyword)
	{
		$word = str_replace(" ","-",$keyword->getVar('word'));
		$word = $myts->htmlSpecialChars($word);
		$word = $re->code_url($word);
		
		$url = $re->buildUrl('keyword',array('id' => $keyword->getVar('id'),'word' => $word ));
		
		$smarty->append("keywords", array('id' => $keyword->getVar('id'), 'word' => $myts->htmlEntities($keyword->getVar('word')), 'occurence' => $keyword->getVar('occurence'), 'url' => $url));
	}
	
	$template = 'keywords.html';
}
else
{
	// Keyword id defined
	$directory =& MyDirectory::getInstance();
	$criteria = new Criteria('id',$id,'=');
	$count = $km->getCount($criteria);
	
	if($count == 0)
	{
		$directory->error404();
	}
	else
	{
		$keyword =& $km->get($id,array('word'));
		// check url words and redirect to correct page if words are incorrect
		if($CONFIG['url_rewriting'])
		{
			$words = isset($_GET['words']) ? $_GET['words'] : "";
			$expected_words = $keyword->getVar('word');
			$expected_words = $re->code_url($expected_words);
			
			if(empty($words) || $words != $expected_words)
			{
				// url rewrite with keyword id but words are empty or different from expected words
				$location = $re->buildUrl('keyword',array('id' => $id, 'word' => $expected_words));
				$directory->error301($location);
			}
		}
	}
	
	$template = 'recherche.html';
	if(!$smarty->is_cached($template,$cache_id))
	{
		$seek = $keyword->getVar('word');
		
		include 'recherche.php';
	}
}
?>