<?php

if(isset($_REQUEST["seek"]) and !empty($_REQUEST["seek"]) and strlen($_REQUEST["seek"]) >= $CONFIG['search_minlength'])
{
	$seek = $_REQUEST["seek"];
}
else if(!isset($_REQUEST['id']) || empty($_REQUEST['id']))
{
	$seek = "";
}

if (!empty($seek))
{
	if(isUTF8($seek)) {
		$seek = utf8_decode($seek);
	}
	$seek = strip_tags($seek);
	
	$km =& get_manager("keyword");
	$lm =& get_manager("link");
	$myts =& MyTextSanitizer::getInstance();
	$re = MyRewriteEngine::getInstance();
	
	$my_url = 'index.php?do=recherche&amp;seek='.$seek;
	$start = isset($_GET['start']) ? $_GET['start'] : 0;
	$limit = 10;
	
	$recherche = strtolower($seek);

	$mots = str_replace('+', ' ', trim($recherche));
	$mots = str_replace('\'', ' ', $mots);
	$mots = str_replace('%', ' ', $mots);
	$mots = str_replace(',', ' ', $mots);
	$mots = str_replace(':', ' ', $mots);

	$tab = explode(' ' , $mots);
	$nb = count($tab);
	
	$criteriacompo = new CriteriaCompo(new Criteria('id',0,'='),'OR');

	for($i = 0; $i < $nb; $i++)
	{
		if(strlen($tab[$i]) >= $CONFIG['search_minlength'])
		{
			$criteriacompo->add(new Criteria('name',"%".$tab[$i]."%",'LIKE'),'OR');
			$criteriacompo->add(new Criteria('description',"%".$tab[$i]."%",'LIKE'),'OR');
		}
	}

	$criteriacompo2 = new CriteriaCompo($criteriacompo,'AND');
	$criteriacompo2->add(new Criteria('state',4,'='),'AND');
	
	$total_items = $lm->getCount($criteriacompo2);
	$smarty->assign('total_results',$total_items);
	
	$criteriacompo2->setOrder('DESC');
	$criteriacompo2->setSort('hits');
	$criteriacompo2->setLimit($limit);
	$criteriacompo2->setStart($start);

	// Cols to be selected
	$cols = array('id', 'name', 'url', 'description', 'pr', 'category', 'image', 'hits','vote');
	// retrieving objects
	$links =& $lm->getObjects($criteriacompo2,$cols);
	
	$total_keywords = $km->getCount();
	
	$hasresults = count($links) == 0 ? 0 : 1;
	
	if(count($links) > 0)
	{
		affichage_liens($links, $CONFIG['url_rewriting'], 1);
	}
	else
	{
		// No results
	}
	
	$smarty->assign("resultsfor",$lang['resultsfor']);
	$smarty->assign('searched_expr',$recherche);
	
	$pagenav = new PageNav($total_items, $limit, $start, $my_url);
	
	$smarty->assign('pagenav',$pagenav->renderNavNormal());
	
	if($total_keywords <= $CONFIG['max_keywords'] || $CONFIG['max_keywords'] == 0)
	{
		$criteria = new Criteria('word',$recherche,'=');
		$criteria->setLimit(1);
		$cols = array('occurence');
		$keywords =& $km->getObjects($criteria,$cols);
		
		if(count($keywords) > 0 && !isset($_COOKIE[$recherche]))
		{
			$attributes = array('occurence' => $keywords[0]->getVar('occurence')+1, 'date' => date("Y-m-d"), 'hasresults' => $hasresults);
			$km->update($criteria, $attributes);
		}
		else if(count($keywords) == 0)
		{
			$keyword = $km->create(true);
			$keyword->setVars(array('id' => '', 'word' => $recherche, 'occurence' => 1, 'date' => date("Y-m-d"), 'hasresults' => $hasresults));
			$km->insert($keyword);
		}
		
		// Count only one search per word per day per user
		setcookie($recherche,'1', time()+3600*24);
	}
}
else if (!isset($_POST["seek"]))
{
	$directory =& MyDirectory::getInstance();
	$directory->error301('./');
}
else
{
    $smarty->assign("message",$lang['search_moreprecise']);
}
?>