<?php

/*
*	Entry Point of the website for every front office page
*	Every page displayed in front office
*/

include(dirname(__FILE__).'/init.php');

$do = isset($_GET["do"]) ? $_GET["do"] : "main";
$racine = isset($_GET['dir']) ? $_GET['dir'] : 0;
$start = isset($_GET['start']) ? $_GET['start'] : 1;

switch ($do)
{
	case 'choosepack':
	$template = 'choosepack.html';
	$include = 'choosepack.php';
	break;

	case 'basic':
	session_start();
	$include = 'basic.php';
	break;

	case 'allopass':
	$template = 'allopass.html';
	$include = 'allopass.php';
	break;

	case 'premium':
	$include = 'premium.php';
	break;

	case 'recherche':
	$template = 'recherche.html';
	$include = 'recherche.php';
	break;

	case 'top-rank':
	$template = 'top-rank.html';
	$include = 'top-rank.php';
	break;

	case 'nouveautes':
	$template = 'nouveautes.html';
	$include = 'nouveautes.php';
	break;

	case 'keywords':
	$id = isset($_GET['id']) ? $_GET['id'] : 0;
	$template = 'keywords.html';
	$include = 'keywords.php';
	break;

	case 'confirmation':
	$template = 'confirmation.html';
	$include = 'confirmation.php';
	break;

	case 'top-hits';
	$template = 'top-hits.html';
	$include = 'top-hits.php';
	break;

	case 'top-votes';
	$template = 'top-votes.html';
	$include = 'top-votes.php';
	break;

	case 'allcats':
	$template = 'allcats.html';
	$include = 'allcats.php';
	break;

	case 'boost':
	$template = 'boost.html';
	$include = 'boost.php';
	break;

	case 'contact':
	session_start();
	$template = 'contact.html';
	$include = 'contact.php';
	break;

	case 'main':
	if($racine == 0)
	{
		lastWebsites($racine);
	}
	$template = 'main.html';
	$include = 'main.php';
	break;

	default:
	$directory =& MyDirectory::getInstance();
	$directory->error404();
	break;
}

/* Reload page if :
* - cache disabled
* - page cache not build or expired
* - submit site form : do not cache it !
*/

$excludeFromCache = array('basic','premium','contact','boost','confirmation','recherche', 'allopass');

if(!($CONFIG['use_smartycache'] && $smarty->is_cached($template,$cache_id)) || in_array($do,$excludeFromCache))
{
	if(in_array($do,$excludeFromCache)) {
		$smarty->caching = 0;
	}
	include(dirname(__FILE__).'/include/'.$include);

	$title = getTitle($template, $cache_id);
	$smarty->assign("meta_title",$title);

	// Some information about the directory
	displaySummary($racine);
	// top keywords
	topKeywords();
	// Categories
	displayCats($start, $racine);
	// boost site
	displayBoostSite();
	// TagCloud
	displayTagCloud();
}

// disconnection from database
include(dirname(__FILE__).'/disconnect.php');

// Launching page display
$smarty->display($template, $cache_id);

// Closing database connection
Database::closeInstance();

?>