<?php

/*
*	This is the initialization file
*	It setups : abslute path, benchmarking, configuration, smarty, language, Cache...
*/

/***********************************/
/* Script root path */
define("SCRIPT_ROOT_PATH",dirname(__FILE__));
/* Share directory */
define("SHARE_DIR",dirname(__FILE__).'/share');
/***********************************/


/***********************************/
/* Benchmark Utility */
include_once(SCRIPT_ROOT_PATH.'/class/class.bench.php');
$bench = new Bench();
$bench->startBench();
/***********************************/


/***********************************/
/* configuration file and main functions */
include_once(SCRIPT_ROOT_PATH.'/class/class.config.php');
$config_manager =& MyconfigManager::getInstance();
if(!$config_manager->loadConfig())
{
	// Config load has failed : maybe not installed
	echo '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">';
	echo "<html><head><title>Install</title></head>";
	if(is_writable(SCRIPT_ROOT_PATH.'/public/templates_c'))
	{
		echo "<h4 align='center' style='color: red;'>FreeGlobes is ready for setup...</h4>\n<h3 align='center'>&gt;&gt; <a href=\"install/\">Go to Setup</a> &lt;&lt;</h3>";
	}
	else
	{
		echo "<h4 align='center' style='color: red;'>Please CHMOD 777 this directory : '/public/templates_c'</h4>\n";
		echo "\n<h3 align='center'>&gt;&gt; <a href='.'>Refresh</a> &lt;&lt;</h3>";
	}
	exit();
}

$CONFIG =& $config_manager->getConfig();


include_once(SCRIPT_ROOT_PATH.'/include/common.php');
/***********************************/


/***********************************/
/* Smarty Engine */
include_once(SCRIPT_ROOT_PATH.'/class/class.templateengine.php');

$template_dir = SCRIPT_ROOT_PATH."/themes/".$CONFIG['theme_dir'];
$theme_dir = $CONFIG['site_url']."/themes/".$CONFIG['theme_dir'];

$smarty =& TemplateEngine::getInstance();

$smarty->template_dir = $template_dir;
$smarty->cache_lifetime = $CONFIG['smarty_cache_lifetime'];
$smarty->caching = $CONFIG['use_smartycache'];

$smarty->assign("CONFIG",$CONFIG);
$smarty->assign("theme_dir",$theme_dir);

$smarty->load_filter('output','trimwhitespace');
/***********************************/


/***********************************/
/* Text Sanitizer */
include_once(SCRIPT_ROOT_PATH.'/class/class.textsanitizer.php');
// Texte sanitizer
$myts =& MyTextSanitizer::getInstance();
/***********************************/


/***********************************/
/* Cache ID */
include_once(SCRIPT_ROOT_PATH.'/class/class.cacheid.php');
$cache_id = CacheID::generate();
/***********************************/

/***********************************/
/* Loading MyDirectory class*/
include_once (SCRIPT_ROOT_PATH.'/class/class.dir.php');
/***********************************/

/***********************************/
/* Language manager */
include_once(SCRIPT_ROOT_PATH.'/class/class.languagemanager.php');
$langmanager = new LanguageManager(SCRIPT_ROOT_PATH.'/language/', $CONFIG['language'], 'main.php');
$langmanager->loadLang();
/***********************************/


/***********************************/
/* Database */
include_once(SCRIPT_ROOT_PATH.'/class/database/class.databasefactory.php');
/***********************************/


/***********************************/
/* Metas */
include_once(SCRIPT_ROOT_PATH.'/include/titre.php');
/***********************************/


/***********************************/
/* Loading plugin class */
include_once (SCRIPT_ROOT_PATH.'/class/class.plugins.php');
/***********************************/


/***********************************/
/* Loading RewriteEngine class*/
include_once (SCRIPT_ROOT_PATH.'/class/class.rewriteengine.php');
/***********************************/


/***********************************/
/* MainLinks */
$re =& MyRewriteEngine::getInstance();
$main_links = array("top_rank_url" => $re->buildUrl('main link',array('name' => 'top-rank')),
					"news_url" => $re->buildUrl('main link',array('name' => 'nouveautes')),
					"submit_site_url" => $re->buildUrl('main link',array('name' => 'choosepack')),
					"search_form_action" => $re->buildUrl('main link',array('name' => 'recherche')),
					"top_hits_url" => $re->buildUrl('main link',array('name' => 'top-hits')),
					"top_votes_url" => $re->buildUrl('main link',array('name' => 'top-votes')),
					"keyw_url" => $re->buildUrl('main link',array('name' => 'keywords')),
					"allcats_url" => $re->buildUrl('main link',array('name' => 'allcats')),
					"boost_url" => $re->buildUrl('boost',array('name' => 'boost')));
$smarty->assign($main_links);
/***********************************/


/***********************************/
/* Authentification */
require_once (SCRIPT_ROOT_PATH.'/class/auth/class.authfactory.php');
/***********************************/


/***********************************/
/* date operations */
require_once (SCRIPT_ROOT_PATH.'/class/date/class.date.php');
/***********************************/


/***********************************/
/* TagCloud */
require_once SCRIPT_ROOT_PATH.'/class/class.tagcloud.php';
/***********************************/


/***********************************/
/* Mail Manager */
require_once SCRIPT_ROOT_PATH.'/class/class.mailmanager.php';
/***********************************/


/***********************************/
/* Page Nav */
require_once SCRIPT_ROOT_PATH.'/class/class.pagenav.php';
/***********************************/

?>