<?php

$img_chk_on = "./images/check_on.png";
$img_chk_off = "./images/check_off.png";
$img_chk_wrn = "./images/check_wrn.png";
$lang_to_load = isset($_GET['language']) ? $_GET['language'] : '';

if(!empty($lang_to_load))
{
	setcookie("language",$lang_to_load,time()+3600,'/');
}
else
{
	header('Location: ./');
	exit();
}

$file = 'check.php';
include_once ('init.php');
require_once (SCRIPT_ROOT_PATH.'/class/class.checklist.php');
$lang =& $langmanager->getLang();
$title = "Installation";
$smarty->assign("title",$title);

$php_check = new checkList();

$php_check->addItem('php',version_compare(phpversion(),'4.1','>='),
sprintf($lang['phpversion'],phpversion()),
sprintf($lang['phprequired'],phpversion())
);

# V�rification de la pr�sence des fonctions MySQL
$php_check->addItem('mysql',function_exists('mysql_connect'),
sprintf($lang['ispresent'],'MySQL'),
sprintf($lang['isnotpresent'],'MySQL')
);

# V�rification de la pr�sence du module XML
$php_check->addItem('xml',function_exists('xml_parser_create'),
sprintf($lang['ispresent'],'XML'),
sprintf($lang['isnotpresent'],'XML')
);

$php_check->addItem('png',function_exists('imagepng'),
sprintf($lang['ispresent'],'GD'),
sprintf($lang['isnotpresent'],'GD')
);


$php_checks = $php_check->getHTML($img_chk_on,$img_chk_off,$img_chk_wrn);
$smarty->assign("php_checks",$php_checks);

$files_check = new checkList();

# V�rification des droits sur /conf
$files_check->addItem('conf',is_writable(dirname(__FILE__).'/../conf'),
sprintf($lang['iswritable'],'conf/'),
sprintf($lang['isnotwritable'],'conf/')
);

$files_check->addItem('config.php',is_writable(dirname(__FILE__).'/../conf/config.php'),
sprintf($lang['iswritable'],'conf/config.php'),
sprintf($lang['isnotwritable'],'conf/config.php'));

$files_check->addItem('htaccess',is_writable(dirname(__FILE__).'/../.htaccess'),
sprintf($lang['iswritable'],'.htaccess'),
sprintf($lang['isnotwritable'],'.htaccess'));

$files_check->addItem('templates_c',is_writable(dirname(__FILE__).'/../public/templates_c'),
sprintf($lang['iswritable'],'public/templates_c/'),
sprintf($lang['isnotwritable'],'public/templates_c/')
);

$files_check->addItem('cache',is_writable(dirname(__FILE__).'/../public/cache'),
sprintf($lang['iswritable'],'public/cache/'),
sprintf($lang['isnotwritable'],'public/cache/')
);

$files_check->addItem('prcache',is_writable(dirname(__FILE__).'/../public/prcache'),
sprintf($lang['iswritable'],'public/prcache/'),
sprintf($lang['isnotwritable'],'public/prcache/')
);

$files_check->addItem('share',is_writable(dirname(__FILE__).'/../share'),
sprintf($lang['iswritable'],'share/'),
sprintf($lang['isnotwritable'],'share/')
);

$files_check->addItem('themes',is_writable(dirname(__FILE__).'/../themes'),
sprintf($lang['iswritable'],'themes/'),
sprintf($lang['isnotwritable'],'themes/')
);

$files_check->addItem('thumbs',is_writable(dirname(__FILE__).'/../public/thumbs'),
sprintf($lang['iswritable'],'public/thumbs/'),
sprintf($lang['isnotwritable'],'public/thumbs/')
);


$files_checks = $files_check->getHTML($img_chk_on,$img_chk_off,$img_chk_wrn);
$smarty->assign("files_checks",$files_checks);

if ($php_check->checkAll() && $files_check->checkAll())
{
	$next_step = '<p><strong>'.$lang['check_ok'].'</strong></p>';
	$next_step .= '<form action="db-pref.php" method="post">'.
	'<p><input type="submit" class="submit" value="'.$lang['nextstep'].' &#187;" /></p>'.
	'</form>';

}
else
{
	$next_step = '<p><strong>'.$lang['check_ko'].' :</strong></p>';
	if (!$php_check->checkAll()) {
		$next_step .= '<p><strong>'.$lang['check_php_ko'].'</strong></p>';
	}
	if(!$files_check->checkAll()) {
		$next_step .= '<p><strong>'.$lang['check_files_ko'].'</strong></p>';
	}

}
$smarty->assign("next_step",$next_step);

$smarty->display("install_check.tpl");

?>