<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2004 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

$file = 'db-install.php';
require_once ('init.php');
require_once (SCRIPT_ROOT_PATH.'/class/database/class.xmlsql.php');
require_once (SCRIPT_ROOT_PATH.'/class/database/class.databasefactory.php');
require_once (SCRIPT_ROOT_PATH.'/class/class.checklist.php');
require_once (SCRIPT_ROOT_PATH.'/class/class.config.php');

$db_host = isset($_REQUEST['dbhost']) ? $_REQUEST['dbhost'] : '';
$db_user = isset($_REQUEST['dbuser']) ? $_REQUEST['dbuser'] : '';
$db_pass = isset($_REQUEST['dbpass']) ? $_REQUEST['dbpass'] : '';
$db_name = isset($_REQUEST['dbname']) ? $_REQUEST['dbname'] : '';
$db_prefix = isset($_REQUEST['dbprefix']) ? $_REQUEST['dbprefix'] : '';

$cm = MyConfigManager::getInstance();
$CONFIG['db_login'] = $db_user;
$CONFIG['db_pass'] = $db_pass;
$CONFIG['db_host'] = $db_host;
$CONFIG['db_name'] = $db_name;
$CONFIG['db_prefix'] = $db_prefix;
$CONFIG['site_url'] = str_replace('/install','',$CONFIG['site_url']);
$cm->setVars($CONFIG);

$img_chk_on = "./images/check_on.png";
$img_chk_off = "./images/check_off.png";
$img_chk_wrn = "./images/check_wrn.png";

if(empty($db_host) || empty($db_user) || empty($db_name))
{
	header('Location: ./');
	exit();
}

$con =& DatabaseFactory::getConnection();

# On vrifie si les tables existent
$prefix = !empty($db_prefix) ? $db_prefix.'_' : '';

$strReq = "SHOW TABLES LIKE '".$prefix."%s'";

$rs = $con->select(sprintf($strReq,'allopass'));
$installed['allopass'] = !$rs->isEmpty();

$rs = $con->select(sprintf($strReq,'boost'));
$installed['boost'] = !$rs->isEmpty();

$rs = $con->select(sprintf($strReq,'cat2pub'));
$installed['cat2pub'] = !$rs->isEmpty();

$rs = $con->select(sprintf($strReq,'category'));
$installed['category'] = !$rs->isEmpty();

$rs = $con->select(sprintf($strReq,'comment'));
$installed['comment'] = !$rs->isEmpty();

$rs = $con->select(sprintf($strReq,'emplacement'));
$installed['emplacement'] = !$rs->isEmpty();

$rs = $con->select(sprintf($strReq,'feed'));
$installed['feed'] = !$rs->isEmpty();

$rs = $con->select(sprintf($strReq,'in'));
$installed['in'] = !$rs->isEmpty();

$rs = $con->select(sprintf($strReq,'inlog'));
$installed['inlog'] = !$rs->isEmpty();

$rs = $con->select(sprintf($strReq,'iplog'));
$installed['iplog'] = !$rs->isEmpty();

$rs = $con->select(sprintf($strReq,'keyword'));
$installed['keyword'] = !$rs->isEmpty();

$rs = $con->select(sprintf($strReq,'link'));
$installed['link'] = !$rs->isEmpty();

$rs = $con->select(sprintf($strReq,'partner'));
$installed['partner'] = !$rs->isEmpty();

$rs = $con->select(sprintf($strReq,'pub'));
$installed['pub'] = !$rs->isEmpty();

$rs = $con->select(sprintf($strReq,'tag'));
$installed['tag'] = !$rs->isEmpty();

$rs = $con->select(sprintf($strReq,'user'));
$installed['user'] = !$rs->isEmpty();

$rs = $con->select(sprintf($strReq,'validation'));
$installed['validation'] = !$rs->isEmpty();

$install_ok = true;
foreach($installed as $install)
{
	$install_ok = $install_ok && $install;
}

if ($install_ok)
{
	// Already installed
	$smarty->assign('err',$lang['alreadyinstalled']);
	$smarty->assign('form_create_user','<form action="db-user.php" method="post">'.
		'<p><input type="submit" class="submit" value="'.$lang['nextstep'].' &#187;" /></p>'.
		'</form>');
}
else
{
	$sql_check = new checklist();
	
	$db_create_xml = file(dirname(__FILE__).'/db-create.xml');
	$db_create_xml = str_replace('%db_prefix%',$db_prefix,$db_create_xml);
	
	$xsql = new xmlsql($con,implode('',$db_create_xml));
	$xsql->execute($sql_check);
	
	$smarty->assign('sql_check',$sql_check->getHTML($img_chk_on,$img_chk_off,$img_chk_wrn));
	
	if (!$sql_check->checkAll())
	{
		$smarty->assign('tablecreationko',$lang['tablecreationko']);
	}
	else
	{
		$smarty->assign('tablecreationok',$lang['tablecreationok']);
		
		if ($sql_check->checkWarnings()) {
			$smarty->assign('warningsbutok',$lang['warningsbutok']);
		}
		
		// renaming tables to integrate table prefix
/*		$mydir =& MyDirectory::getInstance();
		
		foreach($mydir->tables as $table)
		{
			$sql = "RENAME TABLE `".$CONFIG['db_name']."`.`".$table."` TO `".$CONFIG['db_name']."`.`".$CONFIG['db_prefix']."_".$table."`";
			$con->execute($sql);
		}
*/		
		$smarty->assign('form_create_user','<form action="db-user.php" method="post">'.
		'<p><input type="submit" class="submit" value="'.$lang['create_user'].' &#187;" /></p>'.
		'</form>');
	}
	
	$con->close();
}

// Cration du fichier de configuration
$cm->updateConfig();

$smarty->display('install_db-install.tpl');
?>