<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2004 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

$img_chk_on = "./images/check_on.png";
$img_chk_off = "./images/check_off.png";
$img_chk_wrn = "./images/check_wrn.png";

$file = 'db-user.php';
include_once ('init.php');

include_once (SCRIPT_ROOT_PATH.'/class/database/class.xmlsql.php');
include_once (SCRIPT_ROOT_PATH.'/class/class.textsanitizer.php');
require_once (SCRIPT_ROOT_PATH.'/class/database/class.databasefactory.php');
require_once (SCRIPT_ROOT_PATH.'/class/class.checklist.php');
include_once (SCRIPT_ROOT_PATH.'/class/class.config.php');

$created = false;
$err = '';

if (!empty($_POST['create']))
{
	// Add user

	$user_manager =& get_manager('user');
	$user = $user_manager->create(true);
	
	$user->setVars(array('id' => '', 'login' => $_POST['login'], 'pass' => md5($_POST['pass']), 'email' => $_POST['email'], 'isadmin' => 1));
	
	$admin_config = array('site_mail' => $_POST['email']);
	$cm = MyConfigManager::getInstance();
	$cm->setVars($admin_config);
	$cm->updateConfig();
	
	if($user_manager->insert($user))
	{
		$created = true;
	}
	else
	{
		$con =& DatabaseFactory::getConnection();
		$err = $con->error();
	}
}

if ($created)
{
	$user_check = new checkList();
	$user_check->addItem('user',true,$lang['useradded'],'');
	$smarty->assign('user_checks',$user_check->getHTML($img_chk_on,$img_chk_off,$img_chk_wrn));
	
	$smarty->assign('next_step','<form action="ini-file.php" method="post">'.
	'<p><input type="submit" class="submit" value="'.$lang['nextstep'].' &#187;" /></p>'.
	'</form>');
}
else
{
	$smarty->assign('fisrtuserconsign',$lang['fisrtuserconsign']);
	
	if ($err != '') {
		$smarty->assign('err',$lang['errors'].' : <br />'.$err);
	}
	
	$smarty->assign('form_create_user','<form action="db-user.php" method="post"><table>'.
	'<tr><td><label class="float" for="p_name">'.$lang['login'].'* :</label> </td><td>'.
	'<input type="text" name="login" value="" size="20" maxlength="33" />'.'</td></tr>'.
	'<tr><td><label class="float" for="p_fname">'.$lang['pass'].'* :</label> </td><td>'.
	'<input type="text" name="pass" value="" size="20" maxlength="33" />'.'</td></tr>'.
	'<tr><td><label class="float" for="p_login">'.$lang['email'].'* :</label> </td><td>'.
	'<input type="text" name="email" value="" size="20" maxlength="100" />'.'</td></tr>'.
	'<tr><td><input type="submit" class="submit" value="'.$lang['create_user'].' &#187;" />'.
	'<input type="hidden" name="create" value="1" />'.'</td></tr>'.
	'</table></form>');
}

$smarty->display('install_db-user.tpl');
?>
