<?php

//include charts.php to access the SendChartData function
include "../../init.php";

function getInPoints()
{
	global $CONFIG;
	$um =& get_manager('user');
	$lm =& get_manager('link');
	$inm =& get_manager('in');
	
	$total_ins_points = 0;
	$total_ins = 0;
	
	$criteria = new CriteriaCompo(new Criteria('uid',$um->myUID(),'='),'AND');
	$ins =& $inm->getObjects($criteria,array('ins'));
	
	if(count($ins) > 0)
	{
		$total_ins = 0;
		
		foreach($ins as $in)
		{
			$total_ins = $total_ins + $in->getVar('ins');
		}
		
		$total_ins_points = $total_ins * $CONFIG['points_per_in'];
	}
	
	return $total_ins_points;
}

function getAllPoints()
{
	global $CONFIG;
	$um =& get_manager('user');
	$lm =& get_manager('link');
	
	$total_votes = 0;
	$total_hits = 0;
	
	$hits_points = 0;
	$votes_points = 0;
	$submission_points = 0;
	
	$criteria = new CriteriaCompo(new Criteria('uid',$um->myUID(),'='),'AND');
	$criteria->add(new Criteria('state',4,'='),'AND');
	
	$links =& $lm->getObjects($criteria,array('hits','vote'));
	$link_count = count($links);
	
	if($link_count > 0)
	{
		foreach($links as $link)
		{
			$total_votes = $total_votes + $link->getVar('vote');
			$total_hits = $total_hits + $link->getVar('hits');
		}
		
		$hits_points = $total_hits * $CONFIG['points_per_clic'];
		$votes_points = $total_votes * $CONFIG['points_per_vote'];
		$submission_points = $link_count * $CONFIG['points_per_submit'];
	}
	
	return array('vote' => $votes_points, 
				 'hit' => $hits_points, 
				 'submission' => $submission_points, 
				 'ins' => getInPoints());
}

$points = getAllPoints();

$chart[ 'chart_data' ] = array ( array ( "", $lang['visits'], 
										 $lang['votes'], 
										 $lang['incoming_visitor'], 
										 $lang['submission']), 
										 array ( "", $points['hit'], 
												 $points['vote'], 
												 $points['ins'], 
												 $points['submission']) );

$chart[ 'chart_grid_h' ] = array ( 'thickness'=> 0 );
$chart[ 'chart_pref' ] = array ( 'rotation_x'=>60 ); 
$chart[ 'chart_rect' ] = array ( 'x'=>50, 'y'=>50, 'width'=>300, 'height'=>200, 'positive_alpha'=>0 );
$chart[ 'chart_transition' ] = array ( 'type'=>"spin", 'delay'=>.5, 'duration'=>.5, 'order'=>"category" );
$chart[ 'chart_type' ] = "3d pie";
$chart[ 'chart_value' ] = array ( 'color'=>"000000", 'alpha'=>65, 'font'=>"arial", 'bold'=>true, 'size'=>10, 'position'=>"inside", 'prefix'=>"", 'suffix'=>"", 'decimals'=>0, 'separator'=>"", 'as_percentage'=> true );

$chart[ 'legend_label' ] = array ( 'layout'=>"horizontal", 'bullet'=>"circle", 'font'=>"arial", 'bold'=>true, 'size'=>12, 'color'=>"ffffff", 'alpha'=>85 ); 
$chart[ 'legend_rect' ] = array ( 'x'=>0, 'y'=>45, 'width'=>50, 'height'=>210, 'margin'=>10, 'fill_color'=>"ffffff", 'fill_alpha'=>10, 'line_color'=>"000000", 'line_alpha'=>0, 'line_thickness'=>0 );  
$chart[ 'legend_transition' ] = array ( 'type'=>"dissolve", 'delay'=>0, 'duration'=>1 );

$chart[ 'series_color' ] = array ( "00ff88", "ffaa00","44aaff", "aa00ff" ); 
$chart[ 'series_explode' ] = array ( 10, 10, 10, 10 );

SendChartData ($chart);

?>