<?php

/*
*	Displays either Add link or edit link form
*	@param string url
*	@param int id : default value is 0 (new site); id of the site to edit (editing a website)
*	@return void
*/
function getLinkForm($url, $id = 0)
{
	global $CONFIG, $lang;
	
	if(@ini_get('allow_url_fopen') == 1) {
		$isSpam = file_get_contents('http://www.freeglobes.net/antispam/isspam.php?ip='.$_SERVER['REMOTE_ADDR'].'&email='.$email.'&url='.$url);
		if($isSpam == 'yes') {
			exit();
		}
	}
	
	$smarty =& TemplateEngine::getInstance();
	$lm =& get_manager("link");
	$cm =& get_manager("category");
	$um =& get_manager('user');
	
	$login = isset($_COOKIE['login']) ? $_COOKIE['login'] : '';
	$pass = isset($_COOKIE['pass']) ? $_COOKIE['pass'] : '';
	
	if(!empty($login) && !empty($pass))
	{
		$criteria = new CriteriaCompo(new Criteria('login',$login,'='),'AND');
		$criteria = new CriteriaCompo(new Criteria('pass',$pass,'='),'AND');
		$criteria->setLimit(1);
		$user =& $um->getObjects($criteria);
		
		
		$name = isset($_POST['name']) ? $_POST['name'] : "";
		$url_posted = isset($_POST['url']) ? $_POST['url'] : "http://";
		$description = isset($_POST['description']) ? $_POST['description'] : "";
		$category = isset($_POST['category']) ? $_POST['category'] : 0;
		$url_image = isset($_POST['url_image']) ? $_POST['url_image'] : "";
		$email = $user[0]->getVar('email');
		$mail = '';
		
		if(isset($_POST['Metas']) && $url_posted != '' && $url_posted != 'http://')
		{
			list($url_posted,$url_image,$nom_proprio,$mail,$name,$description) = preremplir_formulaire($url_posted,true);
		}

		$smarty->assign("form_action",$url);
		$smarty->assign("bouton",$lang['submit']);
		$smarty->assign('title',$lang['yessubmit']);
		$allow = $CONFIG['get_meta_tags'] == 1 ? true : false;
		$smarty->assign('allow_metadetection',$allow);
		
		$smarty->assign('name',$name);
		$smarty->assign('url_posted',$url_posted);
		$smarty->assign('description',$description);
		$smarty->assign('image',$url_image);
		$smarty->assign('email',$email);

		$categories =& $cm->getObjects(new Criteria('usable',1,'='),array('id'));

		if($categories && count($categories) > 0)
		{
			foreach($categories as $category)
			{
				$id = $category->getVar('id');
				$name = show_me_the_way($id);
				if ($id==$category)
				{
					$smarty->append("categories", array('name' => $name, 'id' => $id, 'selected' => 'selected="selected"'));
				}
				else
				{
					$smarty->append("categories", array('name' => $name, 'id' => $id, 'selected' => ''));
				}
			}
		}
		if($url_image != '' && $url_image != 'http://')
		{
			$image = $url_image;
		}
		else
		{
			$image = $CONFIG['site_url']."/themes/admin/images/nothumb.gif";
		}
		displayFckEditor($description);
		$smarty->assign("site_image", $image);
	}
}

/*
*	Checks if all the fields submited were filled in correctly; then adds the website to database
*	@param string url : useful for setting form action url
*	@return void
*/
function addSite($url)
{
	global $CONFIG, $lang;
	$smarty =& TemplateEngine::getInstance();
	$lm =& get_manager("link");
	$um =& get_manager('user');
	
	$name = isset($_POST['name']) ? strip_tags($_POST['name']) : "";
	$url_posted = isset($_POST['url']) ? strip_tags($_POST['url']) : "http://";
	$description = isset($_POST['description']) ? strip_tags($_POST['description']) : "";
	$category = isset($_POST['category']) ? strip_tags($_POST['category']) : 0;
	$url_image = isset($_POST['url_image']) ? strip_tags($_POST['url_image']) : "";
	$hits = 0;
	$prio = 0;
	$vote = 0;
	$uid = isset($_COOKIE['uid']) ? intval($_COOKIE['uid']) : 0;
	
	$login = isset($_COOKIE['login']) ? $_COOKIE['login'] : '';
	$pass = isset($_COOKIE['pass']) ? $_COOKIE['pass'] : '';
	
	$criteria = new CriteriaCompo(new Criteria('login',$login,'='),'AND');
	$criteria = new CriteriaCompo(new Criteria('pass',$pass,'='),'AND');
	$criteria->setLimit(1);
	$user =& $um->getObjects($criteria);
	$email = $user[0]->getVar('email');
	
	if ((!empty($name)) and (!empty($description)))
	{
		if($CONFIG['check_url'])
		{
			$test_url = checkurl($url_posted);
		}
		else
		{
			$test_url = true;
		}
		
		if ($test_url)
		{
			$parsed_url = parse_url($url_posted);
			$host_with_www = $parsed_url['host'];
			$host_without_www = str_replace('www','',$parsed_url['host']);
			$criteria = new CriteriaCompo(new Criteria('url','%'.$host_with_www.'%','LIKE'),'OR');
			$criteria->add(new Criteria('url','%'.$host_without_www.'%','LIKE'),'OR');
			$criteria->setLimit(1);
			$already_existing = $lm->getCount($criteria);
			
			if($already_existing == 0)
			{
				$link = $lm->create(true);
				$attributes = array('id' => '', 
									'uid' => $uid, 
									'name' => $name, 
									'url' => $url_posted, 
									'description' => $description, 
									'state' => 1, 
									'category' => intval($category), 
									'pr' => 0, 
									'image' => $url_image, 
									'hits' => 0, 
									'prio' => 0, 
									'vote' => 0, 
									'email' => $email);
				$link->setVars($attributes);
				$lm->insert($link);
				
				$feed_name = isset($_POST['feed_name']) ? $_POST['feed_name'] : "";
				$feed_url = isset($_POST['feed_url']) ? $_POST['feed_url'] : "";
				if(!empty($feed_name) && !empty($feed_url))
				{
					$fm =& get_manager('feed');
					$attributes = array('name' => strip_tags($feed_name), 
										'linkid' => intval($link->getVar('id')), 
										'feed' => strip_tags($feed_url));
										
					$feed = $fm->create(true);
					$feed->setVars($attributes);
					$fm->insert($feed);
				}
				
				if($CONFIG['inform_admin_about_submission'])
				{
					$chemin = show_me_the_way($category);
					
					$mailm = new MailManager();
					$mailm->setTemplate('subject','admin_inform_subject.html');
					$mailm->setTemplate('body','admin_inform_basic_body.html');
					$mailm->assignArray(array('link_name' => $name, 
										 'link_url' => $url_posted, 
										 'link_description' => $description, 
										 'link_category' => $chemin, 
										 'link_pack' => 'MEMBER'));
					$mailm->setFrom($CONFIG['site_mail']);
					$mailm->setTo($CONFIG['site_mail']);
					$mailm->sendMail();
				}
				
				foreach($_POST as $key => $value)
				{
					unset($_POST[$key]);
				}
			}
			else
			{
				// Website already submitted
				$smarty->assign("link_warning",$lang['already_existing_link']);
			}
		}
		else
		{
			$smarty->assign("link_warning",$lang['url_notresponding']);
		}
	}
	else if (empty($name) xor empty($description))
	{
		$smarty->assign("link_warning",$lang['fill_allfields']);
	}
}

?>