<?php

/*
*	Generates a random password if password is lost
*	@param int length : length of the password to generate
*	@return string : generated password
*/
function generatePassword ($length = 8)
{
	// start with a blank password
	$password = "";
	// define possible characters
	$possible = "0123456789bcdfghjkmnpqrstvwxyz"; 
	// set up a counter
	$i = 0; 
	// add random characters to $password until $length is reached
	while ($i < $length)
	{ 
		// pick a random character from the possible ones
		$char = substr($possible, mt_rand(0, strlen($possible)-1), 1);
			
		// we don't want this character if it's already in the password
		if (!strstr($password, $char))
		{ 
		  $password .= $char;
		  $i++;
		}
	}
	// done!
	return $password;
}

/*
*	Sending the new password generated by mail
*	@param void
*	@return void
*/
function sendPassword()
{
	global $lang, $CONFIG;
	$email = isset($_POST['email']) ? $_POST['email'] : '';
	$smarty =& TemplateEngine::getInstance();
	
	if(!empty($email))
	{
		$um =& get_manager('user');
		
		$criteria = new CriteriaCompo(new Criteria('email',$email,'='),'AND');
		$criteria->add(new Criteria('isadmin',0,'='),'AND');
		$criteria->setLimit(1);
		$users =& $um->getObjects($criteria);
		
		if(count($users) == 1)
		{
			// User found
			foreach($users as $user)
			{
				if(function_exists("mail"))
				{
					$new_password = generatePassword();
					$user->setVar('pass',md5($new_password));
					$um->insert($user);
					
					$mailm = new MailManager();
					$mailm->setTemplate('subject','lostpwd_mail_subject.html');
					$mailm->setTemplate('body','lostpwd_mail_body.html');
					
					$mail_infos = array('user_login' => $user->getVar('login'), 
										'user_password' => $new_password);
					
					$mailm->assignArray($mail_infos);
					$mailm->setFrom($CONFIG['site_mail']);
					$mailm->setTo($user->getVar('email'));
					$mailm->sendMail();
					
					$smarty->append('warning',sprintf($lang['email_sent'],$user->getVar('email')));
				}
				else
				{
					$smarty->append('warning',$lang['mail_notpossible']);
				}
					
			}
		}
		else
		{
			// User not existing
			$smarty->append('warning',$lang['invalid_email']);
		}
	}
}

?>