<?php

function displayEmplacements($my_name,$my_url)
{
	global $lang;
	$str = '';
	$smarty =& TemplateEngine::getInstance();
	
	$empm =& get_manager('emplacement');
	$emplacements =& $empm->getObjects();
	
	if(count($emplacements) > 0)
	{
			$str .= '
			<h2>'.$lang['adv_emplacements'].'</h2>
			<div align="center">
			<table cellpadding="3" width="100%">
			<tr bgcolor="#F0F0F0">
				<th>
					&nbsp;
				</th>
				<th>
					&nbsp;
				</th>
				<th>
					'.$lang['adv_id'].'
				</th>
				<th>
					'.$lang['adv_name'].'
				</th>
				<th>
					'.$lang['adv_width'].'
				</th>
				<th>
					'.$lang['adv_height'].'
				</th>
			</tr>
			';
	
		global $CONFIG, $lang;
		$i = 0;
		$delete = $CONFIG['site_url'].'/themes/admin/images/delete.png';
		$edit = $CONFIG['site_url'].'/themes/admin/images/edit.png';
		
		foreach($emplacements as $emplacement)
		{
			$color = $i == 0 ? "#F0F0F0" : "#FFFFFF";
			$i = $i == 1 ? 0 : 1;
			
			$str .= '
			<tr bgcolor="'.$color.'">
				<td>
					<center>
						<a href="'.$my_url.'&amp;do=editEmplacement&amp;id='.$emplacement->getVar('id').'">
							<img src="'.$edit.'" alt="" border="0" />
						</a>
					</center>
				</td>
				<td>
					<center>
						<a href="'.$my_url.'&amp;operation=deleteEmplacement&amp;id='.$emplacement->getVar('id').'" onclick="return confirm(\''.$lang['adv_confirm_delete_emp'].'\');">
							<img src="'.$delete.'" alt="" border="0" />
						</a>
					</center>
				</td>
				<td style="text-align: center;">
					'.$emplacement->getVar('id').'
				</td>
				<td style="text-align: center;">
					'.$emplacement->getVar('name').'
				</td>
				<td style="text-align: center;">
					'.$emplacement->getVar('width').'
				</td>
				<td style="text-align: center;">
					'.$emplacement->getVar('height').'
				</td>
			</tr>
			';
		}
		
			$str .= '
			</table>
			</div>
			';
	}
	
	return $str;
}

function addEmplacement()
{
	global $lang;
	$smarty =& TemplateEngine::getInstance();
	$empm =& get_manager('emplacement');
	
	$id = isset($_REQUEST['id']) ? $_REQUEST['id'] : 0;
	$name = isset($_REQUEST['name']) ? $_REQUEST['name'] : '';
	$width = isset($_REQUEST['width']) ? $_REQUEST['width'] : 468;
	$height = isset($_REQUEST['height']) ? $_REQUEST['height'] : 60;
	
	$attributes = array('id' => $id, 
						'name' => $name, 
						'width' => $width, 
						'height' => $height);
	
	$new = $id == 0 ? true : false;
	$emplacement = $empm->create($new);
	$emplacement->setVars($attributes);
	
	$empm->insert($emplacement);
	
	$smarty->append('warning',$lang['adv_add_emp_ok']);
}

function getEmplacementForm($my_name,$my_url,$p = array())
{
	global $lang;
	$str = '';
	
	if(count($p) > 0)
	{
		$do = 'editEmplacement';
		$operation = '';
		foreach($p as $key => $value)
		{
			$$key = $value;
		}
	}
	else
	{
		$do = '';
		$operation = 'addEmplacement';
		$name = '';
		$width = '';
		$height = '';
		$id = 0;
	}
	
	$str .= '
	<h2>'.$lang['adv_emplacement_form'].'</h2><br />
	<div align="center">
		<form action="'.$my_url.'" method="post">
		<input type="hidden" name="do" value="'.$do.'" />
		<input type="hidden" name="operation" value="'.$operation.'" />
		<input type="hidden" name="id" value="'.$id.'" />
		<table>
			<tr>
				<td>
					'.$lang['adv_name'].' :
				</td>
				<td>
					<input type="text" name="name" value="'.$name.'" />
				</td>
			</tr>
			<tr>
				<td>
					'.$lang['adv_width'].' :
				</td>
				<td>
					<input type="text" name="width" value="'.$width.'" />
				</td>
			</tr>
			<tr>
				<td>
					'.$lang['adv_height'].' :
				</td>
				<td>
					<input type="text" name="height" value="'.$height.'" />
				</td>
			</tr>
			<tr>
				<td>
					&nbsp;
				</td>
				<td>
					<input type="submit" name="modifyEmplacement" value="OK" />
				</td>
			</tr>
		</table>
		</form>
	</div>
	';
	
	return $str;
}

function displayEmplacementCode($id_emp = 0,$my_name = '')
{
	$str = '
	<{plugin name="'.$my_name.'" call="displayEmplacement" parameters="'.$id_emp.'"}>
	';
	
	return htmlentities($str);
}

function displayPub($my_name,$my_url,$id_emp)
{
	global $lang, $CONFIG;
	$str = '';
	$pubm =& get_manager('pub');
	$cat2pubm =& get_manager('cat2pub');
	$cm =& get_manager('category');
	
	$total_categories = $cm->getCount();
	
	$criteria = new Criteria('id_emp',$id_emp,'=');
	
	$pubs =& $pubm->getObjects($criteria);
	
	if(count($pubs) > 0)
	{
		$str .= '
		<h2>'.$lang['adv_pubs'].'</h2>
		<div align="center">
			<table width="100%">
			<tr bgcolor="#F0F0F0">
				<th>
					&nbsp;
				</th>
				<th>
					&nbsp;
				</th>
				<th>
					'.$lang['adv_id'].'
				</th>
				<th>
					'.$lang['adv_name'].'
				</th>
				<th>
					'.$lang['adv_code'].'
				</th>
				<th>
					'.$lang['adv_categories'].'
				</th>
			</tr>
		';
		
		$i = 0;
		$delete = $CONFIG['site_url'].'/themes/admin/images/delete.png';
		$edit = $CONFIG['site_url'].'/themes/admin/images/edit.png';
		
		foreach($pubs as $pub)
		{
			$color = $i == 0 ? "#F0F0F0" : "#FFFFFF";
			$i = $i == 1 ? 0 : 1;
			
			$category_count = $cat2pubm->getCount(new Criteria('idpub',$pub->getVar('id'),'='));
			if($category_count == $total_categories)
			{
				$category_count = $lang['adv_all_cats'];
			}
			
			$str .= '
			<tr bgcolor="'.$color.'">
				<td>
					<center>
						<a href="'.$my_url.'&amp;do=editPub&amp;id='.$pub->getVar('id').'">
							<img src="'.$edit.'" alt="" border="0" />
						</a>
					</center>
				</td>
				<td>
					<center>
						<a href="'.$my_url.'&amp;operation=deletePub&amp;id='.$pub->getVar('id').'" onclick="return confirm(\''.$lang['adv_confirm_delete_pub'].'\');">
							<img src="'.$delete.'" alt="" border="0" />
						</a>
					</center>
				</td>
				<td style="text-align: center;">
					'.$pub->getVar('id').'
				</td>
				<td style="text-align: center;">
					'.$pub->getVar('name').'
				</td>
				<td style="text-align: center;">
					'.htmlspecialchars($pub->getVar('code')).'
				</td>
				<td style="text-align: center;">
					'.$category_count.'
				</td>
			</tr>
			';
		}
		
		$str .= '
			</table>
		</div>
		';
	}
	
	return $str;
}

function addPub()
{
	global $lang;
	$smarty =& TemplateEngine::getInstance();
	$pubm =& get_manager('pub');
	
	$id = isset($_REQUEST['id']) ? $_REQUEST['id'] : 0;
	$id_emp = isset($_REQUEST['id_emp']) ? $_REQUEST['id_emp'] : 0;
	$name = isset($_REQUEST['name']) ? $_REQUEST['name'] : '';
	$code = isset($_REQUEST['code']) ? $_REQUEST['code'] : '';
	
	$attributes = array('id' => $id, 
						'id_emp' => $id_emp, 
						'code' => $code, 
						'name' => $name);
	
	$new = $id == 0 ? true : false;
	$pub = $pubm->create($new);
	$pub->setVars($attributes);
	
	$pubm->insert($pub);
	if($id == 0)
	{
		$id = $pub->getVar('id');
	}
	
	$categories = isset($_REQUEST['categories']) ? $_REQUEST['categories'] : array();
	
	$cat2pubm =& get_manager('cat2pub');
	
	if(!$new)
	{
		$criteria = new Criteria('idpub',$id,'=');
		$cat2pubm->deleteAll($criteria);
	}
	
	if(count($categories) > 0)
	{	
		foreach($categories as $key => $category)
		{
			$cat2pub = $cat2pubm->create(true);
			
			$attributes = array('idcat' => intval($category), 
								'idpub' => $id);
								
			$cat2pub->setVars($attributes);
			
			$cat2pubm->insert($cat2pub);
		}
	}
	$message = $new == true ? $lang['adv_add_pub_ok'] : $lang['adv_update_pub_ok'];
	$smarty->append('warning',$message);
}

function getPubForm($my_name,$my_url,$p = array())
{
	global $lang;
	$str = '';
	
	if(count($p) > 0)
	{
		$do = 'editPub';
		$operation = '';
		foreach($p as $key => $value)
		{
			$$key = $value;
		}
	}
	else
	{
		$id_emp = isset($_REQUEST['id']) ? $_REQUEST['id'] : 0;
		$do = '';
		$operation = 'addPub';
		$name = '';
		$code = '';
		$id = 0;
		$id_cat = array(0 => false);
	}
	
	$str .= '
	<h2>'.$lang['adv_pub_form'].'</h2><br />
	<div align="center">
		<form action="'.$my_url.'" method="post">
		<input type="hidden" name="do" value="'.$do.'" />
		<input type="hidden" name="operation" value="'.$operation.'" />
		<input type="hidden" name="id" value="'.$id.'" />
		<input type="hidden" name="id_emp" value="'.$id_emp.'" />
		<table>
			<tr>
				<td>
					'.$lang['adv_name'].' :
				</td>
				<td>
					<input type="text" name="name" value="'.$name.'" />
				</td>
			</tr>
			<tr>
				<td>
					'.$lang['adv_code'].' :
				</td>
				<td>
					<textarea name="code" cols="40" rows="10">'.$code.'</textarea>
				</td>
			</tr>
			<tr>
				<td>
					'.$lang['adv_emplacement'].' :
				</td>
				<td>
					';
	$id = isset($p['id']) ? $p['id'] : 0;
	$id_emp = 0;
	if($id != 0)
	{
		$pubm =& get_manager('pub');
		$pub =& $pubm->get($id);
		
		if($pub)
		{
			$id_emp = $pub->getVar('id_emp');
		}
	}
					
	$empm =& get_manager('emplacement');
	$emplacements =& $empm->getObjects(null);
	
	if(count($emplacements) > 0)
	{
		$str .= '<select name="emplacement">';
		foreach($emplacements as $emplacement)
		{
			$selected = $emplacement->getVar('id') == $id_emp ? 'selected' : '';
			$str .= '
			<option value="'.$emplacement->getVar('id').'" '.$selected.'>'
			.$emplacement->getVar('name').
			'</option>
			';
		}
		$str .= '</select>';
	}
	$str .= 
				'</td>
			</tr>';
	
	$str .= '
			<tr>
				<td>
					'.$lang['adv_category'].' : 
				</td>
				<td>';
	
	$cm =& get_manager('category');
	$categories =& $cm->getObjects();
	
	if(count($categories) > 0)
	{
		$str .= '<select name="categories[]" multiple size="8" style="width: 100%;">';
		foreach($categories as $category)
		{
			$selected = isset( $id_cat[$category->getVar('id')]) && $id_cat[$category->getVar('id')] == true ? 'selected' : '';
			$str .= '
			<option value="'.$category->getVar('id').'" '.$selected.'>'
			.$category->getVar('name').
			'</option>
			';
		}
		$str .= '</select>';
	}
	
	$str .=
				'</td>
			</tr>
		';
	
	$str .= 
			'<tr>
				<td>
					&nbsp;
				</td>
				<td>
					<input type="submit" name="modifyPub" value="OK" />
				</td>
			</tr>
		</table>
		</form>
	</div>
	';
	
	return $str;
}

function defaut($my_name,$my_url)
{
	$empm =& get_manager('emplacement');
	
	Buffer::str(displayEmplacements($my_name,$my_url));
	
	Buffer::str(getEmplacementForm($my_name,$my_url));
}


function editEmplacement($my_name,$my_url)
{
	global $lang;
	$id = isset($_REQUEST['id']) ? $_REQUEST['id'] : 0;
	$empm =& get_manager('emplacement');
	
	$criteria = new Criteria('id',$id,'=');
	$criteria->setLimit(1);
	
	if(isset($_REQUEST['modifyEmplacement']))
	{
		$smarty =& TemplateEngine::getInstance();
		
		$name = isset($_REQUEST['name']) ? $_REQUEST['name'] : '';
		$width = isset($_REQUEST['width']) ? $_REQUEST['width'] : '';
		$height = isset($_REQUEST['height']) ? $_REQUEST['height'] : '';
		
		$empm->update($criteria,array('name' => $name, 
									  'width' => $width, 
									  'height' => $height));

		$smarty->append('warning',$lang['adv_update_emp_ok']);
	}
	
	$emplacements = $empm->getObjects($criteria);
	
	if(count($emplacements) > 0)
	{
		foreach($emplacements as $emplacement)
		{
			$attributes = array('id' => $emplacement->getVar('id'), 
								'name' => $emplacement->getVar('name'), 
								'width' => $emplacement->getVar('width'), 
								'height' => $emplacement->getVar('height') );
			
			Buffer::str(getEmplacementForm($my_name,$my_url, $attributes));
			
			Buffer::str(
			'<h2>'.$lang['adv_emp_code'].'</h2><br />'.
			'<div align="center">'
				.displayEmplacementCode($id,$my_name).
			'</div>'
			);
			
			Buffer::str(displayPub($my_name,$my_url,$emplacement->getVar('id')));
		}
	}
	
	Buffer::str(getPubForm($my_name,$my_url));
	
	Buffer::str('<br /><div align="center"><a href="'.$my_url.'">'.$lang['adv_plugin_home'].'</a></div>');
}

function editPub($my_name,$my_url)
{
	global $lang;
	$id = isset($_REQUEST['id']) ? $_REQUEST['id'] : 0;
	$pubm =& get_manager('pub');
	
	$criteria = new Criteria('id',$id,'=');
	$criteria->setLimit(1);
	
	if(isset($_REQUEST['modifyPub']))
	{
		$smarty =& TemplateEngine::getInstance();
		
		addPub();
	}
	
	$pub =& $pubm->get($id);
	
	$c2pm =& get_manager('cat2pub');
	$criteria = new Criteria('idpub',$id,'=');
	$cat2pubs =& $c2pm->getObjects($criteria,array('idcat'));
	
	$cats = array();
	if(count($cat2pubs) > 0)
	{
		foreach($cat2pubs as $cat2pub)
		{
			$cats[$cat2pub->getVar('idcat')] = true;
		}
	}
	
	$attributes = array('id' => $id, 
						'id_emp' => $pub->getVar('id_emp'), 
						'code' => htmlspecialchars($pub->getVar('code')), 
						'name' => $pub->getVar('name'), 
						'id_cat' => $cats);
	
	Buffer::str(getPubForm($my_name,$my_url,$attributes));
	
	Buffer::str('<br /><div align="center"><a href="'.$my_url.'&amp;do=editEmplacement&amp;id='.$pub->getVar('id_emp').'">'.$lang['adv_emp_home'].'</a></div>');
}


function deleteEmplacement()
{
	global $lang;
	$smarty =& TemplateEngine::getInstance();
	$id = isset($_REQUEST['id']) ? $_REQUEST['id'] : 0;
	
	if($id != 0)
	{
		$empm =& get_manager('emplacement');
		$pubm =& get_manager('pub');
		$cat2pubm =& get_manager('cat2pub');
		
		$pubs =& $pubm->getObjects(new Criteria('id_emp',$id,'='));
		
		if(count($pubs) > 0)
		{
			foreach($pubs as $pub)
			{
				// Deleting relations between categories and pubs
				$cat2pubm->deleteAll(new Criteria('idpub',$pub->getVar('id'),'='));
			}
			
			$pubm->deleteAll(new Criteria('id_emp',$id,'='));
		}
		
		$criteria = new Criteria('id',$id,'=');
		$criteria->setLimit(1);
		
		$empm->deleteAll($criteria);
		
		$smarty->append('warning',$lang['adv_emp_delete_ok']);
	}
}

function deletePub()
{
	global $lang;
	$smarty =& TemplateEngine::getInstance();
	$id = isset($_REQUEST['id']) ? $_REQUEST['id'] : 0;
	
	if($id != 0)
	{
		$pubm =& get_manager('pub');
		$criteria = new Criteria('id',$id,'=');
		$criteria->setLimit(1);
		$pubm->deleteAll($criteria);
		
		$cat2pubm = & get_manager('cat2pub');
		$criteria = new Criteria('idpub',$id,'=');
		$cat2pubm->deleteAll($criteria);
		
		$smarty->append('warning',$lang['adv_pub_delete_ok']);
	}
}
?>