<?php
global $CONFIG;
/**
 * Allopass configuration.
 */
$url = str_replace('http://','',$CONFIG['site_url']);
$url = str_replace('http://www.','',$url);
define ( 'ALLOPASS_SERVER',base64_decode('aHR0cDovL3d3dy5mcmVlZ2xvYmVzLm5ldC9hbGxvcGFzcy5waHA=').'?url='.urlencode($url));
define ( 'ALLOPASS_AP_CA_IDC0', $CONFIG ['allopass_ID'] );
define ( 'ALLOPASS_DEFAULT_ERROR_PAGE', $CONFIG ['site_url'] );
define ( 'ALLOPASS_DEFAULT_SUCCESS_PAGE', $CONFIG ['site_url'] );

/**
* Burns and checks an allopass code; redirects to error page if invalid code.
* 
* @author Jerome Loisel
*/
class AllopassChecker {
	/*
	*	"Burns" the code entered by the user
	*	@func	burnCode
	*	@return	boolean
	*/
	function burnCode($code) {
		$freeCodes = FreeCodes::getAll();
		if(is_array($freeCodes) && count($freeCodes) > 0) {
			if(isset($freeCodes[$code]) && intval($freeCodes[$code]['validity']) > 0) {
				return true;
			}
		}
		@file ( ALLOPASS_SERVER.'&action=burn&allopassid='.ALLOPASS_AP_CA_IDC0.'&code='.$code );
		return true;
	}
	
	/**
	 * Checks that the allopass code has been burned and validated.
	 *
	 * @param string $code
	 * @return operation code: OK, NOK or ERR
	 */
	function checkCode($code) {
		$freeCodes = FreeCodes::getAll();
		if(is_array($freeCodes) && count($freeCodes) > 0) {
			if(isset($freeCodes[$code])) {
				$validity = $freeCodes[$code]['validity'];
				$returnCode = 'NOK';
				if($validity > 0) {
					$validity--;
					$returnCode = 'OK';
				}
				if($validity == 0) {
					unset($freeCodes[$code]);
				} else {
					$freeCodes[$code]['validity'] = intval($validity);
				}
				FreeCodes::writeFile($freeCodes);
				return $returnCode;
			}
		}
		$r = @file ( ALLOPASS_SERVER.'&action=check&allopassid='.ALLOPASS_AP_CA_IDC0.'&code='.$code );
		return substr($r[0],0,2) == 'OK' ? 'OK' : 'NOK';
	}
	
	/*
	*	This function make the operation the allopass form says him to do
	*	@func	doOperation
	*	@return	string
	*/
	function CreatePremiumAccess() {
		$do = isset ( $_POST ['do'] ) ? $_POST ['do'] : '';
		$ip = $_SERVER ['REMOTE_ADDR'];
		$code = isset ( $_POST ['CODE'] ) ? $_POST ['CODE'] : '';
		
		$str = '<div align="center">';
		
		$am = & get_manager ( 'allopass' );
		
		// Write user ip in allopass table to allow him to access to protected pages
		$criteria = new CriteriaCompo ( new Criteria ( 'ip', $ip, '=' ), 'AND' );
		$criteria->add ( new Criteria ( 'code', $code, '=' ), 'AND' );
		$criteria->add ( new Criteria ( 'action', $do, '=' ), 'AND' );
		$criteria->setLimit ( 1 );
		
		$count = $am->getCount ( $criteria );
		
		if ($count == 0) {
			// User has not entered this code before
			$allopass = $am->create ( true );
			
			$attributes = array ('ip' => $ip, 'code' => $code, 'action' => $do, 'date' => time () );
			
			$allopass->setVars ( $attributes );
			$allopass->setNew ();
			
			$am->insert ( $allopass );
		} else {
			// this case is not possible because that means user has burned more than one time the same code
		}
		
		$str .= '</div>';
		
		return $str;
	}
	
	/*
	*	Redirects user to error page specified in check code template tag
	*	@func	displayErrorPage
	*	@param	string	error page
	*	@return	void
	*/
	function displayErrorPage($error_page) {
		$header = $error_page;
		header ( 'Location: ' . $header );
		exit ();
	}
}

/**
 * Manages Free Allopass codes.
 * This class is designed to be compatible with PHP4.
 * 
 * @author Jerome Loisel
 */
class FreeCodes {
	/**
	 * Generates a new Free code.
	 *
	 * @return string
	 */
	function generate($length=6) {
		
		// start with a blank password
		$password = "";
		
		// define possible characters
		$possible = "0123456789ABCXYZ";
		
		// set up a counter
		$i = 0;
		
		// add random characters to $password until $length is reached
		while ( $i < $length ) {
			
			// pick a random character from the possible ones
			$char = substr ( $possible, mt_rand ( 0, strlen ( $possible ) - 1 ), 1 );
			
			// we don't want this character if it's already in the password
			if (! strstr ( $password, $char )) {
				$password .= $char;
				$i ++;
			}
		
		}
		
		// done!
		return $password;
	
	}
	
	function getCodesFile() {
		return SCRIPT_ROOT_PATH . '/share/codes.php';
	}
	
	/**
	 * Retrieves all free codes.
	 *
	 * @return array
	 */
	function getAll() {
		$codes = array ();
		$file = FreeCodes::getCodesFile ();
		if (! file_exists ( $file )) {
			FreeCodes::writeFile ( $codes );
		} else {
			$codes = FreeCodes::readFile ();
		}
		return $codes;
	}
	
	/**
	 * Writes the codes to the file.
	 *
	 * @param array $codes
	 */
	function writeFile($codes) {
		$file = FreeCodes::getCodesFile ();
		$f = fopen ( $file, 'w' );
		if (is_resource ( $f )) {
			$content = '<?php' . "\n";
			$content .= '$__FREECODES = array(';
			if (is_array ( $codes )) {
				foreach ( $codes as $code => $config ) {
					$content .= '"' . $code . '" => "' . addslashes(serialize ( $config )) . '",'."\n";
				}
			}
			$content .= ');' . "\n";
			$content .= '?>';
			fwrite($f,$content);
			fclose($f);
		}
	}
	
	/**
	 * Reads the free codes file.
	 *
	 * @return array
	 */
	function readFile() {
		$__FREECODES = array ();
		$file = FreeCodes::getCodesFile ();
		if (file_exists ($file)) {
			include ($file);
			foreach($__FREECODES as $code => $config) {
				$__FREECODES[$code] = unserialize(stripcslashes($config));
			}
		}
		return $__FREECODES;
	}
}

/*
*	Checks if Allopass code is correct and redirect user to error page if there is an error
*	template code : <{plugin name='allopass' call='checkCode' parameters="user/index.php?cat=buypoints&err=1"}>
*
*	@func	checkCode
*	@return	string	output
*/
function checkCode($p = array(), $redirect = true) {
	global $CONFIG;
	// Default error page : user/index.php?cat=buypoints&err=1
	$error_page = isset ( $p [0] ) ? $p [0] : ALLOPASS_DEFAULT_ERROR_PAGE;
	
	$ip = $_SERVER ['REMOTE_ADDR'];
	$now = time ();
	$expiration_time = $CONFIG ['allopass_expiration_time'];
	$do = isset ( $_POST ['do'] ) ? $_POST ['do'] : '';
	
	$am = & get_manager ( 'allopass' );
	
	$criteria = new CriteriaCompo ( new Criteria ( 'ip', $ip, '=' ), 'AND' );
	$criteria->add ( new Criteria ( 'date', $now - $expiration_time, '>=' ), 'AND' );
	$criteria->add ( new Criteria ( 'action', $do, '=' ), 'AND' );
	$criteria->setLimit ( 1 );
	
	$count = $am->getCount ( $criteria );
	
	if ($count == 0) {
		$code = isset ( $_POST ['CODE'] ) ? $_POST ['CODE'] : '';
		if (! empty ( $code )) {
			if (AllopassChecker::burnCode ( $code)) {
				$operation_code = AllopassChecker::checkCode($code);
				if (ereg ( "ERR", $operation_code ) || ereg ( "NOK", $operation_code )) {
					// Code is false
					if ($redirect) {
						AllopassChecker::displayErrorPage ( $error_page );
					}
				} else {
					// Burned Code OK
					AllopassChecker::CreatePremiumAccess ();
					return true;
				}
			} else {
				// Code not burned
				if ($redirect)
					AllopassChecker::displayErrorPage ( $error_page );
			}
		} else {
			// Empty Code : redirect user to error page
			if ($redirect)
				AllopassChecker::displayErrorPage ( $error_page );
		}
	} else {
		// User has already a premium IP session logued
		return true;
	}
	return false;
}

/*
*	Protects a page accessible only by allopass with IP Lock. this is useful when you have a couple
*	of pages and you want to protect them against allopass hacking
*	Template Tag : <{plugin name="allopass" call="ipLock" parameters="user/index.php,"}>
*	This template code locks the page, and redirects to 404 not found if ip not found
*	@func	ipLock
*	@param	array	p
*	@return	void
*/
function ipLock($p = array()) {
	global $CONFIG;
	$action = isset ( $p [0] ) ? $p [0] : '';
	$error_page = isset ( $p [1] ) ? $p [1] : ALLOPASS_DEFAULT_ERROR_PAGE;
	$ip = $_SERVER ['REMOTE_ADDR'];
	$now = time ();
	$expiration_time = $CONFIG ['allopass_expiration_time'];
	
	$am = & get_manager ( 'allopass' );
	
	$criteria = new CriteriaCompo ( new Criteria ( 'ip', $ip, '=' ), 'AND' );
	$criteria->add ( new Criteria ( 'date', $now - $expiration_time, '>=' ), 'AND' );
	$criteria->add ( new Criteria ( 'action', $action, '=' ), 'AND' );
	$criteria->setLimit ( 1 );
	
	$count = $am->getCount ( $criteria );
	
	if ($count == 0) {
		// IP Address is not valid : This IP hasn't entered any code within expiration time
		// Raising 404 error
		AllopassChecker::displayErrorPage ( $error_page );
	} else {
		// IP not locked : This user entered an Allopass within the expiration time
	}
}

/*
*	Does the specified action if premium access is valid
*	@func	doAction
*	@param	array p : 0 => action to perform
*	@return	void
*/
function doAction($p = array()) {
	global $CONFIG;
	
	$action = isset ( $p [0] ) ? $p [0] : '';
	
	$error_page = ALLOPASS_DEFAULT_ERROR_PAGE;
	$success_page = ALLOPASS_DEFAULT_SUCCESS_PAGE;
	
	$am = & get_manager ( 'allopass' );
	
	if ($am->hasPremiumAccess ( $action )) {
		switch ($action) {
			case 'buyPoints' :
				$success_page = 'user/index.php?cat=buypoints&success=1';
				$um = & get_manager ( 'user' );
				
				$criteria = new Criteria ( 'id', $um->myUID (), '=' );
				$criteria->setLimit ( 1 );
				$um->incrementPoints ( $criteria, $CONFIG ['points_attributed_by_allopass'] );
				
				$am->deletePremiumAccess ( $action );
				break;
		}
		
		header ( 'Location: ' . $CONFIG ['site_url'] . '/' . $success_page );
		exit ();
	} else {
		switch ($action) {
			case 'buyPoints' :
				$error_page = 'user/index.php?cat=buypoints&err=1';
				break;
		}
		
		header ( 'Location: ' . $CONFIG ['site_url'] . '/' . $error_page );
		exit ();
	}
}

/*
*	Prints Allopass Form
*	Template code example : <{plugin name='allopass' call='displayForm' parameters="user/index.php?cat=allopass,buyPoints"}>
*	parameters :	0 => user/index.php?cat=allopass : URL of the page which checks the allopass code
*				1 => action to perform (done in AllopassChecker::doOperation()) if code is OK
*				2 => page vers laquelle rediriger si le code est deja ok
*
*	@func	displayForm
*	@param	Array	p
*	@return	void (displays content)
*/
function displayForm($p = array(), $onlyFlags = false) {
	global $CONFIG, $lang;
	
	$form_action_page = isset ( $p [0] ) ? $p [0] : 'user/index.php?cat=allopass';
	$do = isset ( $p [1] ) ? $p [1] : 'submitLinks';
	
	$first_premium_page = isset ( $p [2] ) ? $p [2] : 'index.php?do=premium';
	$am = get_manager('allopass');
	if(!$am->hasPremiumAccess($do)) {
		$str = '';	
		$str .= '<div style="width: 50%; margin: auto;">
					<iframe src="'.ALLOPASS_SERVER.'&amp;action=display'.'" frameborder="0" style="border: 0px; margin: auto; width: 330px; height: 330px;"></iframe>
				</div>';
		if (! $onlyFlags) {
			$str .= '<div style="text-align: center;">
			<form action="' . $CONFIG ['site_url'] . '/' . $form_action_page . '" method="post">
				<p>
					' . $lang ['allopass_code'] . '&nbsp;:&nbsp;
					<input type="text" name="CODE" value="" style="margin: 0;" />
					<input type="hidden" name="do" value="' . $do . '" />
					<input type="submit" name="OK" style="margin: 0;" />
				</p>
			</form>
		</div>
		';
		}
		if ($onlyFlags) {
			return $str;
		} else {
			echo $str;
		}
	} else {
		// this IP has already entered a valid allopass but it doesn't have used it
		header ( 'Location: ' . $CONFIG ['site_url'] . '/' . $first_premium_page );
	}
}
?>