<?php

$my_name = 'commentmng';
$my_url = 'index.php?cat=plugins&amp;p='.$my_name;

function updateCommentConfig()
{
	global $lang;
	$smarty =& TemplateEngine::getInstance();
	$use_comments = isset($_POST['use_comments']) ? $_POST['use_comments'] : 0;
	$auto_approve_comments = isset($_POST['auto_approve_comments']) ? $_POST['auto_approve_comments'] : 0;
	$cm =& MyConfigManager::getInstance();
	
	$cm->setVar('use_comments',$use_comments);
	$cm->setVar('auto_approve_comments',$auto_approve_comments);
	
	$cm->updateConfig();
	
	$smarty->append('warning',$lang['commentmng_configupdated']);
}

function displayComments($my_url, $approved = 1)
{
	global $CONFIG,$lang;
	$start = isset($_GET['start']) ? $_GET['start'] : 0;
	$limit = 20;
	
	$cm =& get_manager('comment');
	$lm =& get_manager('link');
	$um =& get_manager('user');
	
	$criteria = new Criteria('approved',$approved,'=');
	$criteria->setOrder('DESC');
	$criteria->setSort('date');
	$criteria->setStart($start);
	$criteria->setLimit($limit);
	
	$comments =& $cm->getObjects($criteria);
	
	if(count($comments) > 0)
	{
		Buffer::str("<table cellpadding='3' width='100%'>");
		
		Buffer::str("<tr bgcolor='#F0F0F0'>");
		Buffer::str("<th>&nbsp;</th>");
		Buffer::str("<th>&nbsp;</th>");
		Buffer::str("<th>#</th>");
		Buffer::str("<th>Site</th>");
		Buffer::str("<th>Date</th>");
		Buffer::str("<th>User</th>");
		Buffer::str("<th>Message</th>");
		Buffer::str("</tr>");
		
		$i = 0;
		$delete = $CONFIG['site_url'].'/themes/admin/images/delete.png';
		
		foreach($comments as $comment)
		{
			$color = $i == 0 ? "#F0F0F0" : "#FFFFFF";
			$i = $i == 1 ? 0 : 1;
			
			$link =& $lm->get($comment->getVar('lid'));
			
			$username = '';
			if($comment->getVar('uid') != 0)
			{
				$user =& $um->get($comment->getVar('uid'));
				$username = $user->getVar('login');
			}
			else
			{
				$username = $lang['commentmng_anonym'];
			}
			
			$approved = $comment->getVar('approved');
			$state = $approved == 1 ? 'check_on.png' : 'check_off.png';
			$state = $CONFIG['site_url'].'/themes/admin/images/'.$state;
			
			Buffer::str("<tr bgcolor='".$color."'>");
			Buffer::str('<td style="text-align: center;">');
			Buffer::str('<a href="'.$my_url.'&amp;do=switchstate&amp;id='.$comment->getVar('id').'"><img src="'.$state.'" alt="" border="0"/></a>');
			Buffer::str('</td>');
			Buffer::str('<td style="text-align: center;">');
			Buffer::str('<a href="'.$my_url.'&amp;do=deletecomment&amp;id='.$comment->getVar('id').'"><img src="'.$delete.'" alt="" border="0"/></a>');
			Buffer::str('</td>');
			Buffer::str('<td style="text-align: center;">');
			Buffer::str($comment->getVar('id'));
			Buffer::str('</td>');
			Buffer::str('<td style="text-align: center;">');
			$name = strlen($link->getVar('name')) > 15 ? substr($link->getVar('name'),0,15).'...' : $link->getVar('name');
			Buffer::str('<a href="'.$CONFIG['site_url'].'/single.php?id='.$comment->getVar('lid').'" target="_blank">'.$name.'</a>');
			Buffer::str('</td>');
			Buffer::str('<td style="text-align: center;">');
			Buffer::str($comment->getVar('date'));
			Buffer::str('</td>');
			Buffer::str('<td style="text-align: center;">');
			Buffer::str(substr($username,0,20));
			Buffer::str('</td>');
			Buffer::str('<td>');
			Buffer::str(substr($comment->getVar('message'),0,150));
			Buffer::str('</td>');
			Buffer::str('</tr>');
		}
		
		Buffer::str("</table>");
	}
	
	$comment_count = $cm->getCount();
	
	if($comment_count > $limit)
	{
		Buffer::str('<div align="center">');
		$nb_pages = ceil($comment_count / $limit);
		for ($i=0; $i<$nb_pages; $i++)
		{
			$start = $i*$limit;
			Buffer::str('<a href="'.$my_url.'&amp;start='.$start.'">'.$i.'</a>');
		}
		Buffer::str('</div>');
	}
}

function defaut($my_url)
{
	global $CONFIG, $lang;
	Buffer::str('<h2>'.$lang['commentmng_commentconfig'].'</h2><br />');
	
	$i = $CONFIG['use_comments'] == 1 ? 0 : 1;
	$j = $i == 0 ? 1 : 0;
	$checked = array($i => 'checked="checked"', $j => '');
	
	$i = $CONFIG['auto_approve_comments'] == 1 ? 0 : 1;
	$j = $i == 0 ? 1 : 0;
	$checked2 = array($i => 'checked="checked"', $j => '');
	
	Buffer::str('<div align="center">
					<form action="'.$my_url.'" method="post">
						<table cellpadding="3">
							<tr>
								<td>
									'.$lang['commentmng_usecomments'].' :&nbsp; 
								</td>
								<td>
									'.$lang['yes'].'&nbsp;<input type="radio" name="use_comments" value="1" '.$checked[0].' style="margin:0" />
									'.$lang['no'].'&nbsp;<input type="radio" name="use_comments" value="0" '.$checked[1].' style="margin:0" />
								</td>
						</tr>
						<tr>
							<td>
								'.$lang['commentmng_autoapprove'].' :&nbsp;
							</td>
						<td>
						'.$lang['yes'].'&nbsp;<input type="radio" name="auto_approve_comments" value="1" '.$checked2[0].' style="margin:0" />
						'.$lang['no'].'&nbsp;<input type="radio" name="auto_approve_comments" value="0" '.$checked2[1].' style="margin:0" />
						</td>
						</tr>
						<tr>
							<td align="right" colspan="2">
								<input type="hidden" name="do" value="updateconfig" />
								<input type="submit" value="OK" />
							</td>
						</tr>
						</table>
					</form>
				</div>');
				
	Buffer::str('<h2>'.$lang['commentmng_notapproved_comments'].'</h2>');
	
	displayComments($my_url,0);
	
	Buffer::str('<h2>'.$lang['commentmng_approved_comments'].'</h2>');
	displayComments($my_url,1);
}

function deleteComment()
{
	$id = isset($_GET['id']) ? $_GET['id'] : 0;
	$cm =& get_manager('comment');
	
	if($id != 0)
	{
		$criteria = new Criteria('id',$id,'=');
		$criteria->setLimit(1);
		$cm->deleteAll($criteria);
	}
}

function switchCommentState()
{
	$id = isset($_GET['id']) ? $_GET['id'] : 0;
	$cm =& get_manager('comment');
	
	$comment =& $cm->get($id);
	
	if($comment)
	{
		$approved = $comment->getVar('approved') == 1 ? 0 : 1;
		$comment->setVar('approved',$approved);
		$comment->unsetNew();
		
		$cm->insert($comment);
	}
}

$do = isset($_REQUEST['do']) ? $_REQUEST['do'] : '';

switch($do)
{
	case 'switchstate':
		switchCommentState();
		break;
		
	case 'deletecomment':
		deleteComment();
		break;
	
	case 'updateconfig':
		updateCommentConfig();
		break;
}

defaut($my_url);
?>