<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2004 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

$id = $_REQUEST['id'];

$strReq = 'SELECT link_id, label, href, title, lang, rel '.
		'FROM '.$dirroll->table.' '.
		'WHERE link_id = '.$id; 
$rs = $con->select($strReq);

$l_label = $rs->f('label');
$l_href = $rs->f('href');
$l_title = $rs->f('title');
$l_lang = $rs->f('lang');
$l_rel = $rs->f('rel');

if (!$rs->isEmpty() && $action == 'edit_link')
{
	$l_label = trim($_POST['l_label']);
	$l_title = trim($_POST['l_title']);
	$l_href = trim($_POST['l_href']);
	$l_lang = trim($_POST['l_lang']);
	
	if (!$l_label || !$l_href)
	{
		$err = $lang['dirroll_label_n_url_required'];
	}
	else
	{

		$rel = '';
		
		if (isSet($_POST['identity']))
			$rel .= $_POST['identity'];

		else {
			if(isSet($_POST['friendship']))		$rel .= ' '.$_POST['friendship'];
			if(isSet($_POST['physical']))		$rel .= ' met';
			if(isSet($_POST['professional']))	$rel .= ' '.implode(' ',$_POST['professional']);
			if(isSet($_POST['geographical']))	$rel .= ' '.$_POST['geographical'];
			if(isSet($_POST['family']))			$rel .= ' '.$_POST['family'];
		}

		if ($dirroll->updLink($id,$l_label,$l_href,$l_title,$l_lang, $rel) == false) {
			$err = $dirroll->con->error();
		} else {
			header('Location: '.$url);
			exit;
		}
	}
}


Buffer::str('<h2>'.$lang['dirroll_editlink'].'</h2><br />');

if ($err != '') {
	Buffer::str(
	'<div class="erreur"><p><strong>'.$lang['dirroll_errors'].' :</strong></p>'.
	'<p>'.$err.'</p>'.
	'</div>'
	);
}

if ($rs->isEmpty())
{
	Buffer::str('<p>'.$lang['dirroll_nolink'].'</p>');
}
else
{

	Buffer::str(
	'<form action="'.$url.'" method="post">'.
	'<fieldset><legend>'.$lang['dirroll_editlink'].'</legend>'.
	'<p class="field"><strong>'.
	'<label for="l_label" class="float">'.$lang['dirroll_label'].' : </label></strong>'.
	form::field('l_label',40,255,htmlspecialchars($l_label)).'</p>'.
	
	'<p class="field"><strong>'.
	'<label for="l_href" class="float">'.$lang['dirroll_url'].' : </label></strong>'.
	form::field('l_href',40,255,htmlspecialchars($l_href)).'</p>'.
	
	'<p class="field">'.
	'<label for="l_title" class="float">'.$lang['dirroll_description'].' ('.$lang['dirroll_optional'].') : </label>'.
	form::field('l_title',40,255,htmlspecialchars($l_title)).'</p>'.
	
	'<p class="field">'.
	'<label for="l_lang" class="float">'.$lang['dirroll_language'].' ('.$lang['dirroll_optional'].') : </label>'.
	form::field('l_lang',2,2,htmlspecialchars($l_lang)) . '</p>'.
	
	'<p>'.form::hidden('do','edit_link').
	form::hidden('page','edit_link').
	form::hidden('id',$id).
	'<input type="submit" class="submit" value="'.$lang['dirroll_save'].'"/></p>'.
	'</fieldset>'.

	'<br /><fieldset><legend>'.$lang['dirroll_otherinfos'].'</legend>'.

	'<p class="field">'.
	'<label class="float">'.$lang['dirroll_me'].'</label>'.
	form::checkbox('identity', 'me', ($l_rel == 'me')).$lang['dirroll_justforme'].'</p>'.
	
	'<p class="field">'.
	'<label class="float">'.$lang['dirroll_friendship'].'</label>'.
	form::radio('friendship', 'contact', (strpos($l_rel, 'contact'))).$lang['dirroll_contact'].
	form::radio('friendship', 'acquaintance', (strpos($l_rel, 'acquaintance'))).$lang['dirroll_acquaintance'].
	form::radio('friendship', 'friend', (strpos($l_rel, 'friend'))).$lang['dirroll_friend'].
	form::radio('friendship', '').$lang['dirroll_none'].
	'</p>'.

	'<p class="field">'.
	'<label class="float">'.$lang['dirroll_meeting'].'</label>'.
	form::checkbox('physical', 'met', (strpos($l_rel, 'met'))).$lang['dirroll_met'].
	'</p>'.

	'<p class="field">'.
	'<label class="float">'.$lang['dirroll_professional'].'</label>'.
	form::checkbox('professional[1]', 'co-worker', (strpos($l_rel, 'co-worker'))).$lang['dirroll_coworker'].
	form::checkbox('professional[2]', 'colleague', (strpos($l_rel, 'colleague'))).$lang['dirroll_colleague'].
	'</p>'.

	'<p class="field">'.
	'<label class="float">'.$lang['dirroll_geographical'].'</label>'.
	form::radio('geographical', 'co-resident', (strpos($l_rel, 'co-resident'))).$lang['dirroll_coresident'].
	form::radio('geographical', 'neighbor', (strpos($l_rel, 'neighbor'))).$lang['dirroll_neighbor'].
	form::radio('geographical', '').$lang['dirroll_none'].
	'</p>'.

	'<p class="field">'.
	'<label class="float">'.$lang['dirroll_family'].'</label>'.
	form::radio('family', 'child', (strpos($l_rel, 'child'))).$lang['dirroll_child'].
	form::radio('family', 'parent', (strpos($l_rel, 'parent'))).$lang['dirroll_parent'].
	form::radio('family', '').$lang['dirroll_none'].
	'</p>'.

	'</form>'
	);
}

?>
