<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2004-2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****
$my_name = 'mysql';
$url = 'index.php?cat=plugins&amp;p='.$my_name;

$img_check = $CONFIG['site_url'].'/themes/admin/images/check_%s.png';

$optimize = (!empty($_GET['optimize'])) ? $_GET['optimize'] : '';
$backup = (!empty($_POST['backup'])) ? $_POST['backup'] : '';
$restore = (!empty($_POST['restore'])) ? $_POST['restore'] : '';


// Optimisation des tables
if ($optimize == 1)
{
	Buffer::str('<h2>'.$lang['mysql_optimization'].'</h2>');
	
	$dir =& MyDirectory::getInstance();
	
	if ($dir->optimize() !== false) {
		Buffer::str(
		'<p><img src="'.sprintf($img_check,'on').'" alt="ok" /> '.
		$lang['mysql_opti_ok'].'</p>'
		);
	} else {
		Buffer::str(
		'<p><img src="'.sprintf($img_check,'off').'" alt="ok" /> '.
		$lang['mysql_err_optitable'].'</p>'
		);
	}

	Buffer::str('<p><a href="index.php?cat=plugins&amp;p='.$my_name.'">'.$lang['mysql_back_tools'].'</a></p>');
}
// Sauvegarde des tables
elseif ($backup == 1)
{
	include_once(dirname(__FILE__).'/libs/lib.mysqldump.php');

	$send_it = isset($_POST['sendit'])?true:false;
	$res = dbdump::saveDump($send_it);

	Buffer::str('<h2>'.$lang['mysql_backup'].'</h2>');
	if ($res !== false) {
		Buffer::str(
			'<p><img src="'.sprintf($img_check,'on').'" alt="ok" /> '.
			$lang['mysql_tables_saved'].'</p>'.
			'<p>'. $lang['mysql_gzip_file_location_here'] .
			' : <a href="'.$CONFIG['site_url'].'/share/mysql/'.$res.'">'.$res.'</a></p>'.
			'<p>'.$lang['mysql_backup_ok'].'</p>'
		);
	} else {
		Buffer::str(
			'<p><img src="'.sprintf($img_check,'off').'" alt="ok" /> '.
			$lang['mysql_err_backup'].'</p>'.
			'<p>'.$lang['mysql_backup_ok'].'</p>'
		);
	}
	Buffer::str(
		'<p><a href="index.php?cat=plugins">'.$lang['mysql_back_tools'].'</a></p>'
	);
}
// Restauration des tables
elseif ($restore == 1)
{
	include_once(dirname(__FILE__).'/libs/lib.mysqldump.php');

	Buffer::str('<h2>'.$lang['mysql_restore'].'</h2>');

	if (isset($_FILES['dumpfile']) && $_FILES['dumpfile']['error'] == 0) {
		if (is_uploaded_file($_FILES['dumpfile']['tmp_name'])) {
			$tmp_file = SHARE_DIR.'/mysql/dump.tmp';
			if (!move_uploaded_file($_FILES['dumpfile']['tmp_name'],$tmp_file)) {
				return(false);
			}
			$src_file = $tmp_file;
		}
		switch($_FILES['dumpfile']['type']) {
			case '' :
			case 'application/octet-stream' :
				if ($fh = fopen($src_file, "rb")) {
					$Buffer = fread($fh, 3);
					fclose($fh);
					$compressed = ($Buffer[0] == chr(31) && $Buffer[1] == chr(139))?true:false;
				} else {
					$error = $lang['mysql_read_upload_file_ko'];
					@unlink($src_file);
				}
				break;
			case 'application/x-gzip':
			case 'application/x-gzip-compressed':
				$compressed = true;
				break;
			case 'text/plain':
				$compressed = false;
				break;
			default :
				$error =  $lang['mysql_wrong_file_format'];
				@unlink($src_file);
				break;
		}
	} else {
		$error = $lang['mysql_error_upl_dump'];
	}
	if (isset($compressed)) {
		if (($res = dbdump::restoreDump($src_file, $compressed)) !== false) {
			Buffer::str(
				'<p>'.$lang['mysql_restore_ok'].'</p>'
			);
		} else {
			$error = $lang['mysql_restore_ko'];
		}
	}
	if (!empty($error)) {
		Buffer::str(
			'<div class="erreur"><p>'.$error.'</p></div>'.
			'<p>'.$lang['mysql_restore_ko2'].'</p>'
		);
	}
	Buffer::str(
		'<p><a href="'.$url.'">'.$lang['mysql_back_menu'].'</a></p>'
	);
}
else
{
	include_once(dirname(__FILE__).'/libs/lib.installer.php');

	Buffer::str(
	'<h1>'.$lang['mysql_sql_operations'].'</h1>');

	// Vrification de la prsence d'un rpertoire ddi dans share (pour dump)
	if (($err = installer::checkPluginShareDir($my_name))) {
		Buffer::str(
		'<div class="erreur"><p><strong>'.
		__('Unavailable mysql/ directory in share/. You may create it manually.').
		'</strong></p>'.
		'</div>'
		);
	} 

	// Optimisation
	Buffer::str(
	'<h2>'.$lang['mysql_optimization'].'</h2>'.
	'<p>'.$lang['mysql_optimization_help'].'</p>'.
	'<p><strong>'.$lang['mysql_important'].'</strong>&nbsp;: '.
	$lang['mysql_notice_opti'].'</p>'.
	'<p><a href="'.$url.'&amp;optimize=1">'.$lang['mysql_optimise_db'].'</a></p>'
	);

	// Sauvegarde
	Buffer::str(
	'<h2>'.$lang['mysql_backup_title'].'</h2>'.
	'<p>'.$lang['mysql_backup_help'].
	'</p>'.
	'<p><strong>'.$lang['mysql_important'].'</strong>&nbsp;: '.
	$lang['mysql_backup_help2'].'</p>'.
	'<form method="post" action="'.$url.'">'.
	'<fieldset>'.
	'<p class="field"><label class="float" for="sendit">'.$lang['mysql_dl_now'].'</label>'.
	'<input type="checkbox" name="sendit" id="sendit" value="1" checked="checked" /></p>'.
	'<p class="field"><input type="hidden" name="backup" value="1"/>'.
	'<input type="submit" class="submit" value="'.$lang['mysql_backup'].'"/></p>'.
	'</fieldset>'.
	'</form>'
	);

	// Restauration
	Buffer::str(
	'<h2>'.$lang['mysql_restore'].'</h2>'.
	'<p>'.$lang['mysql_restore_help'].'</p>'.
	'<p>'.$lang['mysql_restore_help2'].'</p>'.
	'<p><strong>'.$lang['mysql_important'].'</strong>&nbsp;: '.
	$lang['mysql_notice_opti'].'</p>'.
	'<p class="erreur"><strong>'.
	$lang['mysql_restore_help3'].
	'<br />'.
	$lang['mysql_restore_help4'].
	$lang['mysql_restore_help5'].
	'<br />'.
	$lang['mysql_restore_help6'].
	'</strong></p>'.
	'<form method="post" action="'.$url.'" enctype="multipart/form-data">'.
	'<fieldset>'.
	'<p class="field"><label class="float" for="dumpfile">'.$lang['mysql_dump_to_restore'].'</label>&nbsp;'.
	'<input type="file" name="dumpfile" id="dumpfile"/></p>'.
	'<p class="field"><input type="hidden" name="restore" value="1"/>'.
	'<input type="submit" class="submit" value="'.$lang['mysql_restore'].'"/></p>'.
	'</fieldset>'.
	'</form>'
	);
}
?>
