<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2004 Geoffrey Bachelet and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****
#
# Contributors :
# - Olivier Meunier
#

require dirname(__FILE__).'/lib.php';

$err = '';
$tool_url = 'index.php?cat=plugins&p=packager';

# Liste des thmes
$themes_root = SCRIPT_ROOT_PATH.'/themes';
$themes = new plugins($themes_root,'theme');
$themes->getPlugins(false);
$themes_list = $themes->getPluginsList();

$plugins_root = dirname(__FILE__).'/..';
$plugins = new plugins($plugins_root);
$plugins->getPlugins(false);
$plugins_list = $plugins->getPLuginsList();

# Prparation des tableaux pour les combo
$t_list = $p_list = array();

foreach($themes_list as $k => $v) {
	$t_list[$v['label'].' - version '.$v['version']] = $k;
}
foreach($plugins_list as $k => $v) {
	$p_list[$v['label'].' - version '.$v['version']] = $k;
}


# Tlchargement ou sauvegarde d'un plugin
if (!empty($_POST['p_plugin']))
{
	$fname = 'plugin-'.$_POST['p_plugin'];
	if (!empty($plugins_list[$_POST['p_plugin']]['version'])) {
		$fname .= '-'.$plugins_list[$_POST['p_plugin']]['version'];
	}
	
	$arc = (isset($_POST['p_arc']))? true : false;
	dcPackager::packIt(
			$_POST['p_plugin'],
			$plugins_root,
			$fname,
			(!empty($_POST['p_save']) && is_writable(SHARE_DIR)),
			$tool_url.'&p_ok=1',
			$lang['packager_packager_errorcreating'],
			$err,
			$arc);
}


# Tlchargement ou sauvegarde d'un theme
if (!empty($_POST['p_theme']))
{
	$fname = 'theme-'.$_POST['p_theme'];
	if (!empty($themes_list[$_POST['p_theme']]['version'])) {
		$fname .= '-'.$themes_list[$_POST['p_theme']]['version'];
	}
	
	$arc = (isset($_POST['p_arc']))?true:false;
	dcPackager::packIt(
			$_POST['p_theme'],
			$themes_root,
			$fname,
			(!empty($_POST['p_save']) && is_writable(SHARE_DIR)),
			$tool_url.'&t_ok=1',
			$lang['packager_packager_errorcreatingtheme'],
			$err,
			$arc);
}


/* Affichage
-------------------------------------------------------- */
Buffer::str('<h2>'.$lang['packager_packager_name'].'</h2><br />');

if ($err != '') {
	Buffer::str('<div class="erreur"><p><strong>'.$lang['packager_packager_errors'].' :</strong></p>'.$err.'</div>');
}

if (!empty($_GET['p_ok'])) {
	Buffer::str('<p class="message">'.$lang['packager_packager_pluginsaved'].'</p>');
}

if (!empty($_GET['t_ok'])) {
	Buffer::str('<p class="message">'.$lang['packager_packager_themesaved'].'</p>');
}

Buffer::str(
'<form action="'.htmlentities($tool_url).'" method="post">'.
'<fieldset class="clear"><legend>'.$lang['packager_packager_packageplugin'].'</legend>'.
'<p class="field"><label class="float" for="p_plugin">'.$lang['packager_packager_name'].' :</label>'.form::combo('p_plugin',$p_list).'</p>');

if (is_writable(SHARE_DIR)) {
	Buffer::str('<p class="field"><label class="float" for="p_arc">'.$lang['packager_packager_createtgz'].' :</label>');
	Buffer::str(form::checkbox('p_arc',1,"yes"));
	Buffer::str('</p>');
}

Buffer::str('<p><input class="submit" type="submit" name="p_dl" value="'.$lang['packager_packager_dlthisplugin'].'" />');

if (is_writable(SHARE_DIR)) {
	Buffer::str(' <input class="submit" type="submit" name="p_save" value="'.$lang['packager_packager_saveinsharefolder'].'" /></p>');
}

Buffer::str('</fieldset></form><br />');

Buffer::str('<form action="'.htmlentities($tool_url).'" method="post">'.
'<fieldset class="clear"><legend>'.$lang['packager_packager_packtheme'].'</legend>'.
'<p class="field"><label class="float" for="p_theme">'.$lang['packager_packager_themename'].' :</label>'.
form::combo('p_theme',$t_list).'</p>');

if (is_writable(SHARE_DIR)) {
	Buffer::str('<p class="field"><label class="float" for="p_arc">'.$lang['packager_packager_createtgz'].' :</label>');
	Buffer::str(form::checkbox('p_arc',1,"yes"));
	Buffer::str('</p>');
}

Buffer::str('<p><input class="submit" type="submit" name="p_dl" value="'.$lang['packager_packager_dltheme'].'" />');

if (is_writable(SHARE_DIR)) {
	Buffer::str(' <input class="submit" type="submit" name="p_save" value="'.$lang['packager_packager_savethemesharefolder'].'" /></p>');
}

Buffer::str('</fieldset></form>');
?>