<?php

require_once(SCRIPT_ROOT_PATH.'/class/class.rewriteengine.php');

$my_name = 'rewritemng';
$url = 'index.php?cat=plugins&amp;p='.$my_name;

function rwmng_enableRewrite()
{
	global $lang;
	$smarty =& TemplateEngine::getInstance();
	$re =& MyRewriteEngine::getInstance();
	$cm =& MyConfigManager::getInstance();
	$cm->setVar('url_rewriting',1);
	
	$message = ($re->writeHtaccess() && $cm->updateConfig()) == true ? $lang['rwmng_htaccess_write_ok'] : $lang['rwmng_htaccess_write_ko'];
	$smarty->append('warning', $message);
}

function rwmng_disableRewrite()
{
	global $lang;
	$smarty =& TemplateEngine::getInstance();
	$re =& MyRewriteEngine::getInstance();
	$cm =& MyConfigManager::getInstance();
	$cm->setVar('url_rewriting',0);
	
	$re->htaccess = '';
	
	$message = ($re->writeHtaccess() && $cm->updateConfig()) == true ? $lang['rwmng_htaccess_clear_ok'] : $lang['rwmng_htaccess_clear_ko'];
	$smarty->append('warning', $message);
}

function rwmng_defaut($url)
{
	global $CONFIG, $lang;
	$my_name = 'rewritemng';
	$img_check = '<img src="'.$CONFIG['site_url'].'/plugins/'.$my_name.'/images/check_%s.png" alt="" />';
	$image = $CONFIG['url_rewriting'] == 1 ? 'check_on.png' : 'check_off.png';
	$action = $CONFIG['url_rewriting'] == 1 ? $lang['rwmng_disable'] : $lang['rwmng_enable'];
	$do = $CONFIG['url_rewriting'] == 1 ? 'disable' : 'enable';
	
	Buffer::str('<h2>'.$lang['rwmng_rewritemng_infos_title'].'</h2>');
	Buffer::str('<p>'.$lang['rwmng_rewritemng_infos'].'</p>');
	
	if (is_writable(SCRIPT_ROOT_PATH.'/.htaccess'))
	{
		Buffer::str(
		'<p>'.sprintf($img_check,'on').' '.
		sprintf($lang['rwmng_fileiswritable'],'/.htaccess').
		'</p>')	;
		
		Buffer::str('<h2>'.$lang['rwmng_rewritemng'].'</h2>');
		Buffer::str('<table width="100%">');
		Buffer::str("<tr bgcolor='#F3F3F3'>");
		Buffer::str('<td width="10" valign="top">');
		Buffer::str('<img src="'.$CONFIG['site_url'].'/themes/admin/images/'.$image.'" border="0" alt="" />');
		Buffer::str('</td>');
		Buffer::str('<td>');
		Buffer::str($lang['rwmng_url_rewrite']);
		Buffer::str('</td>');
		Buffer::str('<td valign="top" align="right">');
		Buffer::str('<a href="'.$url.'&amp;do='.$do.'" title="'.$action.'">'.$action.'</a>');
		Buffer::str('</td>');
		Buffer::str('</tr>');
		Buffer::str('</table>');
	}
	else
	{
		Buffer::str(
		'<p>'.sprintf($img_check,'wrn').' '.
		sprintf($lang['rwmng_fileisnotwritable'],'/.htaccess').
		'</p>');
		Buffer::str('<p>'.$lang['rwmng_correct_errors'].'</p>');
	}
}


$do = isset($_GET['do']) ? $_GET['do'] : '';

switch($do)
{
	case 'enable':
		rwmng_enableRewrite();
		break;
	
	case 'disable':
		rwmng_disableRewrite();
		break;
}

rwmng_defaut($url);
?>