<?php

require_once dirname(__FILE__).'/config.php';

$smarty =& TemplateEngine::getInstance();

function readConditionFile()
{
	$filename = SUBCOND_FILE;
	$file_contents = '';
	$handle = fopen($filename, "r");
	$size = filesize($filename);
	if($size > 0)
	{
		$file_contents = fread($handle, $size);
	}
	return $file_contents;
}

function getWYSIWYGEditor()
{
	$conditions = readConditionFile();
	$fckeditor =& MyWYSIWYGEditor::getInstance();
	$fckeditor->Value = $conditions;
	$fckeditor->ToolbarSet = 'Default';
	$fckeditor->Width = '450';
	$fckeditor->Height = '350';
	$fckeditor->InstanceName = 'conditions';
	return $fckeditor->CreateHtml();
}

function checknCreateTxtFile($my_name)
{
	global $lang;
	$filename = SUBCOND_FILE;
	$smarty =& TemplateEngine::getInstance();

	# Si le fichier existe pas, le cr�er avec des textes par d�faut
	if (!file_exists($filename))
	{
		if (!file_exists(dirname($filename)))
		{
			mkdir(dirname($filename));
		}
		$handle = fopen($filename, 'w');
		$ok = fwrite($handle, '');
		fclose($handle);

		#.htaccess
		$htaccess = SHARE_DIR."/".$my_name."/.htaccess";
		$handle = fopen($htaccess, 'w');
		$okh = fwrite($handle, "deny from all");
		fclose($handle);

		if (!$ok)
		{
			$smarty->append('warning',$lang['subcond_cannot_create_file']);
		}
	}
}

function defaut($my_name,$my_url)
{
	global $lang;
	$code_for_template = "<tt><big>&lt;{plugin name='".$my_name."' call='displayConditions'}&gt;</big></tt>";

	checknCreateTxtFile($my_name);

	Buffer::str('<h2>'.$lang['subcond_label'].'</h2>');

	Buffer::str('<br />');

	Buffer::str('<div align="center">');

	Buffer::str("<form action='".$my_url."' method='post'>");
	Buffer::str(getWYSIWYGEditor());
	Buffer::str('<input type="hidden" name="do" value="updateConditions" />');
	Buffer::str('<input type="submit" value="OK" />');
	Buffer::str('</form>');

	Buffer::str('</div>');

	Buffer::str('<h2>'.$lang['subcond_template_code'].'</h2><br />');
	Buffer::str('<div align="center">'.$code_for_template.'</div>');
}

function writeConditions($my_name, $my_url)
{
	global $lang;

	$smarty =& TemplateEngine::getInstance();
	$myts =& MyTextSanitizer::getInstance();
	# �crire le fichier
	$handle = fopen(SUBCOND_FILE, 'w');
	$conditions = isset($_POST['conditions']) ? $myts->stripSlashesGPC($_POST['conditions']) : '';
	$ok = fwrite($handle, $conditions);
	fclose($handle);

	#.htaccess
	$htaccess = SHARE_DIR."/".$my_name."/.htaccess";
	$handle = fopen($htaccess, 'w');
	$okh = fwrite($handle, "deny from all");
	fclose($handle);

	if ($ok)
	{
		$smarty->append('warning',$lang['subcond_update_ok']);
	}
	else
	{
		$smarty->append('warning',$lang['subcond_update_ok']);
	}
}

$do = isset($_POST['do']) ? $_POST['do'] : '';

switch($do)
{
	case 'updateConditions':
		writeConditions($my_name, $my_url);
		break;
}

defaut($my_name,$my_url);
?>