<?php

function thmng_displayThemes($url)
{
	global $CONFIG, $lang;
	$my_name = 'thememng';
	$d = dir(SCRIPT_ROOT_PATH."/themes");
	$nodir = "Aucun Theme installe";
	$bAuMoinsUnRepertoire = false;
	$screenshot = "";

	Buffer::str('<h2>'.$lang['thmng_thememng'].'</h2><br />');
	Buffer::str('<div align="center">');
	Buffer::str('<table cellspacing="10" cellpadding="5" border="0">');

	$themes_root = SCRIPT_ROOT_PATH.'/themes';
	$config_file = SCRIPT_ROOT_PATH.'/conf/config.php';
	$themes = new plugins($themes_root,'theme');
	$themes->getPlugins(false);
	$themes_list = $themes->getPluginsList();
	$is_writable = is_writable($themes_root);
	$is_ini_writable = is_writable($themes_root);

	$i = 0;
	foreach ($themes_list as $k => $v)
	{
		if($i == 0)
		{
			Buffer::str('<tr>');
		}
		Buffer::str('<td valign="top" style="border: 1px dotted #555;">');
		if(file_exists(SCRIPT_ROOT_PATH.'/themes/'.$k.'/screenshot.png'))
		{
			$image = $CONFIG['site_url'].'/themes/'.$k.'/screenshot.png';
		}
		else
		{
			$image = $CONFIG['site_url'].'/themes/admin/images/no-screenshot.png';
		}
		Buffer::str('<div align="center"><img src="'.$image.'" alt="" style="border: 1px solid #000;" /></div>');
		Buffer::str('<br /><br />');

		Buffer::str(
		($k == $CONFIG['theme_dir'] ? '<img src="'.$CONFIG['site_url'].'/plugins/'.$my_name.'/images/selected.png" alt="'.$lang['thmng_current_theme'].' - "/> ' : '').
		$v['label'].' - '.$k.'<br />'.
		''.$v['desc'].' <br />'.
		'par '.$v['author'].' - '.$lang['thmng_version'].' '.$v['version'].' <br />'
		);

		if ($k != $CONFIG['theme_dir'] && $k != 'admin') {
			if ($is_ini_writable)
			{
				Buffer::str(
				'<strong><a href="'.htmlentities($url).'&amp;do=select&amp;theme='.urlencode($k).'">'.
				$lang['thmng_use_this_theme'].'</a></strong>'
				);
			}

			if ($is_writable && $k != 'default')
			{
				Buffer::str(
				' - <a href="'.htmlentities($url).'&amp;do=delete&amp;theme='.urlencode($k).'" '.
				'onclick="return window.confirm(\''.sprintf($lang['thmng_confirm_delete_theme'],$k).'\')">'.
				$lang['thmng_delete_theme'].'</a>'
				);
			}
		}

		$i++;
		Buffer::str('</td>');
		if($i == 3)
		{
			Buffer::str('</tr>');
			$i = 0;
		}
	}

	Buffer::str('</table>');
	Buffer::str('</div>');
	$d->close();
}

function thmng_selectNewTheme()
{
	$cm =& MyConfigManager::getInstance();
	$smarty =& TemplateEngine::getInstance();
	$new_theme = isset($_GET['theme']) ? $_GET['theme'] : '';

	if(!empty($new_theme))
	{
		$cm->setVar('theme_dir',$new_theme);
		$cm->updateConfig();

		// Smarty cache cleanup
		$smarty->clear_all_cache();
		$smarty->clear_compiled_tpl();
		return true;
	}
	else
	{
		return false;
	}
}

function thmng_displayAddForm($url)
{
	global $lang;
	$tool_url = isset($_GET['tool_url']) ? $_GET['tool_url'] : '';

	Buffer::str('<h2>'.$lang['thmng_install_theme'].'</h2><br />');
	Buffer::str(
	'<form action="'.htmlentities($url).'" method="get">'.
	'<input type="hidden" name="cat" value="plugins" />'.
	'<input type="hidden" name="p" value="thememng" />'.
	'<input type="hidden" name="do" value="install" />'.
	'<p><label for="tool_url">'.$lang['thmng_theme_url'].' :</label><br />'.
	form::field('tool_url',50,'',$tool_url).'&nbsp;<input type="submit" class="submit" value="'.$lang['thmng_install'].'" />'.
	'</p>'.
	'</form>'
	);
}

function thmng_deleteTheme()
{
	$my_name = 'thememng';
	$url = 'index.php?cat=plugins&p='.$my_name;

	$themes_root = SCRIPT_ROOT_PATH.'/themes';
	$config_file = SCRIPT_ROOT_PATH.'/conf/config.php';
	$themes = new plugins($themes_root,'theme');
	$themes->getPlugins(false);
	$themes_list = $themes->getPluginsList();
	$is_writable = is_writable($themes_root);

	$theme = (!empty($_GET['theme'])) ? $_GET['theme'] : '';
	if ($is_writable && $theme != '' && in_array($theme,array_keys($themes_list)) && $theme != 'default')
	{
		files::deltree($themes_root.'/'.$theme);
	}
}

function thmng_installTheme()
{
	global $lang;

	$themes_root = SCRIPT_ROOT_PATH.'/themes';
	$config_file = SCRIPT_ROOT_PATH.'/conf/config.php';
	$themes = new plugins($themes_root,'theme');
	$themes->getPlugins(false);
	$themes_list = $themes->getPluginsList();
	$is_writable = is_writable($themes_root);

	if ($is_writable && !empty($_GET['tool_url']))
	{
		$tool_url = $_GET['tool_url'];
		$parsed_url = parse_url($tool_url);

		if (empty($parsed_url['scheme']) || !preg_match('/^http|ftp$/',$parsed_url['scheme'])
		|| empty($parsed_url['host']) || empty($parsed_url['path']))
		{
			$err = $lang['thmng_invalid_url'];
		}
		else
		{
			if (($err = $themes->install($tool_url)) === true)
			{
				return true;
			}
		}
	}
}

$my_name = 'thememng';
$url = 'index.php?cat=plugins&p='.$my_name;
$select = isset($_GET['select']) ? $_GET['select'] : '';
$do = isset($_GET['do']) ? $_GET['do'] : '';

switch($do)
{
	case 'select':
		thmng_selectNewTheme();
		header('Location: '.$url);
		exit();
		break;

	case 'delete':
		thmng_deleteTheme();
		header('Location: '.$url);
		exit();
		break;

	case 'install':
		thmng_installTheme();
		header('Location: '.$url);
		exit();
		break;

	default:
		thmng_displayAddForm($url);
		thmng_displayThemes($url);
		break;
}

?>