<?php

$err = '';
$tool_url = '';

$plugins_root = SCRIPT_ROOT_PATH.'/plugins/';
$plugins = new plugins($plugins_root);
$plugins->getPlugins(false);
$plugins_list = $plugins->getPluginsList();

$is_writable = is_writable($plugins_root);

# Installation d'un plugin
if ($is_writable && !empty($_GET['tool_url']))
{
	$tool_url = $_GET['tool_url'];
	$parsed_url = parse_url($tool_url);
	
	if (empty($parsed_url['scheme']) || !preg_match('/^http|ftp$/',$parsed_url['scheme'])
	|| empty($parsed_url['host']) || empty($parsed_url['path']))
	{
		$smarty->append("message",'URL is not valid');
	}
	else
	{
		if (($err = $plugins->install($tool_url)) === true)
		{
			header('Location: index.php?cat=plugins&p=toolsmng');
			exit();
		}
	}
}

# Changement de status d'un plugin
$switch = (!empty($_GET['switch'])) ? $_GET['switch'] : '';

if ($is_writable && $switch != '' && in_array($switch,array_keys($plugins_list)) && $switch != 'toolsmng')
{
	$plugins->switchStatus($switch);
	header('Location: index.php?cat=plugins&p=toolsmng');
	exit;
}

# Suppression d'un plugin
$delete = (!empty($_GET['delete'])) ? $_GET['delete'] : '';

if ($is_writable && $delete != '' && in_array($delete,array_keys($plugins_list)) && $delete != 'toolsmng')
{
	files::deltree($plugins_root.'/'.$delete);
	header('Location: index.php?cat=plugins&p=toolsmng');
	exit;
}

if($err != '')
{
	Buffer::str('<div class="erreur"><p><strong>'.$lang['toolm_errors'].' :</strong></p>'.$err.'</div>');
}

Buffer::str('<h1>'.$lang['toolm_pluginmanager'].'</h1>'.'<h2>'.$lang['toolm_installplugin'].'</h2>');

if (!$is_writable)
{
	Buffer::str('<p>'.sprintf($lang['toolm_notwritablefolder'],SCRIPT_ROOT_PATH.'/plugins/').'</p>');
}
else
{
	Buffer::str('<form action="index.php" method="get">'
	.'<p><label for="tool_url">'.$lang['toolm_pluginfileurl']
	.' :</label><br /><input type="text" name="tool_url" size="50" value="" />&nbsp;<input type="submit" class="submit" value="'.$lang['toolm_install'].'" />'
	.'<input type="hidden" name="p" value="toolsmng" /><input type="hidden" name="cat" value="plugins" /></p>'
	.'</form>');
}

Buffer::str('<p><a href="#" style="color: green;">'.$lang['toolm_installnew'].'</a></p>');

# Tri des plugins par leur nom
uasort($plugins_list,create_function('$a,$b','return strcmp($a["label"],$b["label"]);'));

Buffer::str('<h2>'.$lang['toolm_installedplugins'].'</h2><br />');

foreach ($plugins_list as $k => $v)
{
	if (file_exists(SCRIPT_ROOT_PATH.'/plugins/'.$k.'/language/'.$CONFIG['language'].'/lang.php'))
	{
		require_once(SCRIPT_ROOT_PATH.'/plugins/'.$k.'/language/'.$CONFIG['language'].'/lang.php');
	}
	
	Buffer::str(
	'<ul><li><b>'.$lang[$v['label']].'</b> - '.$k.'<br />'.$lang[$v['desc']].' <br />'.$lang[$v['author']].' - '.'Version'.' '.$v['version'].'<br />');
	
 	if ($k != 'toolsmng' && $k != 'info')
	{
		if (is_writable($plugins_root.$k.'/desc.xml'))
		{
			$action = $v['active'] ? '<font color="blue">'.$lang['toolm_disable'].'</font>' : '<font color="green">'.$lang['toolm_enable'].'</font>';
			Buffer::str('<a href="index.php?cat=plugins&amp;p=toolsmng&amp;switch='.$k.'">'.$action.'</a>');
		} else
		{
			Buffer::str('<em>'.sprintf($lang['toolm_cannotmodify'],'desc.xml').'</em>');
		}
		
		if ($is_writable)
		{
			Buffer::str(' - <a href="index.php?cat=plugins&amp;p=toolsmng&amp;delete='.$k.'" '.
			'onclick="return window.confirm(\''.$lang['toolm_suredelete'].'\')" style="color: red;">'.$lang['toolm_delete'].'</a>');
		}
 	}
	
	Buffer::str('</li></ul><br />');
}
?>