<?php

function umng_displayUsers($my_name,$my_login,$url)
{
	$start = isset($_GET['start']) ? $_GET['start'] : 0;
	$limit = 25;
	global $CONFIG, $lang;
	$um =& get_manager('user');
	Buffer::str('<h1>'.$lang['umng_usermanager'].'</h1>'.'<h2>'.$lang['umng_users'].'</h2>');
	
	$criteria = new Criteria('isadmin');
	$criteria->setSort('isadmin');
	$criteria->setOrder('DESC');
	$criteria->setStart($start);
	$criteria->setLimit($limit);
	$users =& $um->getObjects($criteria);

	if(count($users) > 0)
	{
		Buffer::str("<table width='100%'>");
		
		$i = 0;
		foreach($users as $user)
		{
			$login = $user->getVar('login');
			$color = $i == 0 ? "#F3F3F3" : "#FFFFFF";
			$i = $i == 1 ? 0 : 1;
			
			Buffer::str("<tr bgcolor='".$color."'>");
			Buffer::str('<td width="10" valign="top">');
			Buffer::str('<a href="javascript:LiveScroll(\''.$login.'\');">');
			Buffer::str('<img src="'.$CONFIG['site_url'].'/themes/admin/images/plus.gif" border="0" alt="" />');
			Buffer::str('</a>');
			Buffer::str('</td>');
			
			$active = $user->getVar('active');
			$image = $active == 1 ? 'check_on.png' : 'check_off.png';
			Buffer::str('<td width="10" valign="top">');
			Buffer::str('<a href="javascript:LiveScroll(\''.$login.'\');">');
			Buffer::str('<img src="'.$CONFIG['site_url'].'/themes/admin/images/'.$image.'" border="0" alt="" />');
			Buffer::str('</a>');
			Buffer::str('</td>');
			
			Buffer::str('<td>');
			Buffer::str('<a href="javascript:LiveScroll(\''.$login.'\');">'.$login.'</a> - '.$user->getVar('email'));
			Buffer::str('<br />');
			Buffer::str('<div id="'.$login.'" style="display: none; position: relative;">');
			Buffer::str('<div style="float:right;">');
			
			$do = $active == 1 ? 'disable' : 'activate';
			
			Buffer::str('<a href="'.$url.'&amp;do=edit&amp;login='.$login.'">'.$lang['umng_edit'].'</a>');
			Buffer::str('-');
			
			if($user->getVar('login') != $my_login)
			{
				Buffer::str('<a href="'.$url.'&amp;do='.$do.'&amp;login='.$login.'">'.$lang['umng_'.$do].'</a>');
				Buffer::str('-');
				Buffer::str('<a href="'.$url.'&amp;do=delete&amp;login='.$login.'" onclick="return confirm(\''.sprintf($lang['umng_confirm_delete_user'],$login).'\');">');
			}
			else
			{
				Buffer::str('<a href="'.$url.'" onclick="return confirm(\''.sprintf($lang['umng_cannot_'.$do.'_self'],$login).'\');">'.$lang['umng_'.$do].'</a>');
				Buffer::str('-');
				Buffer::str('<a href="'.$url.'" onclick="return confirm(\''.sprintf($lang['umng_cannot_delete_self'],$login).'\');">');
			}
			
			Buffer::str($lang['umng_delete']);
			Buffer::str('</a>');
			
			Buffer::str('</div>');
			Buffer::str('</div>');
			Buffer::str('</td>');
			
			if($user->getVar('isadmin') == true)
			{
				Buffer::str('<td style="text-align: right;">');
				Buffer::str('<img src="'.$CONFIG['site_url'].'/plugins/'.$my_name.'/images/admin.png" border="0" alt="'.$lang['umng_isadmin'].'" />');
				Buffer::str('</td>');
			}
			
			Buffer::str('</tr>');
		}
		
		Buffer::str("</table>");
		
		$user_count = $um->getCount();
		if($user_count > $limit)
		{
			Buffer::str('<div align="center">');
			$nb_pages = ceil($user_count / $limit);
			for ($i=0; $i<$nb_pages; $i++)
			{
				$start = $i*$limit;
				Buffer::str('<a href="'.$url.'&amp;start='.$start.'">'.$i.'</a>');
			}
			Buffer::str('</div>');
		}
	}
	Buffer::str("<br />");
}

function umng_displayUserForm($my_name,$my_login,$url,$edit = false)
{
	global $CONFIG, $lang;
	if($edit)
	{
		$login = isset($_GET['login']) ? $_GET['login'] : (isset($_POST['login']) ? $_POST['login'] : '');
		$um =& get_manager('user');
		
		$criteria = new Criteria('login',$login,'=');
		$criteria->setLimit(1);
		$users =& $um->getObjects($criteria);
		
		if(count($users) > 0)
		{
			$email = $users[0]->getVar('email');
		}
		$isadmin = $users[0]->getVar('isadmin');
	}
	else
	{
		$login = isset($_POST['login']) ? $_POST['login'] : '';
		$pass = isset($_POST['pass']) ? $_POST['pass'] : '';
		$email = isset($_POST['email']) ? $_POST['email'] : '';
		$isadmin = isset($_POST['isadmin']) ? $_POST['isadmin'] : 0;
	}
	
	$do = $edit ? 'edit_user' : 'add_user';
	$submit = $edit ? $lang['umng_edit'] : $lang['umng_add'];
	$h2 = $edit ? $lang['umng_edit_user'] : $lang['umng_add_user'];
	$readonly = $edit ? 'readonly' : '';
	
	Buffer::str('<h2>'.$h2.'</h2><br />');
	Buffer::str('<form action="'.$url.'&amp;do='.$do.'" name="'.$do.'" method="post">');
	Buffer::str('<table align="center">');
	Buffer::str('<tr>');
	Buffer::str('<td>');
	Buffer::str($lang['umng_login'].' :');
	Buffer::str('</td>');
	Buffer::str('<td>');
	Buffer::str(form::field('login','30','30',$login,'',$readonly));
	Buffer::str('</td>');
	Buffer::str('</tr>');

	if($edit)
	{
		Buffer::str('<tr>');
		Buffer::str('<td>');
		Buffer::str($lang['umng_oldpass'].' :');
		Buffer::str('</td>');
		Buffer::str('<td>');
		Buffer::str(form::field('oldpass','30','30',''));
		Buffer::str('</td>');
		Buffer::str('</tr>');
		
		Buffer::str('<tr>');
		Buffer::str('<td>');
		Buffer::str($lang['umng_newpass'].' :');
		Buffer::str('</td>');
		Buffer::str('<td>');
		Buffer::str(form::field('newpass','30','30',''));
		Buffer::str('</td>');
		Buffer::str('</tr>');
	}
	else
	{
		Buffer::str('<tr>');
		Buffer::str('<td>');
		Buffer::str($lang['umng_pass'].' :');
		Buffer::str('</td>');
		Buffer::str('<td>');
		Buffer::str(form::field('pass','30','30',$pass));
		Buffer::str('</td>');
		Buffer::str('</tr>');
	}
	
	Buffer::str('<tr>');
	Buffer::str('<td>');
	Buffer::str($lang['umng_email'].' :');
	Buffer::str('</td>');
	Buffer::str('<td>');
	Buffer::str(form::field('email','30','50',$email));
	Buffer::str('</td>');
	Buffer::str('</tr>');
	
	Buffer::str('<tr>');
	Buffer::str('<td>');
	Buffer::str($lang['umng_isadmin'].' :');
	Buffer::str('</td>');
	Buffer::str('<td style="text-align: center;">');
	Buffer::str($lang['yes']);
	
	$checked = $isadmin == 1 ? 1 : '';
	Buffer::str(form::radio('isadmin','1',$checked));
	Buffer::str('&nbsp;');
	Buffer::str($lang['no']);
	$checked = $isadmin == 1 ? '' : 1;
	Buffer::str(form::radio('isadmin','0',$checked));
	Buffer::str('</td>');
	Buffer::str('</tr>');

	Buffer::str('<tr>');
	Buffer::str('<td></td><td align="right">');
	Buffer::str('<input type="submit" name="ok" value="'.$submit.'"/>');
	Buffer::str('</td>');
	Buffer::str('</tr>');
	
	Buffer::str('</table>');
	Buffer::str('</form');
	Buffer::str("<br />");
}

function umng_addUser()
{
	global $lang;
	$smarty =& TemplateEngine::getInstance();
	$login = isset($_POST['login']) ? $_POST['login'] : '';
	$pass = isset($_POST['pass']) ? $_POST['pass'] : '';
	$email = isset($_POST['email']) ? $_POST['email'] : '';
	$isadmin = isset($_POST['isadmin']) ? $_POST['isadmin'] : '';
	
	$add_ok = false;
	
	if(!empty($login) && !empty($pass) && !empty($email))
	{
		$um =& get_manager('user');
		$user =& $um->create(true);
		
		$attributes = array('login' => $login, 
							'email' => $email, 
							'isadmin' => $isadmin);
		$user->setVars($attributes);
		$user->setPassword($pass);
		
		// checking if login or email are already existing
		$criteria = new CriteriaCompo(new Criteria('login',$login,'='),'OR');
		
		if($um->getCount($criteria) == 0)
		{
			$criteria->add(new Criteria('email',$email,'='),'OR');
			
			if($um->getCount($criteria) == 0)
			{
				$um->insert($user);
				$add_ok = true;
				$smarty->append('warning',$lang['umng_user_created']);
			}
			else
			{
				// User with same email
				$smarty->append('warning',$lang['umng_email_already_existing']);
			}
		}
		else
		{
			// user with same login
			$smarty->append('warning',$lang['umng_login_already_existing']);
		}
		
	}
	else
	{
		$smarty->append('warning',$lang['umng_fill_all']);
	}
	
	return $add_ok;
}

function umng_deleteUser()
{
	global $lang;
	$smarty =& TemplateEngine::getInstance();
	$login = isset($_GET['login']) ? $_GET['login'] : '';
	
	if(!empty($login))
	{
		$um =& get_manager('user');
		
		$criteria = new Criteria('login',$login,'=');
		$criteria->setLimit(1);
		
		$um->deleteAll($criteria);
		$smarty->append('warning',sprintf($lang['umng_user_deleted'],$login));
	}
	else
	{
		$smarty->append('warning',$lang['umng_user_login_empty']);
	}
}

function umng_editUser()
{
	global $lang;
	$smarty =& TemplateEngine::getInstance();
	$login = isset($_POST['login']) ? $_POST['login'] : '';
	$oldpass = isset($_POST['oldpass']) ? $_POST['oldpass'] : '';
	$newpass = isset($_POST['newpass']) ? $_POST['newpass'] : '';
	$email = isset($_POST['email']) ? $_POST['email'] : '';
	$edition_ok = false;
	
	if(!empty($login) && !empty($email) )
	{
		$um =& get_manager('user');
		$criteria = new CriteriaCompo(new Criteria('login',$login,'='),'AND');
		$criteria->add(new Criteria('pass',md5($oldpass),'='),'AND');
		$criteria->setLimit(1);
		
		$users =& $um->getObjects($criteria);
		
		if(count($users) == 1)
		{
			// No password change, jump here
			foreach($users as $user)
			{
				$user->setVar('email',$email);
				
				if(!empty($oldpass) && !empty($newpass))
				{
					$user->setPassword($newpass);
					$user->updateCookie('pass',md5($newpass));
				}
				
				$user->unsetNew();
				$um->insert($user);
			}
			$edition_ok = true;
			$smarty->append('warning',$lang['umng_user_edit_ok']);
		}
		else
		{
			$criteria = new CriteriaCompo(new Criteria('login',$login,'='),'AND');
			$criteria->setLimit(1);
			$user_count =& $um->getCount($criteria);
			
			// Error
			if($user_count > 0)
			{
				$smarty->append('warning',$lang['umng_incorrect_pass']);
			}
			else
			{
				$smarty->append('warning',sprintf($lang['umng_user_not_found'],$login));
			}
			
		}
	}
	else
	{
		// one or more field empty
		$smarty->append('warning',$lang['umng_edit_fill_all']);
	}
	
	return $edition_ok;
}

function umng_flushPostVars()
{
	foreach($_POST as $key => $value)
	{
		unset($_POST[$key]);
	}
}


function umng_modifyUserStatus($active)
{
	global $lang;
	$smarty =& TemplateEngine::getInstance();
	$login = isset($_GET['login']) ? $_GET['login'] : '';
	if(!empty($login) && isset($active))
	{
		$um =& get_manager('user');
		
		$criteria = new Criteria('login',$login,'=');
		$criteria->setLimit(1);
		
		$um->update($criteria,array('active' => $active));
		
		$do = $active == 1 ? 'activate' : 'disable';
		$smarty->append('warning',$lang['umng_'.$do.'_ok']);
	}
}

?>