<?php

/*
*	Displays RSS feed of the website
*/

include (dirname(__FILE__).'/init.php');
// RSS generator PHP class
include (SCRIPT_ROOT_PATH.'/class/class.rss_generator.php');

$lm =& get_manager('link');

$criteria = new Criteria("state",4,'=');
$criteria->setOrder('DESC');
$criteria->setSort('id');
$criteria->setLimit(10);

$cols = array('id','name','url','description','image');
$sites = $lm->getObjects($criteria,$cols);

$rss = new rssGenerator_channel();
$rss_channel->title = utf8_encode($CONFIG['site_name']);
$rss_channel->link = $CONFIG['site_url'];
$rss_channel->description = utf8_encode($CONFIG['site_name']);
$rss_channel->language = 'fr-fr';
$rss_channel->generator = 'FreeGlobes';
$rss_channel->managingEditor = $CONFIG['site_mail'];
$rss_channel->webMaster = $CONFIG['site_mail'];

if (count($sites) != 0)
{
	$re =& MyRewriteEngine::getInstance();
	foreach($sites as $site)
	{
		$item = new rssGenerator_item();
		$item->title = '<![CDATA[ '.utf8_encode($site->getVar('name')).' ]]>';
		$item->description = '<![CDATA[ '.utf8_encode($site->getVar('description')).' ]]>';
		$item->link = $CONFIG['site_url'].'/'.$re->buildUrl('single',array('id' => $site->getVar('id'), 'name' => $site->getVar('name')));
		
		$image = $site->getVar('image');
		if(!empty($image) && $image != 'http://')
		{
			$filesize = 0;
			$item->enclosure_url = $image;
			$item->enclosure_length = $filesize;
		}
	
		$rss_channel->items[] = $item;
		unset($item);
	}
}

$rss_feed = new rssGenerator_rss();
$rss_feed->encoding = 'UTF-8';
$rss_feed->version = '2.0';

header('Content-Type: text/xml');
echo $rss_feed->createFeed($rss_channel);

include(dirname(__FILE__).'/disconnect.php');
?>