<?php

/***********************************/
/* Initialization */
require_once (dirname(__FILE__).'/init.php');
/***********************************/

$action = isset($_POST['action']) ? $_POST['action'] : '';
$template = 'single.html';

function defaut($template, $cache_id)
{
	global $CONFIG, $lang;
	$smarty =& TemplateEngine::getInstance();
	$racine = isset($_GET['dir']) ? $_GET['dir'] : 0;
	$start = isset($_GET['start']) ? $_GET['start'] : 1;

	// Some information about the directory
	displaySummary($racine);
	// boost site
	displayBoostSite();
	// TagCloud
	displayTagCloud();
	
	$id = isset($_GET['id']) ? $_GET['id'] : 0;

	if($id != 0)
	{
		if(!$smarty->is_cached($template,$cache_id))
		{
			$lm =& get_manager('link');
			$criteria = new Criteria('id',$id,'=');
			$criteria->setLimit(1);
			$links =& $lm->getObjects($criteria);
            
            if(count($links) > 0)
            {
                // Update Pagerank information
                updatePagerank(array('id' => $links[0]->getVar('id'), 
                                         'url' => $links[0]->getVar('url'), 
                                         'pr' => $links[0]->getVar('pr')));
            }
                        
			affichage_liens($links, $CONFIG['url_rewriting'],1,true,true);
			
			// Meta title
			$meta_title = $CONFIG['site_name'].' > '.$links[0]->getVar('name');
			$smarty->assign("meta_title",$meta_title);
			
			// Meta Description
			$meta_desc = strip_tags($links[0]->getVar('description'));
			$meta_desc = str_replace(array('&#039;','"'),array("'",''),html_entity_decode($meta_desc));
			if(strlen($meta_desc) > 200)
			{
				$meta_desc = substr($meta_desc,0,200).'..';
			}
			$smarty->assign("meta_desc",$meta_desc);
			
			// Meta Keywords
			$meta_keyw = '';
			$keywords = explode(" ",$meta_desc);
			foreach($keywords as $key => $keyword)
			{
				$my_keyword = html_entity_decode($keyword);
				$my_keyword = str_replace(',','',$my_keyword);
				if(strlen($keyword) < 5)
				{
					unset($keywords[$key]);
				}
				else
				{
					$keywords[$key] = $my_keyword;
				}
			}
			$meta_keyw = implode(',',$keywords);
			if(strlen($meta_keyw) > 1000)
			{
				$meta_keyw = substr($meta_keyw,0,1000).'..';
			}
			$smarty->assign("meta_keyw",$meta_keyw);
			
			$cm =& get_manager('comment');
			$criteria = new CriteriaCompo(new Criteria('lid',$id,'='),'AND');
			$criteria->add(new Criteria('approved',1,'='),'AND');
			
			$comments =& $cm->getObjects($criteria);
			
			if(count($comments) > 0)
			{
				$append = array();
				foreach($comments as $comment)
				{
					$attributes = $comment->getVars();
					
					foreach($attributes as $key => $value)
					{
						$append[$key] = $attributes[$key]['value'];
					}
					$smarty->append('comments',$append);
					unset($attributes);
					unset($append);
				}
			}
			else
			{
				// No comment
				$smarty->assign('no_comment',$lang['no_comment']);
			}
		}
		
		$smarty->assign('comment_form_action',$_SERVER['REQUEST_URI']);
		$smarty->assign('tag_form_action',$_SERVER['REQUEST_URI']);
	}
}

function postComment()
{
	session_start();
	global $CONFIG, $lang;
	$smarty =& TemplateEngine::getInstance();
	
	$body = isset($_POST['body']) ? strip_tags($_POST['body']) : '';
	$user_antibotcode = isset($_POST['antibotcode']) ? $_POST['antibotcode'] : '';
	$antibotcode = isset($_SESSION['antibotcode']) ? $_SESSION['antibotcode'] : '';
	$lid = isset($_POST['lid']) ? intval($_POST['lid']) : 0;
	$approved = $CONFIG['auto_approve_comments'] == 1 ? 1 : 0;
	
	$um =& get_manager('user');
	$cm =& get_manager('comment');
	
	$uid = $um->myUID();
	
	if(!empty($body))
	{
		if($antibotcode == $user_antibotcode || !$CONFIG['use_antibot'])
		{
			$comment = $cm->create(true);
			$attributes = array('uid' => $uid, 
								'lid' => $lid, 
								'message' => $body, 
								'approved' => $approved);
								
			$comment->setVars($attributes);
			
			$cm->insert($comment);
			
			$smarty->append('warning',$lang['comment_posted']);
		}
		else
		{
			$smarty->append('warning',$lang['invalid_securitycode']);
		}
	}
	else
	{
		// Empty body
		$smarty->append('warning',$lang['fill_in_all_fields']);
	}
}

function postTag()
{
	$tag = isset($_POST['tag']) ? $_POST['tag'] : '';
	$lid = isset($_POST['lid']) ? $_POST['lid'] : 0;
	
	if(!empty($tag) && $lid != 0)
	{
		$tm =& get_manager('tag');
		$tm->insertLinkTag($lid,$tag);
	}
}

switch($action)
{
	case 'postComment':
		if($CONFIG['use_comments'])
		{
			postComment();
		}
		break;
	
	case 'postTag':
		postTag();
		break;
}

defaut($template, $cache_id);

include(dirname(__FILE__).'/disconnect.php');

$smarty->display($template,$cache_id);
?>