<?php
/** cut string */
function cutstr($string, $length, $dot = '...', $charset = 'utf-8') {
	if (strlen($string) <= $length) {
		return $string;
	}
	
	$pre = chr(1);
	$end = chr(1);
	$string = str_replace(array('&amp;', '&quot;', '&lt;', '&gt;'), array($pre.'&'.$end, $pre.'"'.$end, $pre.'<'.$end, $pre.'>'.$end), $string);

	$strcut = '';
	if (strtolower($charset) == 'utf-8') {
		$n = $tn = $noc = 0;
		while ($n < strlen($string)) {
			$t = ord($string[$n]);
			if ($t == 9 || $t == 10 || (32 <= $t && $t <= 126)) {
				$tn = 1; $n++; $noc++;
			} elseif(194 <= $t && $t <= 223) {
				$tn = 2; $n += 2; $noc += 2;
			} elseif(224 <= $t && $t <= 239) {
				$tn = 3; $n += 3; $noc += 2;
			} elseif(240 <= $t && $t <= 247) {
				$tn = 4; $n += 4; $noc += 2;
			} elseif(248 <= $t && $t <= 251) {
				$tn = 5; $n += 5; $noc += 2;
			} elseif($t == 252 || $t == 253) {
				$tn = 6; $n += 6; $noc += 2;
			} else {
				$n++;
			}

			if($noc >= $length) {
				break;
			}
		}
		if($noc > $length) {
			$n -= $tn;
		}

		$strcut = substr($string, 0, $n);
	} else {
		for($i = 0; $i < $length; $i++) {
			$strcut .= ord($string[$i]) > 127 ? $string[$i].$string[++$i] : $string[$i];
		}
	}

	$strcut = str_replace(array($pre.'&'.$end, $pre.'"'.$end, $pre.'<'.$end, $pre.'>'.$end), array('&amp;', '&quot;', '&lt;', '&gt;'), $strcut);

	$pos = strrpos($s, chr(1));
	if ($pos !== false) {
		$strcut = substr($s, 0, $pos);
	}
	return $strcut.$dot;
}

/** get url content  */
function get_url_content($url) {
	require('includes/snoopy.php');
	
	$snoopy = new Snoopy();
	$snoopy->agent = $_SERVER['HTTP_USER_AGENT'];
	$snoopy->referer = $_SERVER['HTTP_REFERER'];
	$snoopy->fetch($url);
	if ($snoopy->status == 200) {
		$content = $snoopy->results;
		$encode = mb_detect_encoding($content, array('ascii', 'gb2312', 'utf-8', 'gbk'));
		if ($encode == 'EUC-CN' || $encode == 'CP936') {
			$content = @mb_convert_encoding($content, 'utf-8', 'gb2312');
		}
	} else {
		$content = $snoopy->error;
	}
	
	return $content;
}

function get_scripttime() {
	global $start_time;
	
	$mtime = explode(' ', microtime());
	$end_time = $mtime[1] + $mtime[0];
	$exec_time = number_format(($end_time - $start_time), 6);
	
	return $exec_time;
}

/** write cache */
function write_cache($cache_name, $cache_data = '') {
	$cache_dir = './';
	$cache_file = $cache_dir.$cache_name.'.php';
	
	if (!is_dir($cache_dir)) {
		@mkdir($cache_dir, 0777);
	}
	
	if ($fp = @fopen($cache_file, 'wb')) {
		@fwrite($fp, "<?php\r\n".$cache_data."\r\n?>");
		@fclose($fp);
		@chmod($cache_file, 0777);
	} else {
		echo 'Error: Can\'t write to '.$cache_name.' cache files, please check directory.!';
		exit;
	}
}

/** word link */
function get_wordlink($keyword) {
	return 'search.php?query='.urlencode($keyword);
}
?>