<?php
class HanFox_Search {
	private $keyword;
	private $curpage;
	private $content;
	
	public function __construct($keyword, $curpage) {	
		if (empty($keyword)) {
			header('Location: ./');
		}
		
		$this->keyword = $keyword;
		$this->curpage = ($curpage * 10) - 10;
		$url = 'http://www.baidu.com/s?wd='.urlencode($this->keyword);
		$curpage > 0 ? $url .= '&pn='.$this->curpage : '';
		$this->content = get_url_content($url);
	}
	
	public function get_index() {
		if (preg_match('/<span class="nums" style="margin-left:120px">找到相关结果(.*?)个<\/span>/i', $this->content, $matches)) {
			 $index = str_replace('约', '', $matches[1]);
		} else {
			$index = 0;
		}
		return $index;
	}
	
	public function get_body() {
		$body = $this->content;
		$start = strstr($body, '<table cellpadding="0" cellspacing="0"');
		$end = strpos($start, '<div id="search">');
		return substr($start, 0, $end);
	}
	
	public function get_lists() {
		$data = $this->get_body();
		$items = explode('<table cellpadding="0" cellspacing="0"', $data);
		
		$result = array();
		foreach ($items as $key => $item) {
			$item = preg_replace('/<em>(.*?)<\/em>/i', '<font color="#ff0000">\\1</font>', $item);
			//常规
			if (preg_match('/<h3\s+class="t"><a\s+onMouseDown="(.*?)"\s+href="(.*?)"target="_blank">(.*?)<\/a>([\s\S]*?)<\/h3><font\s+size=-1>(.*?)<span\s+class="g">(.*?)\s+(.*?)\s+<\/span>\s+-\s+<a\s+href="(.*?)"\s+target="_blank"\s+class="m">百度快照<\/a>/i', $item, $info)) {
				$result[$key]['title'] = $info[3];
				$result[$key]['url'] = $info[2];
				$result[$key]['desc'] = rtrim($info[5], '<br>');
				$result[$key]['link'] = cutstr($info[2], 50);
				$result[$key]['date'] = $info[7];
				$result[$key]['cache'] = $info[8];
			}
		}
		return $result;
	}
	
	public function get_pages() {
		$data = $this->content;
		
		$showpage = '';
		if (preg_match('/<p\s+id="page">(.*?)<span\s+class="nums"\s+style="margin-left:120px">(.*?)<\/span><\/p>/', $data, $pageinfo)) {
			$showpage = $pageinfo[1];
			
			$showpage = str_replace('&usm=1', '', $showpage);
			$showpage = str_replace('&usm=2', '', $showpage);
			$showpage = str_replace('&usm=3', '', $showpage);
			$showpage = str_replace('&usm=4', '', $showpage);
			$showpage = str_replace('&usm=5', '', $showpage);
			$showpage = str_replace('&usm=6', '', $showpage);
			$showpage = str_replace('&cl=0', '', $showpage);
			$showpage = str_replace('&ch=10', '', $showpage);
			$showpage = str_replace('&rsv_page=1', '', $showpage);
			$showpage = str_replace('[', '', $showpage);
			$showpage = str_replace(']', '', $showpage);
			//$showpage = str_replace('class="n"', '', $showpage);
			$showpage = preg_replace_callback("/<a\s+href=[\'\"]s\?wd=(.*?)&pn=(\d+)[\'\"](\s+class=[\'\"]n[\'\"])?>(.*?)<\/a>/i", array(&$this, get_pageurl), $showpage);
		}
		$showpage = str_replace('上一页', '', $showpage);
		$showpage = str_replace('下一页', '', $showpage);
		return $showpage;
	}
	
	public function related_words() {
		$relword = array();
		$data = $this->content;
		if (preg_match('/<div\s+id="rs">([\w\W]*?)<\/div>/i', $data, $info)) {
			if (preg_match_all('/<a\s+href="(.*?)">(.*?)<\/a>/i', $info[1], $rword)) {
				$rwords = array_filter($rword[2]);
				foreach ($rwords as $key => $val) {
					$relword[$key]['word'] = $val;
					$relword[$key]['link'] = get_wordlink($val);
				}
			}
		}
		return $relword;
	}

	private function get_pageurl($matches) {
		$page = ($matches[2] / 10) + 1;
		return "<a href=\"".get_wordlink($this->keyword)."&page=".$page."\">".$matches[4]."</a>";
	}
}
?>