<?php
$mtime = explode(' ', microtime());
$start_time = $mtime[0] + $mtime[1];

require('config.php');
require('includes/function.php');
require('includes/search.php');

$keyword = trim($_GET['query']);
$curpage = intval($_GET['page']);

$search = new HanFox_Search($keyword, $curpage);
$index = $search->get_index();
$lists = $search->get_lists();
$pages = $search->get_pages();
$rwords = $search->related_words();
?>
<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title><?php echo $keyword.' - '.$config['site_title']; ?></title>
<meta name="Keywords" content="<?php echo $keyword.'搜索结果，汉狐搜索，垂直搜索，聚合搜索，Hanfox Search Engine'; ?>" />
<meta name="Description" content="<?php echo '以下是与关键词'.$keyword.'相关的搜索结果。'; ?>" />
<link href="skin/list.css" rel="stylesheet" type="text/css">
<script type="text/javascript" src="scripts/jquery.js"></script>
<script type="text/javascript" src="scripts/common.js"></script>
<script type="text/javascript" src="scripts/suggest.js"></script>
</head>

<body>
<div id="topbar">网页导航：<a href="http://www.35dir.com/" target="_blank">35分类目录</a> | <a href="http://www.35dir.net/" target="_blank">PHP分类目录源码</a> | <a href="http://www.hanfox.com/" target="_blank">汉狐搜索</a> | <a href="http://dir.hanfox.com/" target="_blank">汉狐目录</a></div>
<div id="wrapper">
	<div id="header">
		<a class="logo" href="<?php echo $config['site_url']; ?>" title="<?php echo $config['site_name']; ?>"></a>
		<div id="formbox">
			<form name="search" id="search" method="get" action="search.php">
    		<fieldset>
    		<input type="text" name="query" id="query" size="50" autocomplete="off" class="ipt" value="<?php echo $keyword; ?>" /><input type="submit" class="btn" value="搜 索" />
        	</fieldset>
    		</form>
        	<p class="stats"><font color="#FF0000"><?php echo $keyword; ?></font> 找到约 <?php echo $index; ?> 条结果 （用时 <?php echo get_scripttime(); ?> 秒）</p>
    	</div>
	</div>
    <div id="mainbox" class="clearfix">
    	<div id="sidebar">
        	<div id="related">
        		<h3>相关搜索</h3>
            	<ul>
                	<?php foreach ($rwords as $row) { ?>
            		<li><a href="<?php echo $row['link']; ?>"><?php echo $row['word']; ?></a></li>
                	<?php } ?>
            	</ul>
        	</div>
        </div>
        <div id="listbox" class="clearfix">
        	<div style="padding-bottom: 20px;"><?php echo $adsense['google468x15']; ?></div>
        	<ul class="reslist">
            	<?php $i = 0; foreach ($lists as $row) { $i++;?>
                <?php if ($i == 2) { ?>
                <li>
                	<h3><a href="http://www.hanfox.com/?mod=search&query=<?php echo urlencode($keyword); ?>" target="_blank"><font color="#ff0000"><?php echo $keyword; ?></font>_汉狐搜索</a></h3>
                    <p>汉狐搜索引擎，支持搜索提示，显示最新热门搜索词，支持自定义网站广告。</p>
                    <address>http://www.hanfox.com/ - <?php echo date('Y-m-d', time()); ?> - <a href="http://www.hanfox.com/" target="_blank">网页快照</a></address>
                </li>
				<?php } ?>
            	<li>
                	<h3><a href="<?php echo $row['url']; ?>" target="_blank"><?php echo $row['title']; ?></a></h3>
                    <p><?php echo $row['desc']; ?></p>
                    <address><?php echo $row['link']; ?> <?php echo $row['date']; ?> - <a href="<?php echo $row['cache']; ?>" target="_blank">网页快照</a></address>
                </li>
                <?php } ?>
            </ul>
        	<div id="pagebar" class="clearfix"><?php echo $pages; ?></div>
            <div id="footer"><?php echo $config['site_copyright']; ?><br><span style="display: none;"><script src="http://s14.cnzz.com/stat.php?id=2594769&web_id=2594769&show=pic" language="JavaScript"></script></span></div>
        </div>
        <div id="other">
            <div style="padding-left: 15px;"><?php echo $adsense['google160x600']; ?></div>
        </div>
    </div>
</div>
<script type="text/javascript">
(function(){var suggest = new GoogleSuggest("search", "query", 0);})();
</script>
</body>
</html>