<?php

//=====================================
// weenSearch Engine
//=====================================
// Filename : template.php
// Path  : Function directory
// last update : 2005/07/02
// Desc : Template system
//=====================================


class Stemplate {

var $FileList			= array();
var $DynAr				= array();
var $MacroAr			= array();
var $Macro			= array();
var $Root				=	"";
var $Strict				=	false;
var $Win32				=	false;
var $IncCheck         =  false;



function Stemplate ($template_dir = "")
{

	if(isset($template_dir)) {
		$sep = substr($template_dir,-1) ;

		if ($sep <> '\\' && $sep <> '/') 
		$template_dir .= ($this->Win32) ? '\\' : '/';
		
		if (is_dir($template_dir)) 
		$this->Root = trim($template_dir);

		else 
		$this->errmsg("No such template directory : ( $template_dir )");
	}

	else 
	$this->errmsg(" There is no  template directory");

}	

function errmsg($errmsg) {
	
	echo ("<font color='red'>Stemplate error</font> : $errmsg ");
	exit;
}

function define ($file_array,$fname="") {

	if (!is_array($file_array)) {
        if (!file_exists($this->Root . $fname)) 
        {
            $this->errmsg(" There is no $fname file ");
        }
        $this->FileList[$file_array] = implode("",@file($this->Root . $fname));
    }
	
	else 	{
    	while ( list ($key,$val) = each ($file_array) ) {
            if (!file_exists($this->Root . $val)) 
            {
                $this->errmsg(" There is no $val file ");
            }
	        $this->FileList[$key] = @implode("",@file($this->Root . $val));
        }
	}

}

function dyn_define ($key, $macro) {

	$content = $this->FileList[$macro];
	
	$buffer = explode("\n",$content);
	$buffer_num = count($buffer);
	
	for ($i =0; $i<$buffer_num ;$i++) 	{

		if (trim($buffer[$i]) == "<!-- END DYN: $key -->" ) break;
		if ($start_key) $this->FileList[$key] .=  $buffer[$i]. "\n";
		if (trim($buffer[$i]) == "<!-- BEGIN DYN: $key -->" ) $start_key = 1;
	}
	
	if ($this->FileList[$key]) {
	$this->DynAr[$key] = $macro ;
	}	
	else 
	$this->errmsg( " Incorrect DYN ($key dynamic) template definition.");

}


function assign ($macro,$val="") { 

	if (!is_array($macro)) 
	$this->Macro[$macro] = $val;

	else 	{
		while ( list ($key,$val) = each ($macro))
		$this->Macro[$key] = $val;	
	}

}


function parse ($macro, $handle) {

	$append = substr($handle,0,1);
	
	if ($append == '.') 
	$handle = substr($handle,1); 
		
	$buffer = $this->FileList[$handle];

	foreach ($this->Macro as $key => $val)
	$buffer = str_replace("<%".$key."%>",$val,$buffer); 
	
	/* slow speed
	foreach ($this->DynAr as $key => $val) {

		if ( $val == $handle ) {
		$temp = $this->MacroAr[$key];
		ereg("<!-- BEGIN DYN: $key -->(.*)<!-- END DYN: $key -->",$buffer,$regs);
		$buffer = str_replace($regs[1], $this->Macro[$temp], $buffer);
		}
	}
	*/
	
	/* better speed */
	foreach ($this->DynAr as $key => $val) {

		if ( $val == $handle ) {
			$temp = $this->MacroAr[$key];

			$buffer_ar = explode("\n",$buffer);
			$buffer_num = count($buffer_ar);
			
			for ($i =0; $i<$buffer_num ;$i++) 	{

				if (trim($buffer_ar[$i]) == "<!-- END DYN: $key -->" ) $start_key = 0;

				if ($start_key) {
					if (!$input_key) {
					if ($temp) $content .=  $this->Macro[$temp];
					$input_key = 1;
					}
					else continue;
					
				}
				else $content .=  $buffer_ar[$i]. "\n";
						
				if (trim($buffer_ar[$i]) == "<!-- BEGIN DYN: $key -->" ) $start_key = 1;
				
			}

			$buffer = $content;
			unset($content);
			unset($input_key);
		}
	}


	if (!$this->Strict) {
	$buffer = ereg_replace("<%[A-Z0-9_]+%>","",$buffer); 	
	//$buffer = ereg_replace("<!-- BEGIN DYN:(.*)<!-- END DYN: [[:alnum:]]{2,} -->","", $buffer) ;
	}
	
	if ($append == ".") 
	$this->Macro[$macro] .= $buffer;
	else 
	$this->Macro[$macro] = $buffer;
	
	$this->MacroAr[$handle] = $macro;
	
}


function simprint($macro) {
	
	if ($this->IncCheck) 
	{
		$temp_array = explode ("\n",$this->Macro[$macro]);
		while (list($key,$val) = each($temp_array) )
		{
			if (trim($val) == "<!-- END INC -->") 	$start_check = 0;
			
			if ($start_check) 
			{
				if (trim($val)) @eval(trim($val));
			}
			
			else 	echo $val."\n";
			
			if (trim($val) == "<!-- START INC -->") $start_check = 1 ;
		}
	}
	else 
	{
		echo $this->Macro[$macro];
	}

}

function simfetch($macro) {

	return $this->Macro[$macro];
}

function clear ($macro) {

	if (is_array($macro)) 
	{
		while (list(,$key) = each($macro)) 
		unset ($this->Macro[$key]);
	}
	else 
	unset ($this->Macro[$macro]);

}


function dyn_clear($macro) {

unset ($this->DynAr[$macro]);
//unset ($this->FileList[$macro]);

}



} // End class

?>