<?php
/*******************************************************************************
*  Title: LinkMan reciprocal link manager
*  Version: 1.7 @ April 18, 2009
*  Author: Klemen Stirn
*  Website: http://www.phpjunkyard.com
********************************************************************************
*  COPYRIGHT NOTICE
*  Copyright 2004-2009 Klemen Stirn. All Rights Reserved.
*
*  This script may be used and modified free of charge by anyone
*  AS LONG AS COPYRIGHT NOTICES AND ALL THE COMMENTS REMAIN INTACT.
*  By using this code you agree to indemnify Klemen Stirn from any
*  liability that might arise from it's use.
*
*  Selling the code for this program, in part or full, without prior
*  written consent is expressly forbidden. Using this code, in part or full,
*  to create competing scripts or products is expressly forbidden.
*
*  Obtain permission before redistributing this software over the Internet
*  or in any other medium. In all cases copyright and header must remain
*  intact. This Copyright is in full effect in any country that has
*  International Trade Agreements with the United States of America or
*  with the European Union.
*
*  Removing any of the copyright notices without purchasing a license
*  is illegal! To remove PHPJunkyard copyright notice you must purchase a
*  license for this script. For more information on how to obtain a license
*  please visit the site below:
*  http://www.phpjunkyard.com/copyright-removal.php
*******************************************************************************/

define('IN_SCRIPT',1);
require('settings.php');
ini_set('user_agent', 'LinkMan '.$settings['verzija'].' by http://www.phpjunkyard.com');

/* Accepting any more links? */
$lines = @file($settings['linkfile']);
if (count($lines)>$settings['max_links'])
{
    problem('We are not accepting any more links at the moment. We appologize for the inconvenience!');
}

/* Check user input */
$name  = pj_input($_POST['name'],'Please enter your name!');
$email = pj_input($_POST['email'],'Please enter your e-mail address!');
if (!preg_match('/([\w\-]+\@[\w\-]+\.[\w\-]+)/',$email))
{
    problem('Please enter a valid e-mail address!');
}
$title = pj_input($_POST['title'],'Please enter the title (name) of your website!');
if (strlen($title)>50)
{
    problem('Title is too long! Limit website title to 50 chars!');
}

$url   = pj_input($_POST['url'],'Please enter the URL of your website!');
if (!(preg_match('/(http:\/\/+[\w\-]+\.[\w\-]+)/i',$url)))
{
    problem('Please enter valid URL of your website!');
}

$recurl = pj_input($_POST['recurl'],'Please enter the url where a reciprocal link to our site is placed!');
if (!(preg_match('/(http:\/\/+[\w\-]+\.[\w\-]+)/i',$recurl)))
{
    problem('Please enter valid URL of the page where the reciprocal link to our site is placed!');
}

/* Compare URL and Reciprocal page URL */
$parsed_url = parse_url($url);
$parsed_rec = parse_url($recurl);
if ($parsed_url['host'] != $parsed_rec['host'])
{
    problem('The reciprocal link must be placed under the same (sub)domain as your link is!');
}

$url    = str_replace('&amp;','&',$url);
$recurl = str_replace('&amp;','&',$recurl);

$description = pj_input($_POST['description'],'Please write a short description of your website!');
if (strlen($description)>200)
{
    problem('Description is too long! Description of your website is limited to 200 chars!');
}

/* Check if the website is banned */
if ($mydata = file_get_contents($settings['banfile']))
{
	/* Check website URL */
	$regex = str_replace(array('http://www.','http://'),'http://(www\.)?',$url);
	$regex = preg_replace('/index\.[^\/]+$/','',$regex);
	$regex = str_replace('/','\/',rtrim($regex,'/'));
	$regex = '/'.$regex.'\/?(index\.[^\/]+)?/i';
	if (preg_match($regex,$mydata))
	{
		problem('This website has been permanently banned from our link exchange!');
	}

	/* Check reciprocal link URL */
	$regex = str_replace(array('http://www.','http://'),'http://(www\.)?',$recurl);
	$regex = preg_replace('/index\.[^\/]+$/','',$regex);
	$regex = str_replace('/','\/',rtrim($regex,'/'));
	$regex = '/'.$regex.'\/?(index\.[^\/]+)?/i';
	if (preg_match($regex,$mydata))
	{
		problem('This website has been permanently banned from our link exchange!');
	}

	unset($mydata);
}

/* Check title and description for possible spam problems */
eval(gzinflate(base64_decode('FZe1ssUIkkQ/Z7pDhphiYg3BFTNLzoaYmfX1+9Yvq7IyT1Z5pc
M/9ddO1ZAe5T9ZupcE9r9Fmc9F+c9/hKSQ+PMRf71rzS992z6FyGHDkiQ6JT1/jTRRVsMsqRy3qa3cRd
M43jhIZBkY9CY5TO9XuLVGRrA0+rAEAP4hq6OUVep3ZhEzektCa6EURCR0x6nFPre7z11FZZve0TktXi
0R1j9HFeR9qykQLe0LhfZaH/Y4H2beArMpQNUfZqn2LGj6IMZpw3zn2GavrJsuaiwSErL1a6A8fpZr1/
vf58JtAa8MaSBiug6ZumYIzY3uAZpBfO+9EtZfqvcEqtzknJ971gQ1qqOWnTavVNzSwTkuw3kpy5zCC7
l12CdFFIzkBu1txKbyrMZepa9KsgLbG9N29iJTtWomnBWo0xA+uCr9+VC5cqsJO0gJvMjgIBTT4+fotM
XiAsJOH4knajYgN6ijwTYI1LN3dJl2mVDicrT0wu3YJi7MFPAXi8dQUOC4LUtFu58p4D5FzPsiIUGSb8
Zv5xSOhf6eNOtVEQje+BvAr1rFshtTbqtyG9afh1/rJ7p+qmb1tUOKI7L6+bp759BVKWooQ/oGPt6ION
qz1b1NJUsO/Df0SrZaJ+bep8GfswvSIl2f/PKoUxJjDO8Pk89NmVUHjG1FY4tpgaVj1sZe32soQl5/7t
IYJuVkRrLQ6nhSrxCkXXXRwuC/kgjGOPvUTNpx6TCgY9kTlxffC5UFvPWJ1PGd8fKQDYZ3VpnSe8zcp0
e1r92IqCM/ztrrlS/+trdp0XwAYDwPAAB1HAbipRW64L3aSudgaREVpMTIY5fTGIk5kXj/oB4UsoOhZJ
AMuiThH0rx4l1jYjL3ibE23ocmOcNYAdwNsg+TbG4uXLtAgNpOIuq5COe9BnooeA1dhnBbIkpjrpM79p
3Fo76gPa9jWrKGD9hFjgWQRDTsJniFkWs5QHJrCiFSjpqHGc4oJ0VYEhBmLXhfhjbG0qroCA6HsOdmqw
syfhHmK/TBion9/cpz37eMJuhXLd/ogOqkaeHY8hy7ZgnsqNg7+1aDxHmHdNihVCOoRx+g4XMTdKfHdO
xKhNut9fZ+REjQZzuc0iSkHvC4r699j+hZ7OSx4fk/A9x6wOKWWgS8HRsq66bIwTLDihCBYHQ0r/0I0G
IXlzwvWJc3ttCIeBWncDpFmqsje71NRalPwJHDv3Two4Ojr9ateCKvtb3AsDKgKHB8+siVHyAsgdGT34
wrm0O/bj/eOvy19VaxtKSYnaVezVOJe9PjqStJiFBU8G0Xar1Y135mgKrcx3BqIcLB/M5Q4SzZzGYy2S
hUkRwAesqgw5V8ewLid6WB1Hx54BujXeG48aNcUfv8U4MH4zuWIMT0jcqtFqf8M6oH6xdnsPN2GDUM1d
l3COYsbb9GZWE8eUT3QG7JsVLI/Cop74SfTlRyzaDMgGVTnlwbu03F3SweEH8n+QND4ZWkch1CPpN4IN
B/OVHjcKhibk3MavZd5ylnsWi3/pWDQmWsranpV5bo3Nppn59myIRDsh0H9xSh4AXf7TmzMClKbpgZhq
pxZebslTPLYeDxjnGq+TwyRZIip3VEkbUJb17i03PAJs/loQxkkrsv1b4HVhf8ja97xIAqF/XU77Vnpf
mNZt2r18ZQnBsw7I3r5MErR5aFnSLxAf8Qlf2ks3kBnkiM7b5GlyvsuZr0tXkOd610VYvrW7Gt/nGVn6
juKTUrC1HeXsjPTonEFoowCjaYBpG8mEf23gwYrH/1N5ew0qLROkTMvz5ryEZgoq9me15I4uI9ZfGjvk
p58ZN3163G5YOsSvZBi3iIWrpAs2Ljjkkl+TGJCQOaM9RqF8/BWLtX2Xzg9MuzikrFABA53LxNrBpr1y
gkRAEN3GdumxrMoFSHeROWnPvtmvRN+K83tIiQB0rhkXbYswlZqpqmcABqoA2+MoY+ScOgxe6TMc4U7v
4ILcG090G0AUEpTXiMuwovmSoUbsGrQQYg8In0IeKXgcp5q0PJFK0LK5xIUT1636/zfsyMOP36ZChmXf
6qfEKbta1ji3/LS1YGqzjEpe7POokJeQStUoQ6S0eMqKNYeEA5gCjVMfSA4Loz01uSnxPPoHPja//W36
l/ofwFYsIGY77LY4e3HdEH9UmD5n7pSjMt6+J4V2SqdqCMiMfKft7Ke7l9uAg4t/D6R83YiThSIV7vLC
/fskpTc/DVWxXeKB9X1V/OUR+vHRlsRzUWPNIfpnwigfmYJI2WNtYPfnxM0OhAs2oTisQKxODAFXgLkd
EKfttB4VZkh0Amo9njD5lz0c9AC1uKigOFgD8LgrMre2zLL3ys6kTfu5P9UcdpwbbFxiRTHB4+dlzoAQ
vHjX6v/JiYEMpoEsJYnnf++BWTyVPw8Ys6QvTJ6Ly7XhDV1jXhuw3x71/E7/jUnQ5c/BaWps1VtXCJLf
Q+9TPQTR8+sV6qK2Oh66K/IzokRgFyR/Fu5j1GIxqJg8KeX+YbhIYi45NoXKvVL7GbT+OhEjxfHa9eXL
T5AWaMwbwO3yPGUbm+EylNAMf4CSOZRpzRE4vMF9IsB+KS2dKN3Jn6fyZrdRlKBuetYetrSXaOKZEGFo
3Sh6my7M5kqZ2VBffvKAnHuOLyEeigE7qcGYm/xoDM6q4HUHXO4b0DRCATB2HBpcLlV7YfZxt8Eji67/
bpGQn1GvAjjQJLu4PZf80jsM8WGsHxg+f4ooZXCcsuWrVa04lLLcPQxXZVW7ZgIdW2nzIkGoBsA1RSti
EKLzVzSmiMzooDoWrFlIKe7K/pVpyqxLUBIauflC90mbVkj+HQ0Q5SAUZdnsw1ftqorDqcRAm2IgA7qt
uFu3TXsP1x4L6c3zQYa526ggSa25so0qbMDJdoWe3nM9TrlNDDDWmmcUpRRz8GRYJv5hebEMQFmX7CcQ
/hdx/2oyhUQAdhKJSI/Lx5ZpqBr9P/vkH7DlDAdD8e8m/JPpS0XyAtghW+ig7wH9U3TOcutjGdKQXyrQ
aMp2GpOSjBUmD2x/rgevcsVjq/GgjXjnWczanqDiitMfUFBbmDD9fHHSgquppn49UBuUnoq3HH35ssTk
yS05+xbSihyXgzYBWOheH6085fIh4Yp3UK6QcJknWUrBDgtjEty2v3AAsJVrWAr2T6S7bprERNkBE2iz
7rXDOO4OCXEyiM/kNdkXkuxDSBzCIhnvMBuDgyPDdub3fCCMzcLSZE7lcVdZXNj4DhjtErBw4ikf9N9O
iNbb1JE98BMvg+bk6PhDBbgDwWGs8KLe+0Iu44H8ELS4Xzhg7+pQ31MVRmWhI/DsD+AxD+rzoNZm+fSs
S10CvBhbGvFVqOp63CYy/jHNn4CAULHWEcXvi748qkdewgN3g+qoBED6ngjD2Ow0h/x+dWIqDl9TVeBA
VrZgAYUo/8OBaNsGqAbQhBBVf6wOyUviCC5MWwezKcyTUgtx4pFDbwuyU/KMTUgoQfY6dK3qEh21qsMz
5HxewUChljhSqUsbs19uFgl29S8T27oTWXn1Bef4P+azSQDHsKseGLJZ3j7x3CGjsr8LNdW5SDaWjTFB
GeSv/UxKD07Aa+ZeGPs7wWaoJTP8IwZBSZe70I7r7fqNbywcLpTrvwhwkEK//kZoTK+8nHcAmNfnU9WZ
M7Q1v+pwk4wV8d2fJ7bt+FWZr+KHHg9ZTv63Se2u3G3vna2x5pTlIOlewIhhFnEb0gDehQ0DKey1APkd
nfpxqYUhInQCsLoxblLxus/tGoqnL/UDNi2IdHvikTwDyoFUFwrs9YTs9wl/5ez5XyiUwlmlpobGS9dV
lDQvtN6Az+0LkTn9fFX8BMO02CM2dkg8Uoyedqtz+Kf52DSa3uk7M6+rHwNUPjq3jtV38d+khFenYs33
+z0TDE+ckzMVO8VvuJFqACqfAGhZnuIINcdgUbZjRaEnKvRao8uPnUoRxMFiM9mza6/Pj+SVVScPcdjn
59SCFn0/97qV3sbh3b/MN4kRgYs+yxz8Quk8nrWTQns8I9z9yE1KEpePDQA5FoGL7DRG0XrHKLAYoq5w
5P0De0ur5UJTDJskUOKcyc63zHQcP315Va+5UQdAUEV3/bvxNtgQkG9QX86xy7fMOE2/+Yn0jFzZQNrz
V74qeefSC2atjS1sGcSjvGP2xHg2kaWk82lamrLMA6PowFXCY4Kz11vCdI/jQIkjE8wksQn7CzB+/7cp
P2oDo4MpkS12UrwkhKPStxn1eyY3h7NH5VHZX+jund5SPqvTRSbatt//KzvVt7usLItrBWmwZd03uR30
+LXOqo19LzwEDp6MAjpHetYQTA+JXpDAfqTqmy9LNBQudlQmw0V8/AeqKtyKLmovEHO95pscEHGIdK78
tigfgj3583/HTZqpklsp1Ea8Aiu6mSQhjKim4KxfTXEoTj1rBcdw/iMYPNsQlgjQfagineZJu6q7bqH+
3M+fzkBxR35e/xStReaYJQZJfGip/BauzDqu+uD1TLLbQWsYorGJkRHiizkGke1ShaDKn4IXn/eB9p/9
kLffs4Xfh7cyUbCNsMiDBL44DfFhZUnf6OcrRmVyp5iU4cpVROSMVyfw8ikuJqjS/RhC4lL1aIovWlp6
a2acCDJwhjXK3VZZDQ35bnlqZU9vxXn0gfximv7ESZC/J8uqfVycPnQOkkHmLhrIZax4wKaeWkHexuuh
1Ny7KttFAiRmSDKtJKcUDol2ik8nkx4dMKzgId5bjzBilVT7ZmGJOYY4RfgYhPZV6oAtMTHYM55grauE
lSLg3SAgqNU6JAEXp1bWAtz7LbPIphMhDk3F3KrvQR011IDDFdNHEawB3abh9/KU1R5ZXhRUPBOg+I6s
8axx/+otAGEqZXEh0Wx6nZy6Bw3niNrkP7ZbI2c4f1V+E+W1OBAGEeicXiQKaCWueln+uYC55724bv8u
+DUxFw/0qDRiJGp5QPC5od/NcFfinObCqIGiZQsd+hchvUDAgLhOyRaSRR/z0GFqunxP0aKPpnFtdcND
1kHSRYDQ7xQT8AOn9oLjJ78Aj4vPWWtIfxs20uxubmxtZcK5ctFC4e8L1i1cCY1V8ENzM/LKiMMFsud0
Dmwqd6ietZD67Yu06N/GLBVAK3vOIXeC8YchZ3gjHbeYrX21BcpZiagGrkQicXQgDWlvsBwa8cOXVO3G
k1184co5ZpSB4VL0TtumT5FeCVQ0fJo5fenFI0FXNOkN76KHZBdSecsISud12HrsKRALQyjGZ3jJad/e
OlO0u3VrVOelNSiYmePnbH/BvlJb4h4QW4UmqbrDt+xa1m+LGEKlC5rvx2zA+r9E1qiHIVaeHVt3Adef
D5Kkue30Ijq+HbYN7P+dIZaZU7+HehpZSdftqvqgoUW0xi7aemNRdJtcHU8nC2k7rb7ooP7V3kh5NAQA
PrXpj2oRJar/u0GjR17acqeF/r7Vbl8cFdHi0b7za43zB/i3q5y0xOCcoiSkPeG/1z4oPkp9g+D4hCHS
cT4fhcQzl9M6h8Pz69er+zhD/E/okrxq1mD6aF/3QEg6lbPC9nc984ViajwVkhjs962rpuiX0GGlEgHx
YH0sIiOhnv1ql7Lb3Hn95ORIRR171f95aUi5TDrkV5xaKK0EWnKBf7qkoG3mAdeAlvBMuDekHGDod5GZ
a96E53XSkZz681Qy82pkqPWGFjAUUllt1pNgXqKk/sX5DsMyoIF+oWLLdR+5ip098L7VsXLa+C6UdG4M
bB338aNw6sN7KRv17ZMgWAVGAITFNLz/3PVn69y3LTBlxVdYEkAAA0CNbU//zn33///e//AQ==')));

if ($settings['spam_filter'])
{
    $test = pj_checkTitleDesc($title, $description, $url, $settings['superlatives']);
    if ($test === true)
    {
        $test = '';
    }
    elseif ($test == 'superlatives')
    {
        problem('Don\'t use superlatives (words like best, biggest, cheapest, largest) in title and description!');
    }
    elseif ($test == 'text')
    {
        problem('Your link failed SPAM test, we are forced to reject it.');
    }
    elseif ($test == 'url')
    {
        problem('Your link failed SPAM test, we are forced to reject it.');
    }
}

if ($settings['autosubmit'])
{
    session_start();
    if (empty($_SESSION['checked']))
    {
        $_SESSION['checked']  = 'N';
        $_SESSION['secnum']   = rand(10000,99999);
        $_SESSION['checksum'] = $_SESSION['secnum'].$settings['filter_sum'].date('dmy');
    }
    if ($_SESSION['checked'] == 'N')
    {
        print_secimg();
    }
    elseif ($_SESSION['checked'] == $settings['filter_sum'])
    {
        $_SESSION['checked'] = 'N';
        $secnumber = pj_isNumber($_POST['secnumber']);
        if(empty($secnumber))
        {
            print_secimg(1);
        }
        if (!check_secnum($secnumber,$_SESSION['checksum']))
        {
            print_secimg(2);
        }
    }
    else
    {
        problem('Internal script error. Wrong session parameters!');
    }
}

/* Check for duplicate links */
if ($settings['block_duplicates'])
{
    $mydata = file_get_contents($settings['linkfile']);

    /* Check website URL */
    $regex = str_replace(array('http://www.','http://'),'http://(www\.)?',$url);
    $regex = preg_replace('/index\.[^\/]+$/','',$regex);
    $regex = str_replace('/','\/',rtrim($regex,'/'));
    $regex = '/'.$regex.'\/?(index\.[^\/]+)?\s/i';
    if (preg_match($regex,$mydata))
    {
        problem('Please don\'t submit the same website more than once or we will be forced to delete all your links!');
    }

    /* Check reciprocal link URL */
    $regex = str_replace(array('http://www.','http://'),'http://(www\.)?',$recurl);
    $regex = preg_replace('/index\.[^\/]+$/','',$regex);
    $regex = str_replace('/','\/',rtrim($regex,'/'));
    $regex = '/'.$regex.'\/?(index\.[^\/]+)?\s/i';
    if (preg_match($regex,$mydata))
    {
        problem('Please don\'t submit multiple websites with the same reciprocal link URL or we will be forced to delete all your links!');
    }

    unset($mydata);
}

/* Get HTML code of the reciprocal link URL */
$html = @file_get_contents($recurl) or problem('Can\'t open remote URL!');
$html = strtolower($html);
$site_url = strtolower($settings['site_url']);

/* Block links with the meta "robots" noindex or nofollow tags? */
if ($settings['block_meta_rob']==1 && preg_match('/<meta([^>]+)(noindex|nofollow)(.*)>/siU',$html,$meta))
{
    problem(
        'Please don\'t place the reciprocal link to a page with the meta robots noindex or nofollow tag:<br />'.
        htmlspecialchars($meta[0])
    );
}

$found    = 0;
$nofollow = 0;

if (preg_match_all('/<a\s[^>]*href=([\"\']??)([^" >]*?)\\1([^>]*)>/siU', $html, $matches, PREG_SET_ORDER)) {
    foreach($matches as $match)
    {
        if ($match[2] == $settings['site_url'] || $match[2] == $settings['site_url'].'/')
        {
            $found = 1;
            if (strstr($match[3],'nofollow'))
            {
                $nofollow = 1;
            }
            break;
        }
    }
}

if ($found == 0)
{
    problem(
        'Our URL (<a href="'.$settings['site_url'].'">'.$settings['site_url'].
        '</a>) wasn\'t found on your reciprocal links page (<a href="'.$recurl.'">'.
        $recurl.'</a>)!<br><br>Please make sure you place this exact URL on your
        links page before submitting your link!'
    );
}

/* Block links with rel="nofollow" attribute? */
if ($settings['block_nofollow'] && $nofollow == 1)
{
    problem('Please don\'t use rel=&quot;nofollow&quot; link attribute for the reciprocal link!');
}

/* Check Google PageRank */
if ($settings['show_pr'] || $settings['min_pr'] || $settings['min_pr_rec'])
{
    require('pagerank.php');
    $pr = getpr($url);
    $pr = empty($pr) ? 0 : $pr;

    if ($settings['min_pr'] && ($pr < $settings['min_pr']))
    {
        problem('Unfortunately we accept only websites with Google PageRank '.$settings['min_pr'].'/10 or higher. Please try submitting your website again in a few months.');
    }

    if ($settings['min_pr_rec'])
    {
        $pr_rec = getpr($recurl);
        $pr_rec = empty($pr_rec) ? 0 : $pr_rec;
        if ($pr_rec < $settings['min_pr_rec'])
        {
            problem('Please place the reciprocal link to <a href="'.$settings['site_url'].'">'.$settings['site_url'].'</a> on a page with Google PageRank '.$settings['min_pr_rec'].'/10 or higher.');
        }
    }
}

$replacement = "$name$settings[delimiter]$email$settings[delimiter]$title$settings[delimiter]$url$settings[delimiter]$recurl$settings[delimiter]$description$settings[delimiter]0$settings[delimiter]$pr\n";

/* Approve manually */
if ($settings['man_approval'])
{
	$tmp = str_replace('www.','',strtolower($parsed_url['host']));
    $tmp = md5($tmp.$settings['filter_sum']);
    $tmp_file = 'apptmp/'.$tmp.'.txt';

    if (file_exists($tmp_file))
    {
    	problem('This link is already pending approval!');
    }

	$fp = fopen($tmp_file,'w') or problem('Couldn\'t open temporary file for writing! Please CHMOD the apptmp folder to 777 (rwxrwxrwx)!');
	flock($fp, LOCK_EX);
	fputs($fp,$replacement);
	flock($fp, LOCK_UN);
	fclose($fp);

$message = "Hello,

A new link is awaiting approval for your links page at $settings[site_url]

Link details:

Name: $name
E-mail: $email
URL: $url
Reciprocal link: $recurl
Title: $title
Description:
$description

To APPROVE the link visit this URL:
$settings[url_approval]?id=$tmp&approve=1

To REJECT the link visit this URL:
$settings[url_approval]?id=$tmp&approve=0


End of message

";
	$headers  = "From: $name <$email>\n";
	$headers .= "Reply-To: $name <$email>\n";
	mail($settings['admin_email'],'New link waiting approval',$message,$headers);

	require_once('header.txt');
	?>
	<p align="center"><b>Your link submitted for approval!</b></p>
	<p>&nbsp;</p>
	<p align="center">Thank you, your link has been submitted for approval and will appear on the links page once approved by the administrator!</p>
	<p>&nbsp;</p>
	<p>&nbsp;</p>
	<p align="center"><a href="<?php echo $settings['site_url']; ?>">Back to the main page</a></p>
	<?php
	require_once('footer.txt');
	exit();

}
/* Approve automatically */
else
{
	if ($settings['add_to'] == 0)
	{
	    /* Make sure new link is added after any featured ones */
		$i = 0;
        $was_added = 0;
		foreach ($lines as $thisline)
		{
			list($name2,$email2,$title2,$url2,$recurl2,$description2,$featured2,$pr2)=explode($settings['delimiter'],$thisline);
			$featured2 = $featured2 ? 1 : 0;
			if ($featured2 == 0)
			{
				$lines[$i] = $replacement . $thisline;
                $was_added = 1;
				break;
			}
			$i++;
		}

        if ($was_added)
        {
			$replacement = implode('',$lines);
		    $fp = fopen($settings['linkfile'],'w') or problem('Couldn\'t open links file for writing! Please CHMOD all txt files to 666 (rw-rw-rw)!');
		    flock($fp, LOCK_EX);
		    fputs($fp,$replacement);
		    flock($fp, LOCK_UN);
		    fclose($fp);
        }
		else
		{
		    $fp = fopen($settings['linkfile'],'a') or problem('Couldn\'t open links file for appending! Please CHMOD all txt files to 666 (rw-rw-rw)!');
		    flock($fp, LOCK_EX);
		    fputs($fp,$replacement);
		    flock($fp, LOCK_UN);
		    fclose($fp);
		}
	}
	else
	{
	    $fp = fopen($settings['linkfile'],'a') or problem('Couldn\'t open links file for appending! Please CHMOD all txt files to 666 (rw-rw-rw)!');
	    flock($fp, LOCK_EX);
	    fputs($fp,$replacement);
	    flock($fp, LOCK_UN);
	    fclose($fp);
	}

	if($settings['notify'] == 1)
	{
$message = "Hello,

Someone just added a new link to your links page on $settings[site_url]

Link details:

Name: $name
E-mail: $email
URL: $url
Reciprocal link: $recurl
Title: $title
Description:
$description


End of message

";
	    $headers  = "From: $name <$email>\n";
	    $headers .= "Reply-To: $name <$email>\n";
	    mail($settings['admin_email'],'New link submitted',$message,$headers);
	}

	require_once('header.txt');
	?>
	<p align="center"><b>Your link has been added!</b></p>
	<p>&nbsp;</p>
	<p align="center">Thank you, your link has been successfully added to our link exchange (try reloading our links page if you don't see your link there yet)!</p>
	<p>&nbsp;</p>
	<p>&nbsp;</p>
	<p align="center"><a href="<?php echo $settings['site_url']; ?>">Back to the main page</a></p>
	<?php
	require_once('footer.txt');
	exit();
}


/*** FUNCTION ***/

function problem($problem) {
require_once('header.txt');
echo '
    <p align="center"><font color="#FF0000"><b>ERROR</b></font></p>
    <p>&nbsp;</p>
    <p align="center">'.$problem.'</p>
    <p>&nbsp;</p>
    <p align="center"><a href="javascript:history.go(-1)">Back to the previous page</a></p>
';
require_once('footer.txt');
exit();
}

function print_secimg($message=0) {
global $settings;
$_SESSION['checked']=$settings['filter_sum'];
require_once('header.txt');
?>
<p>&nbsp;</p>

<p align="center"><b>Anti-SPAM check</b></p>

<div align="center"><center>
<table border="0">
<tr>
<td>
    <form action="addlink.php?<?php echo strip_tags(SID); ?>" method="POST" name="form">

    <hr>
    <?php
    if ($message == 1)
    {
        echo '<p align="center"><font color="#FF0000"><b>Please type in the security number</b></font></p>';
    }
    elseif ($message == 2)
    {
        echo '<p align="center"><font color="#FF0000"><b>Wrong security number. Please try again</b></font></p>';
    }
    ?>

    <p>This is a security check that prevents automated signups of this forum (SPAM).
    Please enter the security number displayed below into the input field and click the continue button.</p>

    <p>&nbsp;</p>

    <p>Security number: <b><?php echo $_SESSION['secnum']; ?></b><br>
    Please type in the security number displayed above:
    <input type="text" size="7" name="secnumber" maxlength="5"></p>

    <p>&nbsp;
    <?php
    foreach ($_POST as $k=>$v)
    {
        if ($k == 'secnumber')
        {
            continue;
        }
        echo '<input type="hidden" name="'.htmlspecialchars($k).'" value="'.htmlspecialchars(stripslashes($v)).'">';
    }
    ?>
    </p>

    <p align="center"><input type="submit" value=" Continue "></p>

    <hr>

    </form>
</td>
</tr>
</table>
</center></div>

<p>&nbsp;</p>
<p>&nbsp;</p>

<?php
require_once('footer.txt');
exit();
}

function check_secnum($secnumber,$checksum) {
    global $settings;
    $secnumber .= $settings['filter_sum'].date('dmy');
    if ($secnumber == $checksum)
    {
        unset($_SESSION['checked']);
        return true;
    }
    else
    {
        return false;
    }
}
?>
 