using System;
using System.Text;
using System.Reflection;
//using BF.Config;
using System.Configuration;
namespace BF.Data
{
	public class DatabaseProvider
	{
		private DatabaseProvider()
		{ }

		private static IDataProvider _instance = null;
		private static object lockHelper = new object();

		static DatabaseProvider()
		{
			GetProvider();
		}

		private static void GetProvider()
		{
			try
			{
				_instance = (IDataProvider)Activator.CreateInstance(Type.GetType(string.Format("BF.Data.{0}.DataProvider", BaseConfigs.GetDbType), false, true));
			}
			catch
			{
				throw new Exception("Web.configDbTypeڵݿǷȷ磺SqlServerAccess");
			}
		}

		public static IDataProvider GetInstance()
		{
			if (_instance == null)
			{
				lock (lockHelper)
				{
					if (_instance == null)
					{
						GetProvider();
					}
				}
			}
			return _instance;
		}

        public static void ResetDbProvider()
        {
            _instance = null; 
        }
	}
}
