using System;
using System.Data;
using System.Data.Common;

namespace BF.Data
{
    public interface IDbProvider
    {
        /// <summary>
        /// DbProviderFactoryʵ
        /// </summary>
        /// <returns></returns>
#if NET1        
		IDbProviderFactory Instance();
#else
        DbProviderFactory Instance();
#endif

        /// <summary>
        /// SQLϢ
        /// </summary>
        /// <param name="cmd"></param>
        void DeriveParameters(IDbCommand cmd);

        /// <summary>
        /// SQL
        /// </summary>
        /// <param name="ParamName"></param>
        /// <param name="DbType"></param>
        /// <param name="Size"></param>
        /// <returns></returns>
#if NET1  
		IDataParameter MakeParam(string ParamName, DbType DbType, Int32 Size);
#else
        DbParameter MakeParam(string ParamName, DbType DbType, Int32 Size);
#endif

        /// <summary>
        /// Ƿ֧ȫ
        /// </summary>
        /// <returns></returns>
        bool IsFullTextSearchEnabled();

        /// <summary>
        /// Ƿ֧ѹݿ
        /// </summary>
        /// <returns></returns>
        bool IsCompactDatabase();

        /// <summary>
        /// Ƿֱ֧ݿ
        /// </summary>
        /// <returns></returns>
        bool IsBackupDatabase();

        /// <summary>
        /// ظղ¼IDֵ, 粻֧Ϊ""
        /// </summary>
        /// <returns></returns>
        string GetLastIdSql();
        /// <summary>
        /// Ƿ֧ݿŻ
        /// </summary>
        /// <returns></returns>
        bool IsDbOptimize();
        /// <summary>
        /// Ƿ֧ݿ
        /// </summary>
        /// <returns></returns>
        bool IsShrinkData();
        /// <summary>
        /// Ƿִ֧洢
        /// </summary>
        /// <returns></returns>
        bool IsStoreProc();
    }
}
