﻿using System;
using System.Data;
using System.Data.OleDb;
using System.Data.Common;

using BF.Common;
using BF.Data;
namespace BF.Bll
{
    /// <summary>
    ///Feedback 留言反馈
    /// </summary>
    public class Feedback
    {
        public Feedback()
        {
            //
            //TODO: 在此处添加构造函数逻辑
            //
        }

        public bool Insert(string title, string content, string username, string userip,string headpic)
        {
            DbParameter[] parms = { 
               DbHelper.MakeInParam("@title",(DbType)OleDbType.VarWChar, 50, title),
               DbHelper.MakeInParam("@content",(DbType)OleDbType.VarWChar, 250, content),               
               DbHelper.MakeInParam("@username",(DbType)OleDbType.VarWChar, 20, username),
               DbHelper.MakeInParam("@userip",(DbType)OleDbType.VarWChar, 15, userip),
               DbHelper.MakeInParam("@headpic",(DbType)OleDbType.TinyInt,1,headpic)
            };
            string sql = "Insert Into Feedback (title,content,username,userip,headpic) values(@title,@content,@username,@userip,@headpic)";
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, parms) > 0;
        }

        /// <summary>
        /// 插入回复
        /// </summary>
        /// <param name="revert"></param>
        /// <param name="id"></param>
        /// <returns></returns>
        public bool InsertRevert(string revert, string id)
        {
            DbParameter[] parms = { 
               DbHelper.MakeInParam("@revert",(DbType)OleDbType.VarWChar, 250, revert),
               DbHelper.MakeInParam("@id",(DbType)OleDbType.Integer, 4, id)               
               
            };
            string sql = "Update Feedback set revert = @revert where id=@id";
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, parms) > 0;
        }

        /// <summary>
        /// 取得一行数据
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public DataRow GetDataRow(string id)
        {
            string sql = "Select *  From Feedback where id  = " + Utils.ChkSQL(id);
            DataSet ds = DbHelper.ExecuteDataset(sql);
            return ds.Tables[0].Rows[0];
        }

        /// <summary>
        /// 删除
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public bool Delete(string id)
        {
            string sql = "Delete From Feedback where id  = " + Utils.ChkSQL(id);
            return DbHelper.ExecuteNonQuery(sql) > 0;
        }

        /// <summary>
        /// 取得所有数据
        /// </summary>
        /// <returns></returns>
        public DataTable GetAllData()
        {
            string sql = "Select *  From [Feedback]  order by id desc";
            DataSet ds = DbHelper.ExecuteDataset(sql);
            return ds.Tables[0];
        }

    }
}