﻿using System;
using System.Data;
using System.Web;
using System.IO;
using System.Net;
using System.Text;

using BF.Common;
namespace BF.Bll
{
    /// <summary>
    ///HomePage ，导航页面类
    /// </summary>
    public class HomePage
    {
        private readonly static string _header;    //页首和页尾
        private readonly static string _footer;
        
        //三大搜索引擎
        private readonly static string _baidu;
        private readonly static string _google;
        private readonly static string _yahoo;

        private string _userName;
        private string _userDir;
        public HomePage()
        {


        }
        public HomePage(string userName)
        {
            this._userName = Utils.ChkSQL(userName);
            this._userDir = HttpContext.Current.Server.MapPath("~/U/" + _userName);
            if (!Directory.Exists(_userDir))
            {
                Directory.CreateDirectory(_userDir);
                if (!Directory.Exists(_userDir))
                {
                    this._userDir = "";
                }
            }

        }
        static HomePage()
        {
            //读取页头与页尾
            StreamReader sr = File.OpenText(HttpContext.Current.Server.MapPath("~/U/Header.htm"));
            _header = sr.ReadToEnd();
            sr.Close();
            sr = File.OpenText(HttpContext.Current.Server.MapPath("~/U/Footer.htm"));
            _footer = sr.ReadToEnd();
            sr.Close();
            sr = File.OpenText(HttpContext.Current.Server.MapPath("~/U/Baidu.htm"));
            _baidu = sr.ReadToEnd();
            sr.Close();
            sr = File.OpenText(HttpContext.Current.Server.MapPath("~/U/Google.htm"));
            _google = sr.ReadToEnd();
            sr.Close();
            sr = File.OpenText(HttpContext.Current.Server.MapPath("~/U/Yahoo.htm"));
            _yahoo = sr.ReadToEnd();
            sr.Close();
        }

        #region 从ASPX生成用户HTML
        /// <summary>
        /// 从ASPX生成用户HTML
        /// </summary>
        /// <param name="userName"></param>
        /// <returns></returns>
        public bool BuildHomePageFormAspx()
        {
            if (this._userDir == "") return false;
            WebClient web = new WebClient();
            web.DownloadFile(Utils.GetWebUrl() + "/U/HomePage.aspx?user=" + this._userName, this._userDir + "/default.htm");
            return true;
        }
        #endregion

        #region 从文件生成用户html
        /// <summary>
        /// 从文件生成用户html
        /// </summary>
        /// <returns></returns>
        public bool BuildHomePage()
        {
            HomePageConfig config = new HomePageConfig();
            DataRow row = config.GetDataRow(this._userName);
            string header = _header.Replace("{$Title}", row["SiteTitle"].ToString());
            header = header.Replace("{$UserName}", this._userName);

            string search = "<div id=\"search\">\n<!--搜索框开始-->\n{0}\n<!--搜索框结束-->\n</div>";
            switch (row["SearchEngine"].ToString().ToLower())
            {
                case "baidu":
                    search = string.Format(search, _baidu);
                    break;
                case "google":
                    search = string.Format(search, _google);
                    break;
                case "yahoo":
                    search = string.Format(search, _yahoo);
                    break;
                default:
                    search = "";
                    break;
            }

            try
            {
                StreamWriter sw = File.CreateText(this._userDir + "/index.htm");
                sw.Write(header);
                if (search != "")
                    sw.Write(search);
                sw.Write(ReadUserData(this._userName));
                sw.Write(_footer);
                sw.Close();
                return true;
            }
            catch
            {
                return false;
            }
        }
        #endregion

        #region 读取用户网址数据
        /// <summary>
        /// 读取用户网址数据
        /// </summary>
        /// <param name="userName"></param>
        /// <returns></returns>
        private string ReadUserData(string userName)
        {
            StringBuilder sb = new StringBuilder();
            UrlKind urlKind = new UrlKind();
            Url url = new Url();
            DataTable dtUrlKind = urlKind.GetDataByOwnerUser(userName);
            foreach (DataRow rowUrlKind in dtUrlKind.Rows)
            {
                if (rowUrlKind["VisitPwd"].ToString() == "")
                {
                    sb.AppendFormat("<div class=\"{0}\">\n", GetSkinClass(rowUrlKind["skin"].ToString()));
                    sb.Append("<div class=\"title\">\n");
                    sb.AppendFormat("<div class=\"left\">{0}</div>\n", rowUrlKind["Name"].ToString());
                    sb.Append("<div class=\"right\">&nbsp;</div>\n</div>\n");
                    sb.Append("<ul class=\"urllist\">\n");
                    //详细数据
                    DataTable dtUrl = url.GetDataByUrlKInd(rowUrlKind["ID"].ToString());
                    if (dtUrl.Rows.Count == 0)
                    {
                        sb.AppendFormat("<li class=\"ac\">该分类还没有添加网站！</li>");
                    }
                    else
                    {
                        foreach (DataRow rowUrl in dtUrl.Rows)
                        {
                            if (rowUrl["AllowShow"].ToString() == "1")
                                sb.AppendFormat("<li><a href=\"{0}\" target=\"_blank\" title=\"{1}\">{1}</a></li>\n", rowUrl["SiteUrl"].ToString(), rowUrl["SiteTitle"].ToString());
                        }
                    }
                    //完
                    sb.Append("</ul>\n<div class=\"cb\">\n</div>\n</div>");
                }
                else   //有密码
                {
                    sb.AppendFormat("<div class=\"{0}\">\n", GetSkinClass(rowUrlKind["skin"].ToString()));
                    sb.Append("<div class=\"title\">\n");
                    sb.AppendFormat("<div class=\"left\">{0}</div>\n", rowUrlKind["Name"].ToString());
                    sb.Append("<div class=\"right\">&nbsp;</div>\n</div>\n");
                    sb.AppendFormat("<ul id=\"ul{0}\" class=\"urllist\">\n", rowUrlKind["id"].ToString());
                    sb.AppendFormat("<div class=\"ac\">该分类需要密码查看：<input type=\"password\" id=\"txt{0}\" size=\"10\" onkeydown=\"EnterToSubmit('btn{0}')\" />&nbsp;<input type=\"button\" id=\"btn{0}\" onclick=\"view({0})\" value=\"提交\" /></div>\n", rowUrlKind["id"].ToString());
                    sb.AppendFormat("<div class=\"item_error\" id=\"info{0}\"></div>", rowUrlKind["id"].ToString()); //显示返回信息
                    sb.Append("</ul>\n<div class=\"cb\">\n</div>\n</div>");
                }

            }
            return sb.ToString();
        }

        /// <summary>
        /// 取得风格CLASS
        /// </summary>
        /// <param name="skin"></param>
        /// <returns></returns>
        private string GetSkinClass(string skin)
        {
            string skinName = "";
            switch (skin)
            {
                case "1":
                    skinName = "box_blue";
                    break;
                case "2":
                    skinName = "box_green";
                    break;
                case "3":
                    skinName = "box_orange";
                    break;
                default:
                    skinName = "box_blue";
                    break;
            }
            return skinName;
        }
        #endregion
    }
}