﻿using System;
using System.Data;
using System.Web;
using System.Data.OleDb;
using System.Data.Common;

using BF.Common;
using BF.Data;

namespace BF.Bll
{
    /// <summary>
    ///HomePageConfig，首页配置类
    /// </summary>
    public class HomePageConfig
    {
        public HomePageConfig()
        {
            //
            //TODO: 在此处添加构造函数逻辑
            //
        }
        /// <summary>
        /// 新增
        /// </summary>
        /// <param name="userName"></param>
        /// <param name="siteTitle"></param>
        /// <param name="searchEngine"></param>
        /// <returns></returns>
        public bool Insert(string userName,string siteTitle, string searchEngine)
        {
            DbParameter[] parms = { 
               DbHelper.MakeInParam("@userName",(DbType)OleDbType.VarWChar, 20, userName),
               DbHelper.MakeInParam("@siteTitle",(DbType)OleDbType.VarWChar, 20, siteTitle),
               DbHelper.MakeInParam("@searchEngine",(DbType)OleDbType.VarWChar, 10, searchEngine)                         
            };
            string sql = "Insert Into HomePageConfig (userName,siteTitle,searchEngine) values(@userName,@siteTitle,@searchEngine)";
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, parms) > 0;
        }
        /// <summary>
        /// 修改
        /// </summary>
        /// <param name="siteTitle"></param>
        /// <param name="searchEngine"></param>
        /// <param name="userName"></param>
        /// <returns></returns>
        public bool Update(string siteTitle, string searchEngine, string userName)
        {
            DbParameter[] parms = { 
               DbHelper.MakeInParam("@siteTitle",(DbType)OleDbType.VarWChar, 20, siteTitle),
               DbHelper.MakeInParam("@searchEngine",(DbType)OleDbType.VarWChar, 10, searchEngine),
               DbHelper.MakeInParam("@userName",(DbType)OleDbType.VarWChar, 20, userName),         
            };
            string sql = "Update HomePageConfig set siteTitle = @siteTitle,searchEngine = @searchEngine where userName = @userName ";
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, parms) > 0;
        }
        /// <summary>
        /// 删除
        /// </summary>
        /// <param name="userName"></param>
        /// <returns></returns>
        public bool Delete(string userName)
        {
            string sql = "Delete HomePageConfig where userName = @userName ";
            DbParameter[] parms = {                
               DbHelper.MakeInParam("@userName",(DbType)OleDbType.VarWChar, 20, userName)         
            };
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, parms) > 0;
        }

        /// <summary>
        /// 返回一行数据
        /// </summary>
        /// <param name="userName"></param>
        /// <returns></returns>
        public DataRow GetDataRow(string userName)
        {
            string sql = "Select * From HomePageConfig where userName = '" + Utils.ChkSQL(userName) + "'";
            DataSet ds = DbHelper.ExecuteDataset(sql);
            if (ds.Tables[0].Rows.Count > 0)
            {
                return ds.Tables[0].Rows[0];
            }
            else
            {
                return null;
            }
        }
    }
}