﻿using System;
using System.Data;
using System.Data.OleDb;
using System.Data.Common;

using BF.Data;
using BF.Common;


namespace BF.Bll
{
    /// <summary>
    ///Url 网址类
    /// </summary>
    public class Url
    {
        public Url()
        {
            //
            //TODO: 在此处添加构造函数逻辑
            //
        }

        /// <summary>
        /// 插入一行记录
        /// </summary>
        /// <param name="name"></param>
        /// <param name="skin"></param>
        /// <param name="visitPwd"></param>
        /// <param name="sn"></param>
        /// <param name="ownerUser"></param>
        /// <returns></returns>
        public bool Insert(string siteUrl, string siteTitle, string urlKindID, string sn)
        {
            DbParameter[] parms = { 
               DbHelper.MakeInParam("@siteUrl",(DbType)OleDbType.VarWChar, 250, siteUrl),
               DbHelper.MakeInParam("@siteTitle",(DbType)OleDbType.VarWChar, 50, siteTitle),               
               DbHelper.MakeInParam("@urlKindID",(DbType)OleDbType.Integer, 4, urlKindID),
               DbHelper.MakeInParam("@sn",(DbType)OleDbType.Integer, 4, sn)               
            };
            string sql = "Insert Into Url (siteUrl,siteTitle,urlKindID,sn) values(@siteUrl,@siteTitle,@urlKindID,@sn)";
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, parms) > 0;
        }

        /// <summary>
        /// 更新记录
        /// </summary>
        /// <param name="name"></param>
        /// <param name="skin"></param>
        /// <param name="visitPwd"></param>
        /// <param name="sn"></param>
        /// <param name="id"></param>
        /// <returns></returns>
        public bool Update(string siteUrl, string siteTitle, string urlKindID, string sn, string id)
        {
            DbParameter[] parms = { 
               DbHelper.MakeInParam("@siteUrl",(DbType)OleDbType.VarWChar, 250, siteUrl),
               DbHelper.MakeInParam("@siteTitle",(DbType)OleDbType.VarWChar, 50, siteTitle),               
               DbHelper.MakeInParam("@urlKindID",(DbType)OleDbType.Integer, 4, urlKindID), 
               DbHelper.MakeInParam("@sn",(DbType)OleDbType.Integer, 4, sn), 
               DbHelper.MakeInParam("@id",(DbType)OleDbType.Integer, 4, id)
            };
            string sql = "Update Url set siteUrl = @siteUrl,siteTitle = @siteTitle,urlKindID = @urlKindID,sn = @sn where id = @id";
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, parms) > 0;
        }

        /// <summary>
        /// 删除记录
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public bool Delete(string id)
        {
            string sql = "Delete From Url where id  = " + Utils.ChkSQL(id);
            return DbHelper.ExecuteNonQuery(sql) > 0;
        }


        /// <summary>
        /// 取得一行数据
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public DataRow GetDataRow(string id)
        {
            string sql = "Select *  From [Url] where id  = " + Utils.ChkSQL(id);
            DataSet ds = DbHelper.ExecuteDataset(sql);
            if (ds.Tables[0].Rows.Count > 0)
            {
                return ds.Tables[0].Rows[0];
            }
            else
            {
                return null;
            }
        }

        /// <summary>
        /// 根据所有者，返回数据
        /// </summary>
        /// <param name="userName"></param>
        /// <returns></returns>
        public DataTable GetDataByOwnerUser(string userName)
        {
            string sql = "Select *  From [Url] where OwnerUser  = '" + Utils.ChkSQL(userName) + "' order by sn";
            DataSet ds = DbHelper.ExecuteDataset(sql);
            return ds.Tables[0];
        }
        /// <summary>
        /// 根据分类，返回数据
        /// </summary>
        /// <param name="userName"></param>
        /// <returns></returns>
        public DataTable GetDataByUrlKInd(string urlKind)
        {
            string sql = "Select *  From [Url] where UrlKindID  = " + Utils.ChkSQL(urlKind) + " order by sn";
            DataSet ds = DbHelper.ExecuteDataset(sql);
            return ds.Tables[0];
        }

        /// <summary>
        /// 批量改变分类
        /// </summary>
        /// <param name="idlist">网址ID列表，格式为1,2,5,6……</param>
        /// <param name="urlKindID">分类id</param>
        /// <returns></returns>
        public int ChangeUrlKind(string idlist, string urlKindID)
        {
            string sql = string.Format("Update Url set UrlKindID = {0} where id in ({1})", urlKindID, idlist);
            return DbHelper.ExecuteNonQuery(sql);
        }

        /// <summary>
        /// 批量改变状态
        /// </summary>
        /// <param name="idlist"></param>
        /// <param name="status"></param>
        /// <returns></returns>
        public int ChangeStatus(string idlist, string status)
        {
            string sql = string.Format("Update Url set AllowShow = {0} where id in ({1})", status, idlist);
            return DbHelper.ExecuteNonQuery(sql);
        }

        /// <summary>
        /// 批量删除
        /// </summary>
        /// <param name="idlist"></param>
        /// <returns></returns>
        public int BatchDelete(string idlist)
        {
            string sql = string.Format("Delete From Url where id  in({0})", idlist);
            return DbHelper.ExecuteNonQuery(sql);
        }
    }
}