﻿using System;
using System.Data;
using System.Data.OleDb;
using System.Data.Common;

using BF.Data;
using BF.Common;


namespace BF.Bll
{
    /// <summary>
    ///UrlKind 的摘要说明
    /// </summary>
    public class UrlKind
    {
        public UrlKind()
        {
            //
            //TODO: 在此处添加构造函数逻辑
            //
        }

        /// <summary>
        /// 插入一行记录
        /// </summary>
        /// <param name="name"></param>
        /// <param name="skin"></param>
        /// <param name="visitPwd"></param>
        /// <param name="sn"></param>
        /// <param name="ownerUser"></param>
        /// <returns></returns>
        public bool Insert(string name, string skin, string visitPwd, string sn, string ownerUser)
        {
            DbParameter[] parms = { 
               DbHelper.MakeInParam("@name",(DbType)OleDbType.VarWChar, 20, name),
               DbHelper.MakeInParam("@skin",(DbType)OleDbType.TinyInt, 1, skin),
               DbHelper.MakeInParam("@visitPwd",(DbType)OleDbType.VarWChar, 10, visitPwd),
               DbHelper.MakeInParam("@sn",(DbType)OleDbType.Integer, 4, sn),
               DbHelper.MakeInParam("@ownerUser",(DbType)OleDbType.VarWChar, 20, ownerUser)
            };
            string sql = "Insert Into UrlKind (name,skin,visitPwd,sn,ownerUser) values(@name,@skin,@visitPwd,@sn,@ownerUser)";
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, parms) > 0;
        }

        /// <summary>
        /// 更新记录
        /// </summary>
        /// <param name="name"></param>
        /// <param name="skin"></param>
        /// <param name="visitPwd"></param>
        /// <param name="sn"></param>
        /// <param name="id"></param>
        /// <returns></returns>
        public bool Update(string name, string skin, string visitPwd, string sn, string id)
        {
            DbParameter[] parms = { 
               DbHelper.MakeInParam("@name",(DbType)OleDbType.VarWChar, 20, name),
               DbHelper.MakeInParam("@skin",(DbType)OleDbType.TinyInt, 1, skin),
               DbHelper.MakeInParam("@visitPwd",(DbType)OleDbType.VarWChar, 10, visitPwd),
               DbHelper.MakeInParam("@sn",(DbType)OleDbType.Integer, 4, sn),
               DbHelper.MakeInParam("@id",(DbType)OleDbType.Integer, 4, id)
            };
            string sql = "Update UrlKind set name = @name,skin = @skin,visitPwd = @visitPwd,sn = @sn where id = @id";
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, parms) > 0;
        }

        /// <summary>
        /// 删除记录
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public bool Delete(string id)
        {
            string sql = "Delete From UrlKind where id  = " + Utils.ChkSQL(id);
            return DbHelper.ExecuteNonQuery(sql) > 0;
        }


        /// <summary>
        /// 取得一行数据
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public DataRow GetDataRow(string id)
        {
            string sql = "Select *  From UrlKind where id  = " + Utils.ChkSQL(id);
            DataSet ds = DbHelper.ExecuteDataset(sql);
            if (ds.Tables[0].Rows.Count > 0)
            {
                return ds.Tables[0].Rows[0];
            }
            else
            {
                return null;
            }
        }

        /// <summary>
        /// 根据所有者，返回数据
        /// </summary>
        /// <param name="userName"></param>
        /// <returns></returns>
        public DataTable GetDataByOwnerUser(string userName)
        {
            string sql = "Select *  From UrlKind where OwnerUser  = '" + Utils.ChkSQL(userName) + "' order by sn";
            DataSet ds = DbHelper.ExecuteDataset(sql);
            return ds.Tables[0];
        }

        /// <summary>
        /// 取得该分类所对应的网址数
        /// </summary>
        /// <param name="kindid"></param>
        /// <returns></returns>
        public int GetUrlCount(string kindid)
        {
            string sql = "Select count(id) From Url where UrlKindID  = " + Utils.ChkSQL(kindid);
            object data = DbHelper.ExecuteScalar(CommandType.Text, sql);
            if (data == null)
            {
                return 0;
            }
            else
            {
                return (int)data;
            }
        }
        /// <summary>
        /// 根据所有者，返回ListItemCollection
        /// </summary>
        /// <param name="kindid"></param>
        /// <returns></returns>
        public System.Web.UI.WebControls.ListItem[] GetListItemByOwnerUser(string userName)
        {
            System.Web.UI.WebControls.ListItemCollection ltc = new System.Web.UI.WebControls.ListItemCollection();
            string sql = "Select Name,ID  From UrlKind where OwnerUser  = '" + Utils.ChkSQL(userName) + "' order by sn";
            DataSet ds = DbHelper.ExecuteDataset(sql);
            foreach (DataRow row in ds.Tables[0].Rows)
            {
                ltc.Add(new System.Web.UI.WebControls.ListItem(row["Name"].ToString(), row["ID"].ToString()));
            }
            System.Web.UI.WebControls.ListItem[] arrLt = new System.Web.UI.WebControls.ListItem[ltc.Count];
            if (arrLt.Length > 0)
            {
                ltc.CopyTo(arrLt, 0);
            }
            return arrLt;
        }

        /// <summary>
        /// 检验查看密码是否正确
        /// </summary>
        /// <param name="kindID"></param>
        /// <param name="pwd"></param>
        /// <returns></returns>
        public bool CheckKindPwd(string kindID, string pwd)
        {
            string sql = string.Format("Select id from UrlKind where ID = {0} and VisitPwd = '{1}'", Utils.ChkSQL(kindID), Utils.ChkSQL(pwd));
            return DbHelper.ExecuteScalar(CommandType.Text, sql) != null;

        }
    }
}