﻿using System;
using System.Data;
using System.Data.Common;
using System.Data.OleDb;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;

using BF.Common;
using BF.Data;
namespace BF.Bll
{
    /// <summary>
    ///UserInfo 的摘要说明
    /// </summary>
    public class UserInfo
    {
        public UserInfo()
        {
            //
            //TODO: 在此处添加构造函数逻辑
            //
        }

        /// <summary>
        /// 检测是否存在此用户名
        /// </summary>
        /// <param name="userName"></param>
        /// <returns></returns>
        public bool Exists(string userName)
        {
            string sql = "Select userName from UserInfo where UserName = '" + Utils.ChkSQL(userName) + "'";
            return DbHelper.ExecuteScalar(CommandType.Text, sql) != null;
        }

        /// <summary>
        /// 插入一条记录
        /// </summary>
        /// <param name="userName"></param>
        /// <param name="userPwd"></param>
        /// <param name="email"></param>
        /// <returns></returns>
        public bool Insert(string userName, string userPwd, string email)
        {
            DbParameter[] parms = { 
               DbHelper.MakeInParam("@userName",(DbType)OleDbType.VarWChar, 20, userName),
               DbHelper.MakeInParam("@userPwd",(DbType)OleDbType.VarWChar, 50, userPwd),
               DbHelper.MakeInParam("@email",(DbType)OleDbType.VarWChar, 50, email)               
            };
            string sql = "Insert Into UserInfo (UserName,UserPwd,Email) values(@userName,@userPwd,@email)";
            return DbHelper.ExecuteNonQuery(CommandType.Text,sql,parms) > 0;
        }

        /// <summary>
        /// 更新数据
        /// </summary>
        /// <param name="userName"></param>
        /// <param name="userPwd"></param>
        /// <param name="email"></param>
        /// <returns></returns>
        public bool Update(string userName, string userPwd, string email)
        {
            DbParameter[] parms = {                
               DbHelper.MakeInParam("@userPwd",(DbType)OleDbType.VarWChar, 50, userPwd),
               DbHelper.MakeInParam("@email",(DbType)OleDbType.VarWChar, 50, email),
               DbHelper.MakeInParam("@userName",(DbType)OleDbType.VarWChar, 20, userName)             
            };
            string sql = "Update UserInfo set UserPwd = @userPwd,Email = @email where UserName = @userName";
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, parms) > 0;
        }

        /// <summary>
        /// 检测用户登录
        /// </summary>
        /// <param name="userName"></param>
        /// <param name="userPwd"></param>
        /// <returns></returns>
        public bool CheckLogin(string userName, string userPwd)
        {
            string sql = "Select userName from UserInfo where UserName = '" + Utils.ChkSQL(userName) + "' and UserPwd = '" + userPwd + "'";
            return DbHelper.ExecuteScalar(CommandType.Text, sql) != null;
        }

        /// <summary>
        /// 取得最近注册用户数据
        /// </summary>
        /// <param name="num"></param>
        /// <returns></returns>
        public DataTable GetNewUserInfo(int num)
        {
            string sql = string.Format("Select top {0} UserName ,RegDate From UserInfo  order by RegDate desc", num);
            return DbHelper.ExecuteDataset(sql).Tables[0];
        }

        /// <summary>
        /// 取得注册用户数
        /// </summary>
        /// <returns></returns>
        public int GetUserCount()
        {
            string sql = "Select count(username) from UserInfo";
            return (int)DbHelper.ExecuteScalar(CommandType.Text, sql);
        }

        /// <summary>
        /// 取得用户数据
        /// </summary>
        /// <param name="userName"></param>
        /// <returns></returns>
        public DataRow GetDataRow(string userName)
        {
            string sql = "Select * from UserInfo where userName = '" + Utils.ChkSQL(userName) + "'";
            DataSet ds = DbHelper.ExecuteDataset(sql);
            if (ds.Tables[0].Rows.Count > 0)
            {
                return ds.Tables[0].Rows[0];
            }
            else
            {
                return null;
            }
        }
    }
}