using System;
using System.Web;

namespace BF.Common
{
	/// <summary>
	/// Request
	/// </summary>
	public class DNTRequest
	{
		/// <summary>
		/// жϵǰҳǷյPost
		/// </summary>
		/// <returns>ǷյPost</returns>
		public static bool IsPost()
		{
			return HttpContext.Current.Request.HttpMethod.Equals("POST");
		}
		/// <summary>
		/// жϵǰҳǷյGet
		/// </summary>
		/// <returns>ǷյGet</returns>
		public static bool IsGet()
		{
			return HttpContext.Current.Request.HttpMethod.Equals("GET");
		}

		/// <summary>
		/// ָķϢ
		/// </summary>
		/// <param name="strName"></param>
		/// <returns>Ϣ</returns>
		public static string GetServerString(string strName)
		{
			//
			if (HttpContext.Current.Request.ServerVariables[strName] == null)
			{
				return "";
			}
			return HttpContext.Current.Request.ServerVariables[strName].ToString();
		}

		/// <summary>
		/// һҳĵַ
		/// </summary>
		/// <returns>һҳĵַ</returns>
		public static string GetUrlReferrer()
		{
			string retVal = null;
    
			try
			{
				retVal = HttpContext.Current.Request.UrlReferrer.ToString();
			}
			catch{}
			
			if (retVal == null)
				return "";
    
			return retVal;

		}
		
		/// <summary>
		/// õǰͷ
		/// </summary>
		/// <returns></returns>
		public static string GetCurrentFullHost()
		{
			HttpRequest request = System.Web.HttpContext.Current.Request;
			if (!request.Url.IsDefaultPort)
			{
				return string.Format("{0}:{1}", request.Url.Host, request.Url.Port.ToString());
			}
			return request.Url.Host;
		}

		/// <summary>
		/// õͷ
		/// </summary>
		/// <returns></returns>
		public static string GetHost()
		{
			return HttpContext.Current.Request.Url.Host;
		}


		/// <summary>
		/// ȡǰԭʼ URL(URL Ϣ֮Ĳ,ѯַ())
		/// </summary>
		/// <returns>ԭʼ URL</returns>
		public static string GetRawUrl()
		{
			return HttpContext.Current.Request.RawUrl;
		}

		/// <summary>
		/// жϵǰǷ
		/// </summary>
		/// <returns>ǰǷ</returns>
		public static bool IsBrowserGet()
		{
			string[] BrowserName = {"ie", "opera", "netscape", "mozilla", "konqueror", "firefox"};
			string curBrowser = HttpContext.Current.Request.Browser.Type.ToLower();
			for (int i = 0; i < BrowserName.Length; i++)
			{
				if (curBrowser.IndexOf(BrowserName[i]) >= 0)
				{
					return true;
				}
			}
			return false;
		}

		/// <summary>
		/// жǷ
		/// </summary>
		/// <returns>Ƿ</returns>
		public static bool IsSearchEnginesGet()
		{
            if (HttpContext.Current.Request.UrlReferrer == null)
            {
                return false;
            }
		    string[] SearchEngine = {"google", "yahoo", "msn", "baidu", "sogou", "sohu", "sina", "163", "lycos", "tom", "yisou", "iask", "soso", "gougou", "zhongsou"};
			string tmpReferrer = HttpContext.Current.Request.UrlReferrer.ToString().ToLower();
			for (int i = 0; i < SearchEngine.Length; i++)
			{
				if (tmpReferrer.IndexOf(SearchEngine[i]) >= 0)
				{
					return true;
				}
			}
			return false;
		}

		/// <summary>
		/// õǰUrlַ
		/// </summary>
		/// <returns>ǰUrlַ</returns>
		public static string GetUrl()
		{
			return HttpContext.Current.Request.Url.ToString();
		}
		

		/// <summary>
		/// ָUrlֵ
		/// </summary>
		/// <param name="strName">Url</param>
		/// <returns>Urlֵ</returns>
		public static string GetQueryString(string strName)
		{
			if (HttpContext.Current.Request.QueryString[strName] == null)
			{
				return "";
			}
			return HttpContext.Current.Request.QueryString[strName];
		}

		/// <summary>
		/// õǰҳ
		/// </summary>
		/// <returns>ǰҳ</returns>
		public static string GetPageName()
		{
			string [] urlArr = HttpContext.Current.Request.Url.AbsolutePath.Split('/');
			return urlArr[urlArr.Length - 1].ToLower();
		}

		/// <summary>
		/// رUrlܸ
		/// </summary>
		/// <returns></returns>
		public static int GetParamCount()
		{
			return HttpContext.Current.Request.Form.Count + HttpContext.Current.Request.QueryString.Count;
		}


		/// <summary>
		/// ֵָ
		/// </summary>
		/// <param name="strName"></param>
		/// <returns>ֵ</returns>
		public static string GetFormString(string strName)
		{
			if (HttpContext.Current.Request.Form[strName] == null)
			{
				return "";
			}
			return HttpContext.Current.Request.Form[strName];
		}

		/// <summary>
		/// Urlֵ, жUrlǷΪַ, ΪTrue򷵻رֵ
		/// </summary>
		/// <param name="strName"></param>
		/// <returns>Urlֵ</returns>
		public static string GetString(string strName)
		{
			if ("".Equals(GetQueryString(strName)))
			{
				return GetFormString(strName);
			}
			else
			{
				return GetQueryString(strName);
			}
		}


		/// <summary>
		/// ָUrlintֵ
		/// </summary>
		/// <param name="strName">Url</param>
		/// <param name="defValue">ȱʡֵ</param>
		/// <returns>Urlintֵ</returns>
		public static int GetQueryInt(string strName, int defValue)
		{
			return Utils.StrToInt(HttpContext.Current.Request.QueryString[strName], defValue);
		}


		/// <summary>
		/// ָintֵ
		/// </summary>
		/// <param name="strName"></param>
		/// <param name="defValue">ȱʡֵ</param>
		/// <returns>intֵ</returns>
		public static int GetFormInt(string strName, int defValue)
		{
			return Utils.StrToInt(HttpContext.Current.Request.Form[strName], defValue);
		}

		/// <summary>
		/// ָUrlintֵ, жUrlǷΪȱʡֵ, ΪTrue򷵻رֵ
		/// </summary>
		/// <param name="strName">Url</param>
		/// <param name="defValue">ȱʡֵ</param>
		/// <returns>Urlintֵ</returns>
		public static int GetInt(string strName, int defValue)
		{
			if (GetQueryInt(strName, defValue) == defValue)
			{
				return GetFormInt(strName, defValue);
			}
			else
			{
				return GetQueryInt(strName, defValue);
			}
		}

		/// <summary>
		/// ָUrlfloatֵ
		/// </summary>
		/// <param name="strName">Url</param>
		/// <param name="defValue">ȱʡֵ</param>
		/// <returns>Urlintֵ</returns>
		public static float GetQueryFloat(string strName, float defValue)
		{
			return Utils.StrToFloat(HttpContext.Current.Request.QueryString[strName], defValue);
		}


		/// <summary>
		/// ָfloatֵ
		/// </summary>
		/// <param name="strName"></param>
		/// <param name="defValue">ȱʡֵ</param>
		/// <returns>floatֵ</returns>
		public static float GetFormFloat(string strName, float defValue)
		{
			return Utils.StrToFloat(HttpContext.Current.Request.Form[strName], defValue);
		}
		
		/// <summary>
		/// ָUrlfloatֵ, жUrlǷΪȱʡֵ, ΪTrue򷵻رֵ
		/// </summary>
		/// <param name="strName">Url</param>
		/// <param name="defValue">ȱʡֵ</param>
		/// <returns>Urlintֵ</returns>
		public static float GetFloat(string strName, float defValue)
		{
			if (GetQueryFloat(strName, defValue) == defValue)
			{
				return GetFormFloat(strName, defValue);
			}
			else
			{
				return GetQueryFloat(strName, defValue);
			}
		}

		/// <summary>
		/// õǰҳͻ˵IP
		/// </summary>
		/// <returns>ǰҳͻ˵IP</returns>
		public static string GetIP()
		{


			string result = String.Empty;

			result = HttpContext.Current.Request.ServerVariables["HTTP_X_FORWARDED_FOR"];
			if (null == result || result == String.Empty)
			{
				result = HttpContext.Current.Request.ServerVariables["REMOTE_ADDR"];
			}

			if (null == result || result == String.Empty)
			{
				result = HttpContext.Current.Request.UserHostAddress;
			}

			if (null == result || result == String.Empty || !Utils.IsIP(result))
			{
				return "0.0.0.0";
			}

			return result;

		}

		/// <summary>
		/// ûϴļ
		/// </summary>
		/// <param name="path">·</param>
		public static void SaveRequestFile(string path)
		{
			if (HttpContext.Current.Request.Files.Count > 0)
			{
				HttpContext.Current.Request.Files[0].SaveAs(path);
			}
		}

//		/// <summary>
//		/// ϴļ
//		/// </summary>
//		/// <param name="MaxAllowFileCount">ϴļ</param>
//		/// <param name="MaxAllowFileSize">ļ(λ: KB)</param>
//		/// <param name="AllowFileExtName">ļչ, string[]ʽṩ</param>
//		/// <param name="AllowFileType">ļ, string[]ʽṩ</param>
//		/// <param name="Dir">Ŀ¼</param>
//		/// <returns></returns>
//		public static Forum.AttachmentInfo[] SaveRequestFiles(int MaxAllowFileCount, int MaxAllowFileSize, string[] AllowFileExtName, string[] AllowFileType, string Dir)
//		{
//			int savefilecount = 0;
//			
//			int fcount = Math.Min(MaxAllowFileCount, HttpContext.Current.Request.Files.Count);
//
//			Forum.AttachmentInfo[] attachmentinfo = new Forum.AttachmentInfo[fcount];
//			for(int i=0;i<fcount;i++)
//			{
//				string filename = HttpContext.Current.Request.Files[i].FileName;
//				string fileextname = filename.Substring(filename.LastIndexOf("."));
//				string filetype = HttpContext.Current.Request.Files[i].ContentType;
//				int filesize = HttpContext.Current.Request.Files[i].ContentLength;
//				// ж ļչ/ļС/ļ ǷҪ
//				if(Utils.InArray(fileextname, AllowFileExtName) && (filesize <= MaxAllowFileSize * 1024) && Utils.InArray(filetype, AllowFileType))
//				{
//
//					HttpContext.Current.Request.Files[i].SaveAs(Dir + Utils.GetDateTime() + Environment.TickCount.ToString() + fileextname);
//					attachmentinfo[savefilecount].Filename = filename;
//					attachmentinfo[savefilecount].Filesize = filesize;
//					attachmentinfo[savefilecount].Description = filetype;
//					attachmentinfo[savefilecount].Filetype = fileextname;
//					savefilecount++;
//				}
//			}
//			return attachmentinfo;
//			
//		}

	}
}
