using System;
using System.Collections.Generic;
using System.Text;
using System.Web.UI;
using System.Web;
using System.Web.UI.WebControls;
using System.Data;

namespace BF.Common
{
    public  partial class Utils
    {
        #region TextĿֵ
        /// <summary>
        /// TextؼĿֵ
        /// add by mb 2006.7.28
        /// </summary>
        /// <param name="container"></param>
        public static void ClearTrim(Control container)
        {
            foreach (Control ctrl in container.Controls)
            {
                if (ctrl.Controls.Count > 0)
                {
                    ClearTrim(ctrl);
                }
                else
                {
                    if (ctrl is TextBox)
                    {
                        ((TextBox)ctrl).Text = ((TextBox)ctrl).Text.Trim(); continue;
                    }
                }
            }
        }
        #endregion

        #region зؼֵ
        /// <summary>
        /// зؼֵ
        /// </summary>
        /// <param name="container"></param>
        public static void ClearControls(Control container)
        {
            foreach (Control ctrl in container.Controls)
            {
                if (ctrl.Controls.Count > 0)
                {
                    ClearControls(ctrl);
                }
                else
                {
                    if (ctrl is HiddenField)
                    {
                        ((HiddenField)ctrl).Value = ""; continue;
                    }
                    if (ctrl is Label)
                    {
                        ((Label)ctrl).Text = ""; continue;
                    }
                    if (ctrl is TextBox)
                    {
                        ((TextBox)ctrl).Text = ""; continue;
                    }
                    if (ctrl is DropDownList)
                    {
                        if (((DropDownList)ctrl).Items.Count > 0)
                        {
                            ((DropDownList)ctrl).SelectedIndex = 0;
                            continue;
                        }
                    }
                }

            }
        }
        #endregion

        #region еĿؼسԶTab
        public static void EnterToTab(Control Container)
        {
            foreach (Control ctrl in Container.Controls)
            {
                if (ctrl is TextBox)
                {
                    ((TextBox)ctrl).Attributes.Add("onkeydown", "EnterToTab()");
                }
                if (ctrl is DropDownList)
                {
                    ((DropDownList)ctrl).Attributes.Add("onkeydown", "EnterToTab()");
                }
            }
        }
        public static void EnterToTab(TextBox txtbox)
        {
            txtbox.Attributes.Add("onkeydown", "EnterToTab()");
        }
        public static void EnterToTab(DropDownList drp)
        {
            drp.Attributes.Add("onkeydown", "EnterToTab()");
        }
        #endregion

        #region سύ
        /// <summary>
        /// سύ
        /// </summary>
        /// <param name="txtbox"></param>
        /// <param name="btnID">ҪύİťID</param>
        public static void EnterToSubmit(TextBox txtbox, string btnID)
        {
            txtbox.Attributes.Add("onkeydown", "EnterToSubmit('" + btnID + "')");
        }
        #endregion

        #region ռEnabled

        /// <summary>
        /// ռEnabled
        /// </summary>
        /// <param name="container"></param>
        /// <param name="isEnabled"></param>
        public static void DisnableControl(Control container, bool isEnabled)
        {
            foreach (Control ctrl in container.Controls)
            {
                if (ctrl.Controls.Count > 0)
                {
                    DisnableControl(ctrl, isEnabled);
                }
                if (ctrl is TextBox)
                {
                    ((TextBox)ctrl).Enabled = isEnabled; continue;
                }
                if (ctrl is DropDownList)
                {
                    ((DropDownList)ctrl).Enabled = isEnabled; continue;
                }
            }
        }

        #endregion

        #region dropdownlist
        /// <summary>
        /// ݵDropDownList
        /// </summary>
        /// <param name="ds"></param>
        /// <param name="dw"></param>
        /// <param name="text"></param>
        /// <param name="value"></param>
        /// <returns></returns>
        public static void drpBind(DataSet ds, DropDownList dw, string text, string value)
        {
            dw.Items.Clear();
            foreach (DataRow row in ds.Tables[0].Rows)
            {
                dw.Items.Add(new ListItem(row[text].ToString(), row[value].ToString()));
            }
        }
        /// <summary>
        /// ݵDropDownList,һΪԶ
        /// </summary>
        /// <param name="ds"></param>
        /// <param name="dw"></param>
        /// <param name="text"></param>
        /// <param name="value"></param>
        /// <param name="firstText"></param>
        /// <param name="firstValue"></param>
        /// <returns></returns>
        public static void drpBind(DataSet ds, DropDownList dw, string text, string value, string firstText, string firstValue)
        {
            dw.Items.Clear();
            dw.Items.Add(new ListItem(firstText, firstValue));
            foreach (DataRow row in ds.Tables[0].Rows)
            {
                dw.Items.Add(new ListItem(row[text].ToString(), row[value].ToString()));
            }
        }
        #endregion

        #region ûIP
        /// <summary>
        /// ûIP
        /// </summary>
        public static string GetUserIp()
        {
            string ip;
            string[] temp;
            bool isErr = false;
            if (System.Web.HttpContext.Current.Request.ServerVariables["HTTP_X_ForWARDED_For"] == null)
                ip = System.Web.HttpContext.Current.Request.ServerVariables["REMOTE_ADDR"].ToString();
            else
                ip = System.Web.HttpContext.Current.Request.ServerVariables["HTTP_X_ForWARDED_For"].ToString();
            if (ip.Length > 15)
                isErr = true;
            else
            {
                temp = ip.Split('.');
                if (temp.Length == 4)
                {
                    for (int i = 0; i < temp.Length; i++)
                    {
                        if (temp[i].Length > 3) isErr = true;
                    }
                }
                else
                    isErr = true;
            }

            if (isErr)
                return "1.1.1.1";
            else
                return ip;
        }
        #endregion

        #region дcookieֵ
        /// <summary>
        /// дcookieֵ
        /// </summary>
        /// <param name="strName"></param>
        /// <param name="strValue">ֵ</param>
        public static void WriteCookie(string strName, string strValue)
        {
            HttpCookie cookie = HttpContext.Current.Request.Cookies[strName];
            if (cookie == null)
            {
                cookie = new HttpCookie(strName);
            }
            cookie.Value = strValue;
            HttpContext.Current.Response.AppendCookie(cookie);

        }

        /// <summary>
        /// дcookieֵ
        /// </summary>
        /// <param name="strName"></param>
        /// <param name="strValue">ֵ</param>
        /// <param name="strValue">ʱ()</param>
        public static void WriteCookie(string strName, string strValue, int expires)
        {
            HttpCookie cookie = HttpContext.Current.Request.Cookies[strName];
            if (cookie == null)
            {
                cookie = new HttpCookie(strName);
            }
            cookie.Value = strValue;
            cookie.Expires = DateTime.Now.AddMinutes(expires);
            HttpContext.Current.Response.AppendCookie(cookie);

        }
        #endregion

        #region cookieֵ
        /// <summary>
        /// cookieֵ
        /// </summary>
        /// <param name="strName"></param>
        /// <returns>cookieֵ</returns>
        public static string GetCookie(string strName)
        {
            if (HttpContext.Current.Request.Cookies != null && HttpContext.Current.Request.Cookies[strName] != null)
            {
                return HttpContext.Current.Request.Cookies[strName].Value.ToString();
            }

            return "";
        }
        #endregion
    }
}
