﻿using System;
using System.Data;
using System.Data.Common;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections;
using System.Text.RegularExpressions;

namespace BF.Web.Page
{

    /// <summary>
    /// dbPage 的摘要说明
    /// </summary>
    public class BasePage : System.Web.UI.Page
    {
        //protected Hashtable WebConfig; //网站配置
        public BasePage()
        {
            //
            // TODO: 在此处添加构造函数逻辑
            //
        }
        #region 所有页面初始分都分配一数据库操作实例
        //protected override void OnInit(EventArgs e)
        //{
        //    Session["UserName"] = "admin";
        //}
        #endregion

        #region 覆盖系统默认的错误页
        protected override void OnError(EventArgs e)
        {
            HttpContext ctx = HttpContext.Current;
            Exception exception = ctx.Server.GetLastError();
            Response.Write("捕获到异常，原因：");
            if (exception is HttpRequestValidationException)
            {
                Response.Write("输入的字符当中有非法字符！（如中括号“<”……）");
                Response.Write("\t<a href=\"javascript:history.go(-1)\">返回</a>");
                Response.End();
            }
            //if (exception is FormatException)
            //{

            //    Response.Write("无效的日期或数字格式！");
            //    Response.Write("\t<a href=\"javascript:history.go(-1)\">返回</a>");
            //    Response.End();
            //}
            //if (exception is System.Data.SqlClient.SqlException)
            //{

            //    Response.Write("输入了过长的字符串！");
            //    Response.Write("\t<a href=\"javascript:history.go(-1)\">返回</a>");
            //    Response.End();
            //}
            //string errorInfo = "程序运行时出现意外错误" +
            //    "<br>Offending URL: " + ctx.Request.Url.ToString() +
            //    "<br>Source: " + exception.Source +
            //    "<br>Message: " + exception.Message +
            //    "<br>Stack trace: " + exception.StackTrace;

            //ctx.Response.Write(errorInfo);
            //ctx.Server.ClearError();
            base.OnError(e);
        }
        #endregion

        #region 在客户端显示弹出对话框
        /// <summary>
        /// 在客户端显示弹出对话框。
        /// </summary>
        /// <param name="msg">要显示的信息。</param>
        public void Alert(string msg)
        {
            this.ClientScript.RegisterStartupScript(this.GetType(), "alert", "alert('" + msg + "');", true);
        }

        /// <summary>
        /// 在客户端显示弹出对话框1。
        /// </summary>
        /// <param name="name">脚本块标识。当同一页面要调用两个弹出框时需不同的标识，否则后者会覆盖前者。</param>
        /// <param name="msg">要显示的信息。</param>
        public void Alert(string name, string msg)
        {
            this.ClientScript.RegisterStartupScript(this.GetType(), name, "alert('" + msg + "');", true);
        }


        /// <summary>
        /// 在客户端显示弹出对话框1。
        /// </summary>
        /// <param name="name">脚本块标识。当同一页面要调用两个弹出框时需不同的标识，否则后者会覆盖前者。</param>
        /// <param name="msg">要显示的信息。</param>
        public void Alert(Control up, string name, string msg)
        {

            ScriptManager.RegisterStartupScript(up, typeof(UpdatePanel), name, "alert('" + msg + "');", true);
            //ScriptManager.RegisterStartupScript(this.Page, this.GetType(), name, "alert('" + msg + "');", true);
        }
        #endregion

        #region 在客户端执行一段脚本
        /// <summary>
        /// 在客户端执行一段脚本。
        /// </summary>
        /// <param name="name">脚本框表示。</param>
        /// <param name="cmd">要执行的命令。</param>
        public void JsExe(string name, string cmd)
        {
            this.ClientScript.RegisterStartupScript(this.GetType(), name, "<script language=\"javascript\">" + cmd + ";</script>");
        }


        /// <summary>
        /// 在客户端运行脚本1。
        /// </summary>
        /// <param name="name">脚本块标识。当同一页面要调用两个弹出框时需不同的标识，否则后者会覆盖前者。</param>
        /// <param name="msg">要显示的信息。</param>
        public void JsExe(Control up, string name, string js)
        {

            ScriptManager.RegisterStartupScript(up, typeof(UpdatePanel), name, js, true);
        }

        public void JsExeC(Control up, string name, string js)
        {

            ScriptManager.RegisterClientScriptBlock(up, typeof(UpdatePanel), name, js, true);
        }
        #endregion

        #region 判断验证码是否符合要求
        /// <summary>
        /// 判断验证码是否符合要求
        /// </summary>
        /// <param name="code">用户输入的验证码</param>
        /// <returns>返回验证码是否正确</returns>
        public bool CheckValidateCode(string code)
        {
            try
            {
                if (code.ToUpper() != Session["validate_code"].ToString().ToUpper()) return false;
                return true;
            }
            catch (Exception e)
            {
                e.ToString();
                return false;
            }
        }
        #endregion

        #region 取得当前页号码
        public static int GetCurrentPageIndex()
        {
            int currentPageIndex = 1;
            string page = HttpContext.Current.Request.QueryString["page"];
            if (page != null)
            {
                if (IsInt(page))
                    currentPageIndex = int.Parse(page);
            }
            return currentPageIndex;

        }

        public static bool IsInt(string str)
        {
            if (str == null) return false;
            return Regex.IsMatch(str, @"^[0-9]+$");
        }
        #endregion

        #region 保存登录状态
        /// <summary>
        /// 保存登录状态到Cookies，关闭浏览器消失。
        /// </summary>
        /// <param name="userName"></param>
        protected void SaveLoginStatus(string userName)
        {
            Session["UserName"] = userName;
            HttpCookie ck = new HttpCookie("UserInfo");
            ck["UserName"] = HttpUtility.UrlEncode(userName);
            ck["UserPwd"] = "No";
            ck["LastVisit"] = DateTime.Now.Date.ToShortDateString();    //上次存取日期
            Response.Cookies.Add(ck);
        }
        /// <summary>
        /// 保存登录状态到Cookies，保存一段时间
        /// </summary>
        /// <param name="userName"></param>
        /// <param name="userPwd"></param>
        /// <param name="saveDay"></param>
        protected void SaveLoginStatus(string userName, string userPwd, int saveDay)
        {
            Session["UserName"] = userName;
            HttpCookie ck = new HttpCookie("UserInfo");
            ck.Expires = DateTime.Now.AddDays(saveDay);
            ck["UserName"] = HttpUtility.UrlEncode(userName);
            ck["UserPwd"] = userPwd;
            ck["LastVisit"] = DateTime.Now.Date.ToShortDateString();    //上次存取日期
            Response.Cookies.Add(ck);
        }
        #endregion

        #region 清除登录状态
        protected void ClearLoginStatu()
        {
            Session.Clear();            
            HttpCookie ck = new HttpCookie("UserInfo");            
            Response.Cookies.Add(ck);
        }
        #endregion

        #region 取得分页数据
        protected PagedDataSource GetPagedData(DataTable dtAll, int pageSize, int currentPageIndex)
        {
            PagedDataSource pds = new PagedDataSource();
            pds.AllowPaging = true;
            pds.DataSource = dtAll.DefaultView;
            pds.CurrentPageIndex = currentPageIndex - 1;
            pds.PageSize = pageSize;
            return pds;
        }
        #endregion

        #region 缓存数据
        /// <summary>
        /// 缓存数据
        /// </summary>
        /// <param name="key">键</param>
        /// <param name="data">数据</param>
        /// <param name="expirationMinute">弹性过期时间</param>
        protected void CacheData(string key, object data, int expirationMinute)
        {
            Cache.Insert(key + "_" + Session.SessionID, data, null, System.Web.Caching.Cache.NoAbsoluteExpiration, TimeSpan.FromMinutes(expirationMinute), System.Web.Caching.CacheItemPriority.Default, null);
        }

        /// <summary>
        /// 取得缓存数据
        /// </summary>
        /// <param name="key"></param>
        /// <returns></returns>
        protected object GetCacheData(string key)
        {
            return Cache[key + "_" + Session.SessionID];
        }

        /// <summary>
        /// 移除缓存
        /// </summary>
        /// <param name="key"></param>
        protected void CacheRemove(string key)
        {
            if (Cache[key + "_" + Session.SessionID] != null)
                Cache.Remove(key + "_" + Session.SessionID);
        }
        #endregion

    }
}
