﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;

using BF.Bll;
namespace BF.Web.Page
{
    /// <summary>
    ///UserPage，用户页面
    /// </summary>
    public class UsersPage : BasePage
    {
        public UsersPage()
        {
            //
            //TODO: 在此处添加构造函数逻辑
            //
        }
        protected override void OnInit(EventArgs e)
        {            
            CheckLoginStatus();
        }


        

        #region 检测登录状态
         /// <summary>
        /// 检测登录状态
        /// </summary>
        protected  void CheckLoginStatus()
        {
            if (Session["UserName"] == null || Session["UserName"].ToString() == "")
            {
                if (Request.Cookies["UserInfo"] == null)
                {
                    NeedLogin();
                    return;
                }
                HttpCookie ck = Request.Cookies["UserInfo"];
                string lastVisitTime = ck["LastVisit"].ToString();
                string userName = HttpUtility.UrlDecode(ck["UserName"]);
                string userPwd = ck["UserPwd"];
                if (lastVisitTime == null || userPwd == null || userName == "")
                {
                    NeedLogin();
                    return;
                }
                //当天登录过
                if (lastVisitTime == DateTime.Now.Date.ToShortDateString())
                {
                    Session["UserName"] = userName;
                }
                else
                {
                    UserInfo userInfo = new UserInfo();
                    if (userInfo.CheckLogin(userName, userPwd))
                    {
                        Session["UserName"] = userName;
                        ck["LastVisit"] = DateTime.Now.Date.ToShortDateString();
                        Response.Cookies.Set(ck);
                    }
                    else  //Cookies中的密码错误
                    {
                        NeedLogin();
                        return;
                    }
                }

            }
        }

        /// <summary>
        /// 需要登录的提示
        /// </summary>
        private void NeedLogin()
        {
            Response.Write("<script type='text/javascript'>alert('对不起，您还没有登录或已超时，请重新登录！');top.location.href='/UserLogin.aspx';</script>");
            Response.End();
            
        }
        #endregion
       
    }
}